/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.NIOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;

public class WorkingFile
extends File {
    File final_file;
    private static final String TEMP_SUFFIX = ".tmp";
    private PrintStream ps = null;
    private boolean append_mode = false;
    private boolean scratch_dir_mode = false;

    public WorkingFile(String filename) {
        super(filename + TEMP_SUFFIX);
        this.final_file = new File(filename);
        this.append_mode = false;
        this.scratch_dir_mode = false;
    }

    public WorkingFile(String filename, File scratch_dir) {
        super(scratch_dir, filename + TEMP_SUFFIX);
        this.final_file = new File(filename);
        this.append_mode = false;
        this.scratch_dir_mode = true;
    }

    public WorkingFile(String filename, boolean append) {
        super(append ? filename : filename + TEMP_SUFFIX);
        this.final_file = new File(filename);
        this.append_mode = append;
        this.scratch_dir_mode = false;
    }

    private String temp_setup(String filename, boolean append) {
        String result = append ? filename : filename + TEMP_SUFFIX;
        return result;
    }

    public void finish() {
        if (this.ps != null) {
            this.ps.close();
        }
        if (!this.append_mode) {
            this.final_file.delete();
            if (this.scratch_dir_mode) {
                try {
                    NIOUtils.copyFile(this, this.final_file);
                    super.delete();
                }
                catch (IOException e) {
                    System.err.println("ERROR copying file: " + e);
                }
            } else if (!this.renameTo(this.final_file)) {
                System.err.println("error renaming to " + this.final_file.getAbsolutePath());
            }
        }
    }

    public File get_file() {
        return this.final_file;
    }

    public boolean delete() {
        boolean v = this.final_file.delete();
        if (!v) {
            System.err.println("can't delete " + this.final_file);
        }
        return v;
    }

    public PrintStream getPrintStream() throws FileNotFoundException, IOException {
        if (this.ps == null) {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this, this.append_mode));
            String path = this.getAbsolutePath();
            int gzi = path.lastIndexOf(".gz");
            this.ps = gzi == path.length() - (this.append_mode ? 0 : TEMP_SUFFIX.length()) - 3 ? new PrintStream(new GZIPOutputStream(os)) : new PrintStream(os);
        }
        return this.ps;
    }

    public static void main(String[] argv) {
        try {
            WorkingFile wf = new WorkingFile("some_output.txt", new File("c:/temp/"));
            PrintStream ps = wf.getPrintStream();
            ps.println("line1");
            ps.println("line2");
            ps.println("line3");
            ps.close();
            try {
                System.err.println("sleeping...");
                Thread.sleep(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            wf.finish();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

