/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMReadQuery;
import java.util.ArrayList;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedJobQueue<T> {
    private TreeMap<Integer, ArrayList<T>> queue;
    private int job_count;

    public SortedJobQueue() {
        this.reset();
    }

    public TreeMap<Integer, ArrayList<T>> get_queue() {
        return this.queue;
    }

    public void reset() {
        this.queue = new TreeMap();
        this.job_count = 0;
    }

    public boolean add(T job, int site) {
        ArrayList<Object> bucket = this.queue.get(site);
        if (bucket == null) {
            bucket = new ArrayList();
            this.queue.put(site, bucket);
        }
        ++this.job_count;
        return bucket.add(job);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public T next() {
        T result = null;
        Integer key = this.queue.firstKey();
        if (key != null) {
            ArrayList<T> bucket = this.queue.get(key);
            if (bucket.size() > 0) {
                result = bucket.remove(0);
            }
            if (bucket.size() == 0) {
                this.queue.remove(key);
            }
        }
        return result;
    }

    public int get_job_count() {
        return this.job_count;
    }

    public int get_job_count_manual() {
        int count = 0;
        for (Integer key : this.queue.keySet()) {
            count += this.queue.get(key).size();
        }
        return count;
    }

    public static void main(String[] argv) {
        SortedJobQueue<SAMReadQuery> sjq = new SortedJobQueue<SAMReadQuery>();
        SAMReadQuery x = new SAMReadQuery("one_read1", 1, true);
        sjq.add(x, 1);
        sjq.add(new SAMReadQuery("one_read2", 1, true), 1);
        sjq.add(new SAMReadQuery("2_read1", 2, true), 2);
        int count = 0;
        while (!sjq.isEmpty()) {
            SAMReadQuery q = (SAMReadQuery)sjq.next();
            System.err.println("q=" + q.readName + " at " + q.alignmentStart);
            if (++count != 1) continue;
            sjq.add(new SAMReadQuery("one_read3", 1, true), 1);
        }
    }
}

