/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SampleMatchInfo;
import Ace2.SampleNamingConvention;
import Ace2.TumorNormal;
import java.util.HashMap;

public class Sample {
    SampleMatchInfo smi = new SampleMatchInfo();
    private static HashMap<String, Sample> samples;

    public Sample() {
    }

    public Sample(String sample_id) {
        this.set_sample_id(sample_id);
    }

    public void set_sample_id(String sample_id) {
        this.parse_id(sample_id);
    }

    private void parse_id(String sample_id) {
        boolean matches_convention = false;
        for (SampleNamingConvention snc : SampleNamingConvention.get_known_conventions()) {
            if (!snc.matches(sample_id)) continue;
            System.err.println(sample_id + " matches naming convention: " + snc.convention_name);
            this.smi = snc.get_match_info();
            matches_convention = true;
            System.err.println("  sample_name: " + this.smi.sample_name);
            System.err.print("           tn: " + (Object)((Object)this.smi.tumor_normal));
            if (this.smi.tumor_normal.equals((Object)TumorNormal.TUMOR)) {
                System.err.print(" (recurrent: " + this.smi.is_recurrent + ")");
            }
            System.err.println("");
            System.err.println("         desc: " + this.smi.description);
            System.err.println("    recurrent: " + this.smi.is_recurrent);
            break;
        }
        if (!matches_convention) {
            this.smi.sample_name = sample_id;
        }
    }

    public static Sample get_sample(String sample_id) {
        Sample result;
        if (samples == null) {
            samples = new HashMap();
        }
        if ((result = samples.get(sample_id)) == null) {
            result = new Sample(new String(sample_id));
            samples.put(sample_id, result);
        }
        return result;
    }

    public String get_sample_name() {
        return this.smi == null ? null : this.smi.sample_name;
    }

    public boolean is_normal() {
        return this.smi != null && this.smi.tumor_normal != null && this.smi.tumor_normal.equals((Object)TumorNormal.NORMAL);
    }

    public boolean is_tumor() {
        return this.smi != null && this.smi.tumor_normal != null && this.smi.tumor_normal.equals((Object)TumorNormal.TUMOR);
    }

    public String get_description() {
        return this.smi.description;
    }

    public void reset_tumor_normal() {
        this.smi = new SampleMatchInfo();
    }

    public void set_normal(boolean v) {
        this.smi.tumor_normal = TumorNormal.NORMAL;
    }

    public void set_tumor(boolean v) {
        if (this.smi == null) {
            this.smi = new SampleMatchInfo();
        }
        this.smi.tumor_normal = TumorNormal.TUMOR;
    }

    public void set_recurrent() {
        if (this.smi == null) {
            this.smi = new SampleMatchInfo();
        }
        this.smi.tumor_normal = TumorNormal.TUMOR;
        this.smi.is_recurrent = true;
    }

    public TumorNormal get_tumornormal() {
        return this.smi.tumor_normal;
    }

    public boolean is_recurrent() {
        return this.smi.is_recurrent;
    }
}

