/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMTagCounter {
    static int REPORT_INTERVAL = 100000;
    HashMap<String, Integer> saw;
    HashMap<String, HashSet<Object>> saw_values;
    int read_count;
    private boolean print_unique_mode = false;

    public void set_print_unique_mode(boolean b) {
        this.print_unique_mode = b;
    }

    public void count(SamReader reader, HashSet<String> wanted) {
        this.saw = new HashMap();
        this.saw_values = new HashMap();
        this.read_count = 0;
        for (SAMRecord sr : reader) {
            if (++this.read_count % REPORT_INTERVAL == 0) {
                this.report();
            }
            for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                if (!wanted.contains(tav.tag)) continue;
                Integer count = this.saw.get(tav.tag);
                if (count == null) {
                    count = 0;
                }
                this.saw.put(tav.tag, count + 1);
                if (!this.print_unique_mode) continue;
                HashSet<Object> sv = this.saw_values.get(tav.tag);
                if (sv == null) {
                    sv = new HashSet();
                    this.saw_values.put(tav.tag, sv);
                }
                if (sv.contains(tav.value)) continue;
                System.err.println(tav.tag + " " + tav.value);
                sv.add(tav.value);
            }
        }
        System.err.println("done:");
        this.report();
    }

    private void report() {
        System.err.println("reads:" + this.read_count);
        for (String key : this.saw.keySet()) {
            System.err.println(key + ": " + this.saw.get(key));
        }
    }

    public static void main(String[] argv) {
        SAMTagCounter counter = new SAMTagCounter();
        HashSet<String> wanted = new HashSet<String>();
        SamReader reader = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(new File(argv[++i]));
                continue;
            }
            if (argv[i].equals("-tag")) {
                wanted.add(argv[++i]);
                continue;
            }
            if (argv[i].equals("-print-unique")) {
                counter.set_print_unique_mode(true);
                continue;
            }
            System.err.println("unknown argument " + argv[i]);
            System.exit(1);
        }
        if (reader == null) {
            System.err.println("specify -bam");
        } else if (wanted.size() == 0) {
            System.err.println("specify -tag [-tag ...]");
        } else {
            counter.count(reader, wanted);
        }
    }
}

