/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.FASTAIndexedFAI;
import Ace2.KnownGenomeBuild;
import Ace2.LongCounter;
import Ace2.ReferenceSequence;
import Ace2.Reporter;
import Ace2.SAMResource;
import Ace2.SAMResourceTags;
import Ace2.SAMUtils;
import Ace2.TwoBitFile;
import Funk.Str;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMReport {
    public static void main(String[] argv) {
        SAMResource sres = null;
        boolean max = false;
        try {
            CloseableIterator<SAMRecord> iterator = null;
            boolean find_small_alignments = false;
            int fsa_min_size = 0;
            boolean find_non_primary = false;
            boolean scan_mapq = false;
            boolean count_n_tag = false;
            boolean get_run_date = false;
            boolean get_sample_names = false;
            boolean get_assembly = false;
            boolean detect_rna = false;
            boolean find_name = false;
            boolean find_min_aligned = false;
            String outfile = null;
            int max_reads = 0;
            int min_match_length = 0;
            int max_mismatches = 0;
            ReferenceSequence rs = null;
            String bam_file = null;
            boolean mask_matching_sequence = false;
            String search_name = null;
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    bam_file = argv[++i];
                    sres = new SAMResource();
                    sres.import_data(SAMResourceTags.SAM_URL, bam_file);
                    sres.detect_sample_id();
                    iterator = sres.get_iterator();
                    continue;
                }
                if (argv[i].equals("-2bit")) {
                    rs = new TwoBitFile(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-fasta")) {
                    rs = new FASTAIndexedFAI(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-find-min-aligned")) {
                    find_min_aligned = true;
                    min_match_length = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-mask")) {
                    mask_matching_sequence = true;
                    continue;
                }
                if (argv[i].equals("-max-mismatches")) {
                    max_mismatches = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-find-small-alignments")) {
                    find_small_alignments = true;
                    fsa_min_size = Integer.parseInt(argv[++i]);
                    Integer min_size = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-find-non-primary")) {
                    find_non_primary = true;
                    continue;
                }
                if (argv[i].equals("-scan-mapq")) {
                    scan_mapq = true;
                    continue;
                }
                if (argv[i].equals("-of") || argv[i].equals("-outfile")) {
                    outfile = argv[++i];
                    continue;
                }
                if (argv[i].equals("-count-N-tag")) {
                    count_n_tag = true;
                    continue;
                }
                if (argv[i].equals("-get-run-date")) {
                    get_run_date = true;
                    continue;
                }
                if (argv[i].equals("-get-assembly")) {
                    get_assembly = true;
                    continue;
                }
                if (argv[i].equals("-get-sample-names")) {
                    get_sample_names = true;
                    continue;
                }
                if (argv[i].equals("-detect-rna")) {
                    detect_rna = true;
                    max_reads = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-find-read-name")) {
                    find_name = true;
                    search_name = argv[++i];
                    continue;
                }
                System.err.println("ERROR: unknown parameter " + argv[i]);
                System.exit(1);
            }
            if (iterator == null) {
                System.err.println("specify -bam");
            } else if (find_small_alignments) {
                SAMReport.find_small_blocks(iterator, fsa_min_size);
            } else if (find_min_aligned) {
                if (rs == null) {
                    System.err.println("ERROR: specify reference sequence (-2bit / -fasta)");
                } else if (outfile == null) {
                    System.err.println("ERROR: specify -outfile");
                } else {
                    SAMReport.find_min_aligned(new File(bam_file), rs, min_match_length, max_mismatches, new File(outfile), mask_matching_sequence);
                }
            } else if (find_non_primary) {
                SAMReport.find_non_primary(iterator);
            } else if (scan_mapq) {
                SAMReport.scan_mapq(iterator, sres.get_file(), outfile);
            } else if (count_n_tag) {
                SAMReport.count_n_tag(iterator);
            } else if (get_run_date) {
                SAMReport.get_run_date(sres.getSamReader());
            } else if (get_sample_names) {
                SAMReport.get_sample_names(sres.getSamReader());
            } else if (get_assembly) {
                SAMReport.get_assembly(sres.getSamReader());
            } else if (detect_rna) {
                SAMReport.detect_rna(iterator, max_reads);
            } else if (find_name) {
                SAMReport.find_read_name(iterator, search_name);
            } else {
                System.err.println("option??");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void count_n_tag(CloseableIterator<SAMRecord> iterator) {
        long count = 0L;
        block0: while (iterator.hasNext()) {
            SAMRecord sr = (SAMRecord)iterator.next();
            for (CigarElement ce : sr.getCigar().getCigarElements()) {
                CigarOperator co = ce.getOperator();
                if (!co.equals((Object)CigarOperator.SKIPPED_REGION)) continue;
                ++count;
                continue block0;
            }
        }
        System.out.println(count);
    }

    public static void scan_mapq_OLD(CloseableIterator<SAMRecord> iterator, File file) {
        LongCounter lc = new LongCounter(255);
        while (iterator.hasNext()) {
            SAMRecord sr = (SAMRecord)iterator.next();
            if (sr.getReadUnmappedFlag() || sr.getDuplicateReadFlag() || sr.getNotPrimaryAlignmentFlag()) continue;
            lc.increment(sr.getMappingQuality());
        }
        try {
            int percentile;
            Reporter rpt = new Reporter();
            rpt.add_header("filename");
            rpt.add_header("median");
            for (percentile = 0; percentile <= 100; percentile += 10) {
                rpt.add_header(Integer.toString(percentile));
            }
            rpt.set_value("filename", file.getAbsolutePath());
            rpt.set_value("median", Integer.toString(lc.get_median()));
            for (percentile = 0; percentile <= 100; percentile += 10) {
                rpt.set_value(Integer.toString(percentile), Integer.toString(lc.get_fraction((double)percentile / 100.0)));
            }
            rpt.end_row();
            rpt.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void scan_mapq(CloseableIterator<SAMRecord> iterator, File file, String outfile) {
        int MAX_VALUE = 255;
        LongCounter lc = new LongCounter(MAX_VALUE);
        while (iterator.hasNext()) {
            SAMRecord sr = (SAMRecord)iterator.next();
            if (sr.getReadUnmappedFlag() || sr.getDuplicateReadFlag() || sr.getNotPrimaryAlignmentFlag()) continue;
            lc.increment(sr.getMappingQuality());
        }
        try {
            Reporter rpt = new Reporter();
            if (outfile != null) {
                rpt.set_output_filename(outfile);
            }
            rpt.add_header("mapq");
            rpt.add_header("count");
            long[] tracker = lc.get_array();
            for (int i = 0; i <= MAX_VALUE; ++i) {
                rpt.set_value("mapq", Integer.toString(i));
                rpt.set_value("count", Long.toString(tracker[i]));
                rpt.end_row();
            }
            rpt.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void find_non_primary(CloseableIterator<SAMRecord> iterator) {
        while (iterator.hasNext()) {
            SAMRecord sr = (SAMRecord)iterator.next();
            if (!sr.getNotPrimaryAlignmentFlag()) continue;
            System.err.println("non-primary " + SAMUtils.get_printable_read_name(sr) + " at " + sr.getAlignmentStart());
        }
    }

    public static void find_min_aligned(File bam_in, ReferenceSequence rs, int min_match_length, int max_mismatches, File bam_out, boolean mask) throws IOException {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam_in);
        SAMFileHeader header_in = reader.getFileHeader();
        SAMFileWriter sfw = new SAMFileWriterFactory().makeBAMWriter(header_in, false, bam_out, 1);
        System.err.println("minimum alignment length: " + min_match_length);
        System.err.println("      maximum mismatches: " + max_mismatches);
        int last_ri = -1;
        byte[] ref = null;
        int count_usable = 0;
        int count_rejected_length = 0;
        int count_rejected_mismatches = 0;
        int count_unmapped = 0;
        for (SAMRecord sr : reader) {
            if (sr.getReadUnmappedFlag()) {
                ++count_unmapped;
                continue;
            }
            int ri = sr.getReferenceIndex();
            if (ri != last_ri) {
                String rn = sr.getReferenceName();
                System.err.println("reading reference sequence: " + rn);
                ref = rs.get_all(rn);
                System.err.println("refence sequence length=" + ref.length);
                last_ri = ri;
            }
            int aligned = 0;
            int mismatches = 0;
            byte[] read_bases = sr.getReadBases();
            if (mask) {
                byte[] clone = new byte[read_bases.length];
                System.arraycopy(read_bases, 0, clone, 0, read_bases.length);
                read_bases = clone;
            }
            for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                int blen = ab.getLength();
                aligned += blen;
                int read_i = ab.getReadStart() - 1;
                int end = read_i + blen;
                for (int ref_i = ab.getReferenceStart() - 1; read_i < end && ref_i < ref.length; ++read_i, ++ref_i) {
                    char read_base;
                    char ref_base = Character.toUpperCase((char)ref[ref_i]);
                    if (ref_base != (read_base = Character.toUpperCase((char)read_bases[read_i]))) {
                        ++mismatches;
                    }
                    if (!mask) continue;
                    read_bases[read_i] = 78;
                }
            }
            if (aligned < min_match_length) {
                ++count_rejected_length;
                continue;
            }
            if (mismatches > max_mismatches) {
                ++count_rejected_mismatches;
                continue;
            }
            if (mask) {
                sr.setReadBases(read_bases);
            }
            sfw.addAlignment(sr);
            ++count_usable;
        }
        sfw.close();
        System.err.println("usable:" + count_usable + " rejected_mismatches:" + count_rejected_mismatches + " rejected_length:" + count_rejected_length + " unmapped:" + count_unmapped);
    }

    public static void find_small_blocks(CloseableIterator<SAMRecord> iterator, int min_size) {
        while (iterator.hasNext()) {
            SAMRecord sr = (SAMRecord)iterator.next();
            if (sr.getReadUnmappedFlag()) continue;
            int aligned = 0;
            for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                aligned += ab.getLength();
            }
            if (aligned > min_size) continue;
            ArrayList<String> stuff = new ArrayList<String>();
            stuff.add(Integer.toString(aligned));
            stuff.add(SAMUtils.get_printable_read_name(sr));
            stuff.add(sr.getReferenceName());
            stuff.add(Integer.toString(sr.getAlignmentStart()));
            System.err.println(Str.join(",", stuff));
        }
    }

    public static void get_run_date(SamReader reader) {
        SAMFileHeader sfh = reader.getFileHeader();
        Date run_date = null;
        for (SAMReadGroupRecord srgr : sfh.getReadGroups()) {
            Date date = srgr.getRunDate();
            if (date == null || run_date != null && !date.after(run_date)) continue;
            run_date = date;
        }
        String result = run_date == null ? "0" : run_date.toString();
        System.out.println(result);
    }

    public static void get_sample_names(SamReader reader) {
        SAMFileHeader sfh = reader.getFileHeader();
        Object run_date = null;
        HashSet<String> saw = new HashSet<String>();
        for (SAMReadGroupRecord srgr : sfh.getReadGroups()) {
            String sample = srgr.getSample();
            if (sample == null || saw.contains(sample)) continue;
            System.out.println(sample);
            saw.add(sample);
        }
    }

    public static void get_assembly(SamReader reader) {
        SAMFileHeader sfh = reader.getFileHeader();
        SAMSequenceDictionary ssd = sfh.getSequenceDictionary();
        HashSet<String> saw_as = new HashSet<String>();
        HashMap<Chromosome, Integer> lengths = new HashMap<Chromosome, Integer>();
        for (SAMSequenceRecord ssr : ssd.getSequences()) {
            String seq_name = ssr.getSequenceName();
            int seq_len = ssr.getSequenceLength();
            String seq_asm = ssr.getAssembly();
            Chromosome c = Chromosome.valueOfString(seq_name);
            if (c == null) continue;
            lengths.put(c, seq_len);
            if (seq_asm == null) continue;
            saw_as.add(seq_asm);
        }
        KnownGenomeBuild kgb = new KnownGenomeBuild();
        String genome_name = kgb.identify_build(lengths);
        if (genome_name == null) {
            genome_name = "unknown";
        }
        System.out.println("AS," + Str.join(",", saw_as));
        System.out.println("meta," + genome_name);
    }

    public static void NEW_CALL_STUB(CloseableIterator<SAMRecord> iterator) {
        while (iterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)iterator.next();
        }
    }

    public static void detect_rna(CloseableIterator<SAMRecord> iterator, int max_reads) {
        int read_count = 0;
        boolean is_rna = false;
        while (iterator.hasNext() && (max_reads <= 0 || read_count++ < max_reads)) {
            SAMRecord sr = (SAMRecord)iterator.next();
            Cigar c = sr.getCigar();
            for (CigarElement ce : c.getCigarElements()) {
                if (!ce.getOperator().equals((Object)CigarOperator.SKIPPED_REGION)) continue;
                is_rna = true;
                break;
            }
            if (!is_rna) continue;
        }
        System.out.println(is_rna ? "1" : "0");
    }

    public static void find_read_name(CloseableIterator<SAMRecord> iterator, String id) {
        boolean found = false;
        System.err.println("looking for: " + id);
        while (iterator.hasNext()) {
            SAMRecord sr = (SAMRecord)iterator.next();
            if (!sr.getReadName().equals(id)) continue;
            found = true;
            System.out.println(sr.getReadName() + " unmapped:" + sr.getReadUnmappedFlag() + " as:" + sr.getAlignmentStart() + " strand:" + (sr.getReadNegativeStrandFlag() ? "-" : "+"));
        }
        System.err.println("found=" + found);
    }
}

