/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Assembly;
import Ace2.AssemblySequence;
import Ace2.ErrorReporter;
import Ace2.FASTAQualityReader;
import Ace2.IntronCompressor;
import Ace2.ProgressInfo;
import Ace2.SAMConsensusBuilder;
import Ace2.SAMConsensusMapFactory;
import Ace2.SAMConsensusMapping;
import Ace2.SAMResource;
import Ace2.Sample;
import Funk.Timer;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMAssembly
extends Assembly
implements Observer,
Runnable {
    private char[] consensus_padded;
    private ArrayList<SAMResource> sams;
    private static final String FAKE_CONS_ID = "Contig1";
    private boolean data_loaded = false;
    private boolean alignment_built = false;
    private String error_message = null;
    private int sams_loaded = 0;
    private SAMConsensusBuilder scb;
    private int start_offset;
    private AceViewerConfig avc = null;
    private static final String RAM_ERROR_MESSAGE = "Insufficient memory to create padded alignment.  Try viewing a smaller region or running the viewer with more RAM.";
    private static final String PARSE_ERROR_MESSAGE = "Error parsing BAM data: see Java console/STDERR for details.";

    public SAMAssembly(AceViewerConfig avc, boolean async) throws IOException {
        this.avc = avc;
        this.sams = avc.sams;
        this.start_offset = avc.ruler_start;
        this.scb = new SAMConsensusBuilder(avc.target_sequence, this.start_offset);
        this.alignment_built = false;
        this.data_loaded = false;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        SAMResource sr = (SAMResource)arg;
        try {
            if (++this.sams_loaded == this.sams.size()) {
                this.build_assembly();
            }
        }
        catch (Exception e) {
            new Funk.ErrorReporter(e);
        }
    }

    private void build_assembly() {
        try {
            this.data_loaded = true;
            this.scb.build_consensus();
            this.consensus_padded = this.scb.get_consensus();
            Timer timer = new Timer("cons map");
            if (this.avc == null) {
                System.err.println("WTF: null AVC!");
            } else {
                this.avc.REFERENCE_SEQUENCE_PREPADDED = this.scb.is_reference_prepadded();
            }
            SAMConsensusMapFactory sm = new SAMConsensusMapFactory(this.consensus_padded, this.scb.get_reference_sequence(), this.get_padmap(), this.start_offset, this.scb.is_reference_prepadded());
            ProgressInfo info = new ProgressInfo();
            for (SAMResource sr : this.sams) {
                info.total += sr.get_size();
            }
            boolean error = false;
            for (SAMResource sr : this.sams) {
                if (sr.build_mappings(sm, info)) continue;
                error = true;
            }
            timer.finish();
            if (error) {
                this.error_message = RAM_ERROR_MESSAGE;
            } else {
                if (this.avc.COMPRESS_INTRONS) {
                    super.build_alignment();
                    this.avc.intron_compressor = new IntronCompressor(this.avc, this);
                }
                super.build_alignment();
                this.alignment_built = true;
            }
        }
        catch (Exception e) {
            this.error_message = PARSE_ERROR_MESSAGE;
            System.err.println("ERROR during assembly build");
            new ErrorReporter(e);
        }
    }

    @Override
    public String get_title() {
        return "FIX ME";
    }

    @Override
    public void addObserver(Observer o) {
        for (SAMResource sr : this.sams) {
            sr.addObserver(o);
        }
    }

    @Override
    public void build_summary_info() {
    }

    @Override
    public boolean is_loaded() {
        return this.data_loaded;
    }

    @Override
    public boolean alignment_is_built() {
        return this.alignment_built;
    }

    @Override
    public boolean is_empty() {
        boolean result = true;
        for (SAMResource sr : this.sams) {
            SAMConsensusMapping[] maps = sr.get_sequences();
            if (maps == null || maps.length <= 0) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean has_error() {
        return this.error_message != null;
    }

    @Override
    public String get_error_message() {
        return this.error_message;
    }

    @Override
    public char[] get_consensus_sequence() {
        return this.consensus_padded;
    }

    @Override
    public void set_quality(FASTAQualityReader fq) {
    }

    @Override
    public boolean has_quality() {
        return true;
    }

    @Override
    public AssemblySequence get_sequence(String id) {
        SAMResource sr;
        AssemblySequence result = null;
        Iterator<SAMResource> i$ = this.sams.iterator();
        while (i$.hasNext() && (result = (sr = i$.next()).get_sequence(id)) == null) {
        }
        return result;
    }

    @Override
    public ArrayList<AssemblySequence> get_sequences() {
        ArrayList<AssemblySequence> all = new ArrayList<AssemblySequence>();
        for (SAMResource sr : this.sams) {
            sr.get_sequences(all, this.display_sequences_by_position);
        }
        return all;
    }

    @Override
    public boolean supports_contigs() {
        return false;
    }

    @Override
    public ArrayList<String> get_contig_id_list() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(FAKE_CONS_ID);
        return list;
    }

    @Override
    public String get_contig_id() {
        return FAKE_CONS_ID;
    }

    @Override
    public void set_contig(String id) {
    }

    @Override
    public String get_biggest_contig_id() {
        return FAKE_CONS_ID;
    }

    public void set_current_contig(String id) {
    }

    @Override
    public Sample get_sample_for(String read_name) {
        SAMResource sr = this.get_sr_for(read_name);
        return sr == null ? null : sr.sample;
    }

    public SAMResource get_sr_for(String read_name) {
        SAMResource wanted = null;
        for (SAMResource sr : this.sams) {
            AssemblySequence as = sr.get_sequence(read_name);
            if (as == null) continue;
            wanted = sr;
            break;
        }
        return wanted;
    }

    @Override
    public void run() {
        boolean has_something = false;
        boolean load_error = false;
        for (SAMResource sr : this.sams) {
            SAMRecord[] srs = sr.get_sams();
            if (sr.has_load_error()) {
                load_error = true;
                break;
            }
            if (srs == null || srs.length == 0) {
                System.err.println("empty .bam file");
                continue;
            }
            has_something = true;
            this.scb.add_samrecords(srs);
        }
        if (load_error) {
            this.error_message = RAM_ERROR_MESSAGE;
        } else if (has_something) {
            this.build_assembly();
        } else {
            this.error_message = "Nothing to display: no reads in this region.";
            System.err.println(this.error_message);
        }
        this.data_loaded = true;
    }

    public void set_consensus_sequence(char[] seq) {
        this.consensus_padded = seq;
    }

    public void reset_padmap() {
        this.pm = null;
        super.get_padmap();
    }
}

