/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.GenomeBuildInfo;
import Ace2.KnownGenomeBuild;
import Ace2.ReferenceSequence;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSequenceByte
implements ReferenceSequence {
    private static final int BUFFER_LEN = 1000;
    private ChromosomeDisambiguator cd;
    private String genome;
    private String reference_name;
    private GenomeBuildInfo gbi;
    private int base_num;
    private char base;

    public ReferenceSequenceByte(String params) {
        String[] stuff = params.split(",");
        if (stuff.length == 4) {
            int i = 0;
            this.genome = stuff[i++];
            KnownGenomeBuild kgb = new KnownGenomeBuild();
            this.gbi = kgb.find_build(this.genome);
            if (this.gbi == null) {
                System.err.println("ERROR: dunno genome " + this.genome);
                System.exit(1);
            } else {
                this.reference_name = stuff[i++];
                this.base_num = Integer.parseInt(stuff[i++]);
                this.base = stuff[i++].charAt(0);
                System.err.println("base is " + this.base);
                HashSet<String> refs = new HashSet<String>();
                refs.add(this.reference_name);
                this.cd = new ChromosomeDisambiguator(refs);
            }
        } else {
            System.err.println("error: needs 3 fields");
            System.exit(1);
        }
    }

    @Override
    public byte[] get_region(String sequence_name, int start_base, int length) throws IOException {
        throw new IOException("get_region() unsupported");
    }

    @Override
    public byte[] get_all(String sequence_name) throws IOException {
        int len = this.get_length(sequence_name);
        byte[] reference_sequence = new byte[len];
        Arrays.fill(reference_sequence, (byte)78);
        String local_name = this.cd.find(sequence_name);
        if (local_name != null && local_name.equals(this.reference_name)) {
            reference_sequence[this.base_num - 1] = (byte)this.base;
        }
        return reference_sequence;
    }

    @Override
    public int get_length(String sequence_name) throws IOException {
        return this.gbi.get_length_for(sequence_name);
    }

    @Override
    public boolean supports_sequence_list() {
        return false;
    }

    @Override
    public ArrayList<String> get_sequence_names() {
        return null;
    }

    @Override
    public ReferenceSource getReferenceSource() {
        System.err.println("ERROR: getReferenceSource() not implemented");
        return null;
    }
}

