/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.SAMConsensusMapping;
import Ace2.SAMResource;
import Ace2.Sample;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import java.util.Arrays;
import java.util.Observable;

public class HeteroSummary
extends Observable
implements Runnable {
    AceViewerConfig config;
    private boolean is_tn_trackable = false;
    private byte[] global_nonreference_frequency;
    private byte[] normal_nonreference_frequency;
    private byte[] tumor_nonreference_frequency;
    private short[] coverage;
    private int max_coverage;
    private boolean is_loaded = false;
    private boolean is_all_tumor = false;
    private boolean is_all_normal = false;
    private boolean COVERAGE_LOG2 = false;
    private boolean COVERAGE_LOG1_5 = false;
    private boolean COVERAGE_LOG1_25 = false;

    public HeteroSummary(AceViewerConfig config, boolean async) {
        this.config = config;
        this.is_loaded = false;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public void run() {
        int i;
        char[] reference_seq = new String(this.config.target_sequence).toLowerCase().toCharArray();
        int start_offset = this.config.ruler_start;
        this.is_tn_trackable = this.config.sams.size() > 1;
        this.is_all_normal = true;
        this.is_all_tumor = true;
        for (SAMResource sr : this.config.sams) {
            SAMConsensusMapping[] maps = sr.get_sequences();
            Sample sample = sr.get_sample();
            if (sample.is_tumor()) {
                this.is_all_normal = false;
                continue;
            }
            if (sample.is_normal()) {
                this.is_all_tumor = false;
                continue;
            }
            this.is_all_normal = false;
            this.is_all_tumor = false;
            this.is_tn_trackable = false;
        }
        int[] global_reference_count = new int[reference_seq.length];
        int[] global_nonreference_count = new int[reference_seq.length];
        int[] normal_reference_count = new int[reference_seq.length];
        int[] normal_nonreference_count = new int[reference_seq.length];
        int[] tumor_reference_count = new int[reference_seq.length];
        int[] tumor_nonreference_count = new int[reference_seq.length];
        Arrays.fill(global_reference_count, 0);
        Arrays.fill(global_nonreference_count, 0);
        Arrays.fill(normal_reference_count, 0);
        Arrays.fill(normal_nonreference_count, 0);
        Arrays.fill(tumor_reference_count, 0);
        Arrays.fill(tumor_nonreference_count, 0);
        this.global_nonreference_frequency = new byte[reference_seq.length];
        this.normal_nonreference_frequency = new byte[reference_seq.length];
        this.tumor_nonreference_frequency = new byte[reference_seq.length];
        this.coverage = new short[reference_seq.length];
        boolean VERBOSE = false;
        for (SAMResource sres : this.config.sams) {
            int[] counter_nonref;
            int[] counter_ref;
            SAMConsensusMapping[] maps = sres.get_sequences();
            Sample sample = sres.get_sample();
            if (this.is_tn_trackable) {
                if (sample.is_tumor()) {
                    counter_ref = tumor_reference_count;
                    counter_nonref = tumor_nonreference_count;
                } else {
                    counter_ref = normal_reference_count;
                    counter_nonref = normal_nonreference_count;
                }
            } else {
                counter_nonref = null;
                counter_ref = null;
            }
            for (i = 0; i < maps.length; ++i) {
                SAMRecord sr = maps[i].sr;
                if (sr.getDuplicateReadFlag()) continue;
                byte[] read = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                if (VERBOSE) {
                    System.err.println("read " + sr.getReadName());
                }
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int read_i = ab.getReadStart() - 1;
                    int ref_i = ab.getReferenceStart() - start_offset - 1;
                    if (VERBOSE) {
                        System.err.println("  start_ref " + (ref_i + start_offset + 1));
                    }
                    if (this.config.intron_compressor != null) {
                        ref_i -= this.config.intron_compressor.get_start_shift(ref_i + 1, true);
                        if (VERBOSE) {
                            System.err.println("  adjusted=" + (ref_i + start_offset + 1));
                        }
                    }
                    int end = read_i + ab.getLength();
                    while (read_i < end) {
                        if (ref_i >= 0 && ref_i < reference_seq.length && quals[read_i] >= this.config.snp_config.MIN_QUALITY) {
                            int n = ref_i;
                            this.coverage[n] = (short)(this.coverage[n] + 1);
                            char base = Character.toLowerCase((char)read[read_i]);
                            if (base == reference_seq[ref_i]) {
                                int n2 = ref_i;
                                global_reference_count[n2] = global_reference_count[n2] + 1;
                                if (this.is_tn_trackable) {
                                    int n3 = ref_i;
                                    counter_ref[n3] = counter_ref[n3] + 1;
                                }
                            } else if (base != 'n') {
                                int n4 = ref_i;
                                global_nonreference_count[n4] = global_nonreference_count[n4] + 1;
                                if (this.is_tn_trackable) {
                                    int n5 = ref_i;
                                    counter_nonref[n5] = counter_nonref[n5] + 1;
                                }
                            }
                        }
                        ++read_i;
                        ++ref_i;
                    }
                }
            }
        }
        if (this.COVERAGE_LOG2) {
            System.err.println("generating log2 coverage");
            for (i = 0; i < reference_seq.length; ++i) {
                this.coverage[i] = (short)(Math.log(this.coverage[i]) / Math.log(2.0));
            }
        } else if (this.COVERAGE_LOG1_5) {
            System.err.println("generating log1.5 coverage");
            for (i = 0; i < reference_seq.length; ++i) {
                this.coverage[i] = (short)(Math.log(this.coverage[i]) / Math.log(1.5));
            }
        } else if (this.COVERAGE_LOG1_25) {
            System.err.println("generating log1.25 coverage");
            for (i = 0; i < reference_seq.length; ++i) {
                this.coverage[i] = (short)(Math.log(this.coverage[i]) / Math.log(1.25));
            }
        }
        this.max_coverage = 0;
        for (i = 0; i < reference_seq.length; ++i) {
            if (this.coverage[i] <= this.max_coverage) continue;
            this.max_coverage = this.coverage[i];
        }
        this.build_frequencies(this.global_nonreference_frequency, global_reference_count, global_nonreference_count, null, null);
        this.build_frequencies(this.normal_nonreference_frequency, normal_reference_count, normal_nonreference_count, tumor_reference_count, tumor_nonreference_count);
        this.build_frequencies(this.tumor_nonreference_frequency, tumor_reference_count, tumor_nonreference_count, normal_reference_count, tumor_reference_count);
        this.is_loaded = true;
        this.setChanged();
        this.notifyObservers();
    }

    private void build_frequencies(byte[] freq, int[] ref, int[] non_ref, int[] other_ref, int[] other_non_ref) {
        int len = freq.length;
        int half_required_coverage = this.config.snp_config.MIN_COVERAGE;
        for (int i = 0; i < len; ++i) {
            int total = ref[i] + non_ref[i];
            int coverage = other_ref == null ? total : total + other_ref[i] + other_non_ref[i];
            if (total <= 0 || total < half_required_coverage || coverage < this.config.snp_config.MIN_COVERAGE) continue;
            freq[i] = (byte)(non_ref[i] * 100 / total);
        }
    }

    public byte[] get_global_nonreference_frequency() {
        return this.global_nonreference_frequency;
    }

    public byte[] get_normal_nonreference_frequency() {
        return this.normal_nonreference_frequency;
    }

    public byte[] get_tumor_nonreference_frequency() {
        return this.tumor_nonreference_frequency;
    }

    public short[] get_coverage() {
        return this.coverage;
    }

    public int get_max_coverage() {
        return this.max_coverage;
    }

    public String get_tooltip_text(int unpadded) {
        String result = "";
        if (--unpadded >= 0) {
            if (this.is_tn_trackable) {
                if (this.normal_nonreference_frequency != null) {
                    result = "nonreference allele frequencies: normal=" + this.normal_nonreference_frequency[unpadded] + "%, tumor=" + this.tumor_nonreference_frequency[unpadded] + "%";
                }
            } else if (this.global_nonreference_frequency != null) {
                result = "nonreference allele frequency=" + this.global_nonreference_frequency[unpadded] + "%";
            }
        }
        return result;
    }

    public boolean is_tumor_normal_trackable() {
        return this.is_tn_trackable;
    }

    public boolean is_all_normal() {
        return this.is_all_normal;
    }

    public boolean is_all_tumor() {
        return this.is_all_tumor;
    }

    public boolean is_loaded() {
        return this.is_loaded;
    }

    public void reset(boolean async) {
        this.is_loaded = false;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }
}

