<a id="mypy-boto3-ssm"></a>

# mypy-boto3-ssm

[![PyPI - mypy-boto3-ssm](https://img.shields.io/pypi/v/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-ssm?color=blue)](https://pypistats.org/packages/mypy-boto3-ssm)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.SSM 1.24.36](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/ssm.html#SSM)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.10.0](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ssm docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ssm/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-ssm](#mypy-boto3-ssm)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `SSM`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `SSM` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[ssm]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[ssm]'


# standalone installation
python -m pip install mypy-boto3-ssm
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-ssm
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[ssm]` in your environment:

```bash
python -m pip install 'boto3-stubs[ssm]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[ssm]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[ssm]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[ssm]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[ssm]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[ssm]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[ssm]` in your environment:

```bash
python -m pip install 'boto3-stubs[ssm]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[ssm]` in your environment:

```bash
python -m pip install 'boto3-stubs[ssm]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SSMClient` provides annotations for `boto3.client("ssm")`.

```python
from boto3.session import Session

from mypy_boto3_ssm import SSMClient

client: SSMClient = Session().client("ssm")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ssm.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_ssm import SSMClient
from mypy_boto3_ssm.paginator import (
    DescribeActivationsPaginator,
    DescribeAssociationExecutionTargetsPaginator,
    DescribeAssociationExecutionsPaginator,
    DescribeAutomationExecutionsPaginator,
    DescribeAutomationStepExecutionsPaginator,
    DescribeAvailablePatchesPaginator,
    DescribeEffectiveInstanceAssociationsPaginator,
    DescribeEffectivePatchesForPatchBaselinePaginator,
    DescribeInstanceAssociationsStatusPaginator,
    DescribeInstanceInformationPaginator,
    DescribeInstancePatchStatesPaginator,
    DescribeInstancePatchStatesForPatchGroupPaginator,
    DescribeInstancePatchesPaginator,
    DescribeInventoryDeletionsPaginator,
    DescribeMaintenanceWindowExecutionTaskInvocationsPaginator,
    DescribeMaintenanceWindowExecutionTasksPaginator,
    DescribeMaintenanceWindowExecutionsPaginator,
    DescribeMaintenanceWindowSchedulePaginator,
    DescribeMaintenanceWindowTargetsPaginator,
    DescribeMaintenanceWindowTasksPaginator,
    DescribeMaintenanceWindowsPaginator,
    DescribeMaintenanceWindowsForTargetPaginator,
    DescribeOpsItemsPaginator,
    DescribeParametersPaginator,
    DescribePatchBaselinesPaginator,
    DescribePatchGroupsPaginator,
    DescribePatchPropertiesPaginator,
    DescribeSessionsPaginator,
    GetInventoryPaginator,
    GetInventorySchemaPaginator,
    GetOpsSummaryPaginator,
    GetParameterHistoryPaginator,
    GetParametersByPathPaginator,
    ListAssociationVersionsPaginator,
    ListAssociationsPaginator,
    ListCommandInvocationsPaginator,
    ListCommandsPaginator,
    ListComplianceItemsPaginator,
    ListComplianceSummariesPaginator,
    ListDocumentVersionsPaginator,
    ListDocumentsPaginator,
    ListOpsItemEventsPaginator,
    ListOpsItemRelatedItemsPaginator,
    ListOpsMetadataPaginator,
    ListResourceComplianceSummariesPaginator,
    ListResourceDataSyncPaginator,
)

client: SSMClient = Session().client("ssm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_activations_paginator: DescribeActivationsPaginator = client.get_paginator("describe_activations")
describe_association_execution_targets_paginator: DescribeAssociationExecutionTargetsPaginator = client.get_paginator("describe_association_execution_targets")
describe_association_executions_paginator: DescribeAssociationExecutionsPaginator = client.get_paginator("describe_association_executions")
describe_automation_executions_paginator: DescribeAutomationExecutionsPaginator = client.get_paginator("describe_automation_executions")
describe_automation_step_executions_paginator: DescribeAutomationStepExecutionsPaginator = client.get_paginator("describe_automation_step_executions")
describe_available_patches_paginator: DescribeAvailablePatchesPaginator = client.get_paginator("describe_available_patches")
describe_effective_instance_associations_paginator: DescribeEffectiveInstanceAssociationsPaginator = client.get_paginator("describe_effective_instance_associations")
describe_effective_patches_for_patch_baseline_paginator: DescribeEffectivePatchesForPatchBaselinePaginator = client.get_paginator("describe_effective_patches_for_patch_baseline")
describe_instance_associations_status_paginator: DescribeInstanceAssociationsStatusPaginator = client.get_paginator("describe_instance_associations_status")
describe_instance_information_paginator: DescribeInstanceInformationPaginator = client.get_paginator("describe_instance_information")
describe_instance_patch_states_paginator: DescribeInstancePatchStatesPaginator = client.get_paginator("describe_instance_patch_states")
describe_instance_patch_states_for_patch_group_paginator: DescribeInstancePatchStatesForPatchGroupPaginator = client.get_paginator("describe_instance_patch_states_for_patch_group")
describe_instance_patches_paginator: DescribeInstancePatchesPaginator = client.get_paginator("describe_instance_patches")
describe_inventory_deletions_paginator: DescribeInventoryDeletionsPaginator = client.get_paginator("describe_inventory_deletions")
describe_maintenance_window_execution_task_invocations_paginator: DescribeMaintenanceWindowExecutionTaskInvocationsPaginator = client.get_paginator("describe_maintenance_window_execution_task_invocations")
describe_maintenance_window_execution_tasks_paginator: DescribeMaintenanceWindowExecutionTasksPaginator = client.get_paginator("describe_maintenance_window_execution_tasks")
describe_maintenance_window_executions_paginator: DescribeMaintenanceWindowExecutionsPaginator = client.get_paginator("describe_maintenance_window_executions")
describe_maintenance_window_schedule_paginator: DescribeMaintenanceWindowSchedulePaginator = client.get_paginator("describe_maintenance_window_schedule")
describe_maintenance_window_targets_paginator: DescribeMaintenanceWindowTargetsPaginator = client.get_paginator("describe_maintenance_window_targets")
describe_maintenance_window_tasks_paginator: DescribeMaintenanceWindowTasksPaginator = client.get_paginator("describe_maintenance_window_tasks")
describe_maintenance_windows_paginator: DescribeMaintenanceWindowsPaginator = client.get_paginator("describe_maintenance_windows")
describe_maintenance_windows_for_target_paginator: DescribeMaintenanceWindowsForTargetPaginator = client.get_paginator("describe_maintenance_windows_for_target")
describe_ops_items_paginator: DescribeOpsItemsPaginator = client.get_paginator("describe_ops_items")
describe_parameters_paginator: DescribeParametersPaginator = client.get_paginator("describe_parameters")
describe_patch_baselines_paginator: DescribePatchBaselinesPaginator = client.get_paginator("describe_patch_baselines")
describe_patch_groups_paginator: DescribePatchGroupsPaginator = client.get_paginator("describe_patch_groups")
describe_patch_properties_paginator: DescribePatchPropertiesPaginator = client.get_paginator("describe_patch_properties")
describe_sessions_paginator: DescribeSessionsPaginator = client.get_paginator("describe_sessions")
get_inventory_paginator: GetInventoryPaginator = client.get_paginator("get_inventory")
get_inventory_schema_paginator: GetInventorySchemaPaginator = client.get_paginator("get_inventory_schema")
get_ops_summary_paginator: GetOpsSummaryPaginator = client.get_paginator("get_ops_summary")
get_parameter_history_paginator: GetParameterHistoryPaginator = client.get_paginator("get_parameter_history")
get_parameters_by_path_paginator: GetParametersByPathPaginator = client.get_paginator("get_parameters_by_path")
list_association_versions_paginator: ListAssociationVersionsPaginator = client.get_paginator("list_association_versions")
list_associations_paginator: ListAssociationsPaginator = client.get_paginator("list_associations")
list_command_invocations_paginator: ListCommandInvocationsPaginator = client.get_paginator("list_command_invocations")
list_commands_paginator: ListCommandsPaginator = client.get_paginator("list_commands")
list_compliance_items_paginator: ListComplianceItemsPaginator = client.get_paginator("list_compliance_items")
list_compliance_summaries_paginator: ListComplianceSummariesPaginator = client.get_paginator("list_compliance_summaries")
list_document_versions_paginator: ListDocumentVersionsPaginator = client.get_paginator("list_document_versions")
list_documents_paginator: ListDocumentsPaginator = client.get_paginator("list_documents")
list_ops_item_events_paginator: ListOpsItemEventsPaginator = client.get_paginator("list_ops_item_events")
list_ops_item_related_items_paginator: ListOpsItemRelatedItemsPaginator = client.get_paginator("list_ops_item_related_items")
list_ops_metadata_paginator: ListOpsMetadataPaginator = client.get_paginator("list_ops_metadata")
list_resource_compliance_summaries_paginator: ListResourceComplianceSummariesPaginator = client.get_paginator("list_resource_compliance_summaries")
list_resource_data_sync_paginator: ListResourceDataSyncPaginator = client.get_paginator("list_resource_data_sync")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ssm.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_ssm import SSMClient
from mypy_boto3_ssm.waiter import (
    CommandExecutedWaiter,
)

client: SSMClient = Session().client("ssm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
command_executed_waiter: CommandExecutedWaiter = client.get_waiter("command_executed")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ssm.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ssm.literals import (
    AssociationComplianceSeverityType,
    AssociationExecutionFilterKeyType,
    AssociationExecutionTargetsFilterKeyType,
    AssociationFilterKeyType,
    AssociationFilterOperatorTypeType,
    AssociationStatusNameType,
    AssociationSyncComplianceType,
    AttachmentHashTypeType,
    AttachmentsSourceKeyType,
    AutomationExecutionFilterKeyType,
    AutomationExecutionStatusType,
    AutomationSubtypeType,
    AutomationTypeType,
    CalendarStateType,
    CommandExecutedWaiterName,
    CommandFilterKeyType,
    CommandInvocationStatusType,
    CommandPluginStatusType,
    CommandStatusType,
    ComplianceQueryOperatorTypeType,
    ComplianceSeverityType,
    ComplianceStatusType,
    ComplianceUploadTypeType,
    ConnectionStatusType,
    DescribeActivationsFilterKeysType,
    DescribeActivationsPaginatorName,
    DescribeAssociationExecutionTargetsPaginatorName,
    DescribeAssociationExecutionsPaginatorName,
    DescribeAutomationExecutionsPaginatorName,
    DescribeAutomationStepExecutionsPaginatorName,
    DescribeAvailablePatchesPaginatorName,
    DescribeEffectiveInstanceAssociationsPaginatorName,
    DescribeEffectivePatchesForPatchBaselinePaginatorName,
    DescribeInstanceAssociationsStatusPaginatorName,
    DescribeInstanceInformationPaginatorName,
    DescribeInstancePatchStatesForPatchGroupPaginatorName,
    DescribeInstancePatchStatesPaginatorName,
    DescribeInstancePatchesPaginatorName,
    DescribeInventoryDeletionsPaginatorName,
    DescribeMaintenanceWindowExecutionTaskInvocationsPaginatorName,
    DescribeMaintenanceWindowExecutionTasksPaginatorName,
    DescribeMaintenanceWindowExecutionsPaginatorName,
    DescribeMaintenanceWindowSchedulePaginatorName,
    DescribeMaintenanceWindowTargetsPaginatorName,
    DescribeMaintenanceWindowTasksPaginatorName,
    DescribeMaintenanceWindowsForTargetPaginatorName,
    DescribeMaintenanceWindowsPaginatorName,
    DescribeOpsItemsPaginatorName,
    DescribeParametersPaginatorName,
    DescribePatchBaselinesPaginatorName,
    DescribePatchGroupsPaginatorName,
    DescribePatchPropertiesPaginatorName,
    DescribeSessionsPaginatorName,
    DocumentFilterKeyType,
    DocumentFormatType,
    DocumentHashTypeType,
    DocumentMetadataEnumType,
    DocumentParameterTypeType,
    DocumentPermissionTypeType,
    DocumentReviewActionType,
    DocumentReviewCommentTypeType,
    DocumentStatusType,
    DocumentTypeType,
    ExecutionModeType,
    FaultType,
    GetInventoryPaginatorName,
    GetInventorySchemaPaginatorName,
    GetOpsSummaryPaginatorName,
    GetParameterHistoryPaginatorName,
    GetParametersByPathPaginatorName,
    InstanceInformationFilterKeyType,
    InstancePatchStateOperatorTypeType,
    InventoryAttributeDataTypeType,
    InventoryDeletionStatusType,
    InventoryQueryOperatorTypeType,
    InventorySchemaDeleteOptionType,
    LastResourceDataSyncStatusType,
    ListAssociationVersionsPaginatorName,
    ListAssociationsPaginatorName,
    ListCommandInvocationsPaginatorName,
    ListCommandsPaginatorName,
    ListComplianceItemsPaginatorName,
    ListComplianceSummariesPaginatorName,
    ListDocumentVersionsPaginatorName,
    ListDocumentsPaginatorName,
    ListOpsItemEventsPaginatorName,
    ListOpsItemRelatedItemsPaginatorName,
    ListOpsMetadataPaginatorName,
    ListResourceComplianceSummariesPaginatorName,
    ListResourceDataSyncPaginatorName,
    MaintenanceWindowExecutionStatusType,
    MaintenanceWindowResourceTypeType,
    MaintenanceWindowTaskCutoffBehaviorType,
    MaintenanceWindowTaskTypeType,
    NotificationEventType,
    NotificationTypeType,
    OperatingSystemType,
    OpsFilterOperatorTypeType,
    OpsItemDataTypeType,
    OpsItemEventFilterKeyType,
    OpsItemEventFilterOperatorType,
    OpsItemFilterKeyType,
    OpsItemFilterOperatorType,
    OpsItemRelatedItemsFilterKeyType,
    OpsItemRelatedItemsFilterOperatorType,
    OpsItemStatusType,
    ParameterTierType,
    ParameterTypeType,
    ParametersFilterKeyType,
    PatchActionType,
    PatchComplianceDataStateType,
    PatchComplianceLevelType,
    PatchDeploymentStatusType,
    PatchFilterKeyType,
    PatchOperationTypeType,
    PatchPropertyType,
    PatchSetType,
    PingStatusType,
    PlatformTypeType,
    RebootOptionType,
    ResourceDataSyncS3FormatType,
    ResourceTypeForTaggingType,
    ResourceTypeType,
    ReviewStatusType,
    SessionFilterKeyType,
    SessionStateType,
    SessionStatusType,
    SignalTypeType,
    SourceTypeType,
    StepExecutionFilterKeyType,
    StopTypeType,
    SSMServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    WaiterName,
    RegionName,
)

def check_value(value: AssociationComplianceSeverityType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ssm.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ssm.type_defs import (
    AccountSharingInfoTypeDef,
    TagTypeDef,
    AssociateOpsItemRelatedItemRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    AssociationOverviewTypeDef,
    AssociationStatusTypeDef,
    TargetLocationTypeDef,
    TargetTypeDef,
    AssociationExecutionFilterTypeDef,
    OutputSourceTypeDef,
    AssociationExecutionTargetsFilterTypeDef,
    AssociationExecutionTypeDef,
    AssociationFilterTypeDef,
    AttachmentContentTypeDef,
    AttachmentInformationTypeDef,
    AttachmentsSourceTypeDef,
    AutomationExecutionFilterTypeDef,
    ResolvedTargetsTypeDef,
    ProgressCountersTypeDef,
    PatchSourceTypeDef,
    CancelCommandRequestRequestTypeDef,
    CancelMaintenanceWindowExecutionRequestRequestTypeDef,
    CloudWatchOutputConfigTypeDef,
    CommandFilterTypeDef,
    CommandPluginTypeDef,
    NotificationConfigTypeDef,
    ComplianceExecutionSummaryTypeDef,
    ComplianceItemEntryTypeDef,
    ComplianceStringFilterTypeDef,
    SeveritySummaryTypeDef,
    RegistrationMetadataItemTypeDef,
    DocumentRequiresTypeDef,
    OpsItemDataValueTypeDef,
    OpsItemNotificationTypeDef,
    RelatedOpsItemTypeDef,
    MetadataValueTypeDef,
    DeleteActivationRequestRequestTypeDef,
    DeleteAssociationRequestRequestTypeDef,
    DeleteDocumentRequestRequestTypeDef,
    DeleteInventoryRequestRequestTypeDef,
    DeleteMaintenanceWindowRequestRequestTypeDef,
    DeleteOpsMetadataRequestRequestTypeDef,
    DeleteParameterRequestRequestTypeDef,
    DeleteParametersRequestRequestTypeDef,
    DeletePatchBaselineRequestRequestTypeDef,
    DeleteResourceDataSyncRequestRequestTypeDef,
    DeregisterManagedInstanceRequestRequestTypeDef,
    DeregisterPatchBaselineForPatchGroupRequestRequestTypeDef,
    DeregisterTargetFromMaintenanceWindowRequestRequestTypeDef,
    DeregisterTaskFromMaintenanceWindowRequestRequestTypeDef,
    DescribeActivationsFilterTypeDef,
    PaginatorConfigTypeDef,
    DescribeAssociationRequestRequestTypeDef,
    StepExecutionFilterTypeDef,
    PatchOrchestratorFilterTypeDef,
    PatchTypeDef,
    DescribeDocumentPermissionRequestRequestTypeDef,
    DescribeDocumentRequestRequestTypeDef,
    DescribeEffectiveInstanceAssociationsRequestRequestTypeDef,
    InstanceAssociationTypeDef,
    DescribeEffectivePatchesForPatchBaselineRequestRequestTypeDef,
    DescribeInstanceAssociationsStatusRequestRequestTypeDef,
    InstanceInformationFilterTypeDef,
    InstanceInformationStringFilterTypeDef,
    InstancePatchStateFilterTypeDef,
    InstancePatchStateTypeDef,
    DescribeInstancePatchStatesRequestRequestTypeDef,
    PatchComplianceDataTypeDef,
    DescribeInventoryDeletionsRequestRequestTypeDef,
    MaintenanceWindowFilterTypeDef,
    MaintenanceWindowExecutionTaskInvocationIdentityTypeDef,
    MaintenanceWindowExecutionTaskIdentityTypeDef,
    MaintenanceWindowExecutionTypeDef,
    ScheduledWindowExecutionTypeDef,
    MaintenanceWindowIdentityForTargetTypeDef,
    MaintenanceWindowIdentityTypeDef,
    OpsItemFilterTypeDef,
    ParameterStringFilterTypeDef,
    ParametersFilterTypeDef,
    PatchBaselineIdentityTypeDef,
    DescribePatchGroupStateRequestRequestTypeDef,
    DescribePatchPropertiesRequestRequestTypeDef,
    SessionFilterTypeDef,
    DisassociateOpsItemRelatedItemRequestRequestTypeDef,
    DocumentDefaultVersionDescriptionTypeDef,
    DocumentParameterTypeDef,
    ReviewInformationTypeDef,
    DocumentFilterTypeDef,
    DocumentKeyValuesFilterTypeDef,
    DocumentReviewCommentSourceTypeDef,
    DocumentVersionInfoTypeDef,
    PatchStatusTypeDef,
    FailureDetailsTypeDef,
    GetAutomationExecutionRequestRequestTypeDef,
    GetCalendarStateRequestRequestTypeDef,
    WaiterConfigTypeDef,
    GetCommandInvocationRequestRequestTypeDef,
    GetConnectionStatusRequestRequestTypeDef,
    GetDefaultPatchBaselineRequestRequestTypeDef,
    GetDocumentRequestRequestTypeDef,
    InventoryFilterTypeDef,
    ResultAttributeTypeDef,
    GetInventorySchemaRequestRequestTypeDef,
    GetMaintenanceWindowExecutionRequestRequestTypeDef,
    GetMaintenanceWindowExecutionTaskInvocationRequestRequestTypeDef,
    GetMaintenanceWindowExecutionTaskRequestRequestTypeDef,
    MaintenanceWindowTaskParameterValueExpressionTypeDef,
    GetMaintenanceWindowRequestRequestTypeDef,
    GetMaintenanceWindowTaskRequestRequestTypeDef,
    LoggingInfoTypeDef,
    GetOpsItemRequestRequestTypeDef,
    GetOpsMetadataRequestRequestTypeDef,
    OpsFilterTypeDef,
    OpsResultAttributeTypeDef,
    GetParameterHistoryRequestRequestTypeDef,
    GetParameterRequestRequestTypeDef,
    ParameterTypeDef,
    GetParametersRequestRequestTypeDef,
    GetPatchBaselineForPatchGroupRequestRequestTypeDef,
    GetPatchBaselineRequestRequestTypeDef,
    GetServiceSettingRequestRequestTypeDef,
    ServiceSettingTypeDef,
    InstanceAggregatedAssociationOverviewTypeDef,
    S3OutputLocationTypeDef,
    S3OutputUrlTypeDef,
    InventoryDeletionSummaryItemTypeDef,
    InventoryItemAttributeTypeDef,
    InventoryItemTypeDef,
    InventoryResultItemTypeDef,
    LabelParameterVersionRequestRequestTypeDef,
    ListAssociationVersionsRequestRequestTypeDef,
    ListDocumentMetadataHistoryRequestRequestTypeDef,
    ListDocumentVersionsRequestRequestTypeDef,
    OpsItemEventFilterTypeDef,
    OpsItemRelatedItemsFilterTypeDef,
    OpsMetadataFilterTypeDef,
    OpsMetadataTypeDef,
    ListResourceDataSyncRequestRequestTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    MaintenanceWindowAutomationParametersTypeDef,
    MaintenanceWindowLambdaParametersTypeDef,
    MaintenanceWindowStepFunctionsParametersTypeDef,
    ModifyDocumentPermissionRequestRequestTypeDef,
    OpsEntityItemTypeDef,
    OpsItemIdentityTypeDef,
    ParameterInlinePolicyTypeDef,
    PatchFilterTypeDef,
    RegisterDefaultPatchBaselineRequestRequestTypeDef,
    RegisterPatchBaselineForPatchGroupRequestRequestTypeDef,
    RemoveTagsFromResourceRequestRequestTypeDef,
    ResetServiceSettingRequestRequestTypeDef,
    ResourceDataSyncOrganizationalUnitTypeDef,
    ResourceDataSyncDestinationDataSharingTypeDef,
    ResumeSessionRequestRequestTypeDef,
    SendAutomationSignalRequestRequestTypeDef,
    SessionManagerOutputUrlTypeDef,
    StartAssociationsOnceRequestRequestTypeDef,
    StartSessionRequestRequestTypeDef,
    StopAutomationExecutionRequestRequestTypeDef,
    TerminateSessionRequestRequestTypeDef,
    UnlabelParameterVersionRequestRequestTypeDef,
    UpdateDocumentDefaultVersionRequestRequestTypeDef,
    UpdateMaintenanceWindowRequestRequestTypeDef,
    UpdateManagedInstanceRoleRequestRequestTypeDef,
    UpdateServiceSettingRequestRequestTypeDef,
    ActivationTypeDef,
    AddTagsToResourceRequestRequestTypeDef,
    CreateMaintenanceWindowRequestRequestTypeDef,
    PutParameterRequestRequestTypeDef,
    AssociateOpsItemRelatedItemResponseTypeDef,
    CancelMaintenanceWindowExecutionResultTypeDef,
    CreateActivationResultTypeDef,
    CreateMaintenanceWindowResultTypeDef,
    CreateOpsItemResponseTypeDef,
    CreateOpsMetadataResultTypeDef,
    CreatePatchBaselineResultTypeDef,
    DeleteMaintenanceWindowResultTypeDef,
    DeleteParametersResultTypeDef,
    DeletePatchBaselineResultTypeDef,
    DeregisterPatchBaselineForPatchGroupResultTypeDef,
    DeregisterTargetFromMaintenanceWindowResultTypeDef,
    DeregisterTaskFromMaintenanceWindowResultTypeDef,
    DescribeDocumentPermissionResponseTypeDef,
    DescribePatchGroupStateResultTypeDef,
    DescribePatchPropertiesResultTypeDef,
    GetCalendarStateResponseTypeDef,
    GetConnectionStatusResponseTypeDef,
    GetDefaultPatchBaselineResultTypeDef,
    GetDeployablePatchSnapshotForInstanceResultTypeDef,
    GetMaintenanceWindowExecutionResultTypeDef,
    GetMaintenanceWindowExecutionTaskInvocationResultTypeDef,
    GetMaintenanceWindowResultTypeDef,
    GetPatchBaselineForPatchGroupResultTypeDef,
    LabelParameterVersionResultTypeDef,
    ListInventoryEntriesResultTypeDef,
    ListTagsForResourceResultTypeDef,
    PutInventoryResultTypeDef,
    PutParameterResultTypeDef,
    RegisterDefaultPatchBaselineResultTypeDef,
    RegisterPatchBaselineForPatchGroupResultTypeDef,
    RegisterTargetWithMaintenanceWindowResultTypeDef,
    RegisterTaskWithMaintenanceWindowResultTypeDef,
    ResumeSessionResponseTypeDef,
    StartAutomationExecutionResultTypeDef,
    StartChangeRequestExecutionResultTypeDef,
    StartSessionResponseTypeDef,
    TerminateSessionResponseTypeDef,
    UnlabelParameterVersionResultTypeDef,
    UpdateMaintenanceWindowResultTypeDef,
    UpdateOpsMetadataResultTypeDef,
    UpdateAssociationStatusRequestRequestTypeDef,
    AssociationTypeDef,
    DescribeMaintenanceWindowsForTargetRequestRequestTypeDef,
    MaintenanceWindowTargetTypeDef,
    RegisterTargetWithMaintenanceWindowRequestRequestTypeDef,
    RunbookTypeDef,
    StartAutomationExecutionRequestRequestTypeDef,
    UpdateMaintenanceWindowTargetRequestRequestTypeDef,
    UpdateMaintenanceWindowTargetResultTypeDef,
    DescribeAssociationExecutionsRequestRequestTypeDef,
    AssociationExecutionTargetTypeDef,
    DescribeAssociationExecutionTargetsRequestRequestTypeDef,
    DescribeAssociationExecutionsResultTypeDef,
    ListAssociationsRequestRequestTypeDef,
    UpdateDocumentRequestRequestTypeDef,
    DescribeAutomationExecutionsRequestRequestTypeDef,
    GetCommandInvocationResultTypeDef,
    ListCommandInvocationsRequestRequestTypeDef,
    ListCommandsRequestRequestTypeDef,
    CommandInvocationTypeDef,
    CommandTypeDef,
    MaintenanceWindowRunCommandParametersTypeDef,
    SendCommandRequestRequestTypeDef,
    ComplianceItemTypeDef,
    PutComplianceItemsRequestRequestTypeDef,
    ListComplianceItemsRequestRequestTypeDef,
    ListComplianceSummariesRequestRequestTypeDef,
    ListResourceComplianceSummariesRequestRequestTypeDef,
    CompliantSummaryTypeDef,
    NonCompliantSummaryTypeDef,
    CreateActivationRequestRequestTypeDef,
    CreateDocumentRequestRequestTypeDef,
    DocumentIdentifierTypeDef,
    GetDocumentResultTypeDef,
    OpsItemSummaryTypeDef,
    CreateOpsItemRequestRequestTypeDef,
    OpsItemTypeDef,
    UpdateOpsItemRequestRequestTypeDef,
    CreateOpsMetadataRequestRequestTypeDef,
    GetOpsMetadataResultTypeDef,
    UpdateOpsMetadataRequestRequestTypeDef,
    DescribeActivationsRequestRequestTypeDef,
    DescribeActivationsRequestDescribeActivationsPaginateTypeDef,
    DescribeAssociationExecutionTargetsRequestDescribeAssociationExecutionTargetsPaginateTypeDef,
    DescribeAssociationExecutionsRequestDescribeAssociationExecutionsPaginateTypeDef,
    DescribeAutomationExecutionsRequestDescribeAutomationExecutionsPaginateTypeDef,
    DescribeEffectiveInstanceAssociationsRequestDescribeEffectiveInstanceAssociationsPaginateTypeDef,
    DescribeEffectivePatchesForPatchBaselineRequestDescribeEffectivePatchesForPatchBaselinePaginateTypeDef,
    DescribeInstanceAssociationsStatusRequestDescribeInstanceAssociationsStatusPaginateTypeDef,
    DescribeInstancePatchStatesRequestDescribeInstancePatchStatesPaginateTypeDef,
    DescribeInventoryDeletionsRequestDescribeInventoryDeletionsPaginateTypeDef,
    DescribeMaintenanceWindowsForTargetRequestDescribeMaintenanceWindowsForTargetPaginateTypeDef,
    DescribePatchPropertiesRequestDescribePatchPropertiesPaginateTypeDef,
    GetInventorySchemaRequestGetInventorySchemaPaginateTypeDef,
    GetParameterHistoryRequestGetParameterHistoryPaginateTypeDef,
    ListAssociationVersionsRequestListAssociationVersionsPaginateTypeDef,
    ListAssociationsRequestListAssociationsPaginateTypeDef,
    ListCommandInvocationsRequestListCommandInvocationsPaginateTypeDef,
    ListCommandsRequestListCommandsPaginateTypeDef,
    ListComplianceItemsRequestListComplianceItemsPaginateTypeDef,
    ListComplianceSummariesRequestListComplianceSummariesPaginateTypeDef,
    ListDocumentVersionsRequestListDocumentVersionsPaginateTypeDef,
    ListResourceComplianceSummariesRequestListResourceComplianceSummariesPaginateTypeDef,
    ListResourceDataSyncRequestListResourceDataSyncPaginateTypeDef,
    DescribeAutomationStepExecutionsRequestDescribeAutomationStepExecutionsPaginateTypeDef,
    DescribeAutomationStepExecutionsRequestRequestTypeDef,
    DescribeAvailablePatchesRequestDescribeAvailablePatchesPaginateTypeDef,
    DescribeAvailablePatchesRequestRequestTypeDef,
    DescribeInstancePatchesRequestDescribeInstancePatchesPaginateTypeDef,
    DescribeInstancePatchesRequestRequestTypeDef,
    DescribeMaintenanceWindowScheduleRequestDescribeMaintenanceWindowSchedulePaginateTypeDef,
    DescribeMaintenanceWindowScheduleRequestRequestTypeDef,
    DescribePatchBaselinesRequestDescribePatchBaselinesPaginateTypeDef,
    DescribePatchBaselinesRequestRequestTypeDef,
    DescribePatchGroupsRequestDescribePatchGroupsPaginateTypeDef,
    DescribePatchGroupsRequestRequestTypeDef,
    DescribeAvailablePatchesResultTypeDef,
    DescribeEffectiveInstanceAssociationsResultTypeDef,
    DescribeInstanceInformationRequestDescribeInstanceInformationPaginateTypeDef,
    DescribeInstanceInformationRequestRequestTypeDef,
    DescribeInstancePatchStatesForPatchGroupRequestDescribeInstancePatchStatesForPatchGroupPaginateTypeDef,
    DescribeInstancePatchStatesForPatchGroupRequestRequestTypeDef,
    DescribeInstancePatchStatesForPatchGroupResultTypeDef,
    DescribeInstancePatchStatesResultTypeDef,
    DescribeInstancePatchesResultTypeDef,
    DescribeMaintenanceWindowExecutionTaskInvocationsRequestDescribeMaintenanceWindowExecutionTaskInvocationsPaginateTypeDef,
    DescribeMaintenanceWindowExecutionTaskInvocationsRequestRequestTypeDef,
    DescribeMaintenanceWindowExecutionTasksRequestDescribeMaintenanceWindowExecutionTasksPaginateTypeDef,
    DescribeMaintenanceWindowExecutionTasksRequestRequestTypeDef,
    DescribeMaintenanceWindowExecutionsRequestDescribeMaintenanceWindowExecutionsPaginateTypeDef,
    DescribeMaintenanceWindowExecutionsRequestRequestTypeDef,
    DescribeMaintenanceWindowTargetsRequestDescribeMaintenanceWindowTargetsPaginateTypeDef,
    DescribeMaintenanceWindowTargetsRequestRequestTypeDef,
    DescribeMaintenanceWindowTasksRequestDescribeMaintenanceWindowTasksPaginateTypeDef,
    DescribeMaintenanceWindowTasksRequestRequestTypeDef,
    DescribeMaintenanceWindowsRequestDescribeMaintenanceWindowsPaginateTypeDef,
    DescribeMaintenanceWindowsRequestRequestTypeDef,
    DescribeMaintenanceWindowExecutionTaskInvocationsResultTypeDef,
    DescribeMaintenanceWindowExecutionTasksResultTypeDef,
    DescribeMaintenanceWindowExecutionsResultTypeDef,
    DescribeMaintenanceWindowScheduleResultTypeDef,
    DescribeMaintenanceWindowsForTargetResultTypeDef,
    DescribeMaintenanceWindowsResultTypeDef,
    DescribeOpsItemsRequestDescribeOpsItemsPaginateTypeDef,
    DescribeOpsItemsRequestRequestTypeDef,
    GetParametersByPathRequestGetParametersByPathPaginateTypeDef,
    GetParametersByPathRequestRequestTypeDef,
    DescribeParametersRequestDescribeParametersPaginateTypeDef,
    DescribeParametersRequestRequestTypeDef,
    DescribePatchBaselinesResultTypeDef,
    PatchGroupPatchBaselineMappingTypeDef,
    DescribeSessionsRequestDescribeSessionsPaginateTypeDef,
    DescribeSessionsRequestRequestTypeDef,
    UpdateDocumentDefaultVersionResultTypeDef,
    DocumentDescriptionTypeDef,
    ListDocumentsRequestListDocumentsPaginateTypeDef,
    ListDocumentsRequestRequestTypeDef,
    DocumentReviewerResponseSourceTypeDef,
    DocumentReviewsTypeDef,
    ListDocumentVersionsResultTypeDef,
    EffectivePatchTypeDef,
    StepExecutionTypeDef,
    GetCommandInvocationRequestCommandExecutedWaitTypeDef,
    InventoryGroupTypeDef,
    ListInventoryEntriesRequestRequestTypeDef,
    GetInventoryRequestGetInventoryPaginateTypeDef,
    GetInventoryRequestRequestTypeDef,
    GetMaintenanceWindowExecutionTaskResultTypeDef,
    MaintenanceWindowTaskTypeDef,
    OpsAggregatorTypeDef,
    GetOpsSummaryRequestGetOpsSummaryPaginateTypeDef,
    GetOpsSummaryRequestRequestTypeDef,
    GetParameterResultTypeDef,
    GetParametersByPathResultTypeDef,
    GetParametersResultTypeDef,
    GetServiceSettingResultTypeDef,
    ResetServiceSettingResultTypeDef,
    InstanceInformationTypeDef,
    InstanceAssociationOutputLocationTypeDef,
    InstanceAssociationOutputUrlTypeDef,
    InventoryDeletionSummaryTypeDef,
    InventoryItemSchemaTypeDef,
    PutInventoryRequestRequestTypeDef,
    InventoryResultEntityTypeDef,
    ListOpsItemEventsRequestListOpsItemEventsPaginateTypeDef,
    ListOpsItemEventsRequestRequestTypeDef,
    ListOpsItemRelatedItemsRequestListOpsItemRelatedItemsPaginateTypeDef,
    ListOpsItemRelatedItemsRequestRequestTypeDef,
    ListOpsMetadataRequestListOpsMetadataPaginateTypeDef,
    ListOpsMetadataRequestRequestTypeDef,
    ListOpsMetadataResultTypeDef,
    OpsEntityTypeDef,
    OpsItemEventSummaryTypeDef,
    OpsItemRelatedItemSummaryTypeDef,
    ParameterHistoryTypeDef,
    ParameterMetadataTypeDef,
    PatchFilterGroupTypeDef,
    ResourceDataSyncAwsOrganizationsSourceTypeDef,
    ResourceDataSyncS3DestinationTypeDef,
    SessionTypeDef,
    DescribeActivationsResultTypeDef,
    ListAssociationsResultTypeDef,
    DescribeMaintenanceWindowTargetsResultTypeDef,
    AutomationExecutionMetadataTypeDef,
    StartChangeRequestExecutionRequestRequestTypeDef,
    DescribeAssociationExecutionTargetsResultTypeDef,
    ListCommandInvocationsResultTypeDef,
    ListCommandsResultTypeDef,
    SendCommandResultTypeDef,
    MaintenanceWindowTaskInvocationParametersTypeDef,
    ListComplianceItemsResultTypeDef,
    ComplianceSummaryItemTypeDef,
    ResourceComplianceSummaryItemTypeDef,
    ListDocumentsResultTypeDef,
    DescribeOpsItemsResponseTypeDef,
    GetOpsItemResponseTypeDef,
    DescribePatchGroupsResultTypeDef,
    CreateDocumentResultTypeDef,
    DescribeDocumentResultTypeDef,
    UpdateDocumentResultTypeDef,
    DocumentMetadataResponseInfoTypeDef,
    UpdateDocumentMetadataRequestRequestTypeDef,
    DescribeEffectivePatchesForPatchBaselineResultTypeDef,
    AutomationExecutionTypeDef,
    DescribeAutomationStepExecutionsResultTypeDef,
    InventoryAggregatorTypeDef,
    DescribeMaintenanceWindowTasksResultTypeDef,
    DescribeInstanceInformationResultTypeDef,
    AssociationDescriptionTypeDef,
    AssociationVersionInfoTypeDef,
    CreateAssociationBatchRequestEntryTypeDef,
    CreateAssociationRequestRequestTypeDef,
    UpdateAssociationRequestRequestTypeDef,
    InstanceAssociationStatusInfoTypeDef,
    DeleteInventoryResultTypeDef,
    InventoryDeletionStatusItemTypeDef,
    GetInventorySchemaResultTypeDef,
    GetInventoryResultTypeDef,
    GetOpsSummaryResultTypeDef,
    ListOpsItemEventsResponseTypeDef,
    ListOpsItemRelatedItemsResponseTypeDef,
    GetParameterHistoryResultTypeDef,
    DescribeParametersResultTypeDef,
    PatchRuleTypeDef,
    ResourceDataSyncSourceTypeDef,
    ResourceDataSyncSourceWithStateTypeDef,
    DescribeSessionsResponseTypeDef,
    DescribeAutomationExecutionsResultTypeDef,
    GetMaintenanceWindowTaskResultTypeDef,
    RegisterTaskWithMaintenanceWindowRequestRequestTypeDef,
    UpdateMaintenanceWindowTaskRequestRequestTypeDef,
    UpdateMaintenanceWindowTaskResultTypeDef,
    ListComplianceSummariesResultTypeDef,
    ListResourceComplianceSummariesResultTypeDef,
    ListDocumentMetadataHistoryResponseTypeDef,
    GetAutomationExecutionResultTypeDef,
    CreateAssociationResultTypeDef,
    DescribeAssociationResultTypeDef,
    UpdateAssociationResultTypeDef,
    UpdateAssociationStatusResultTypeDef,
    ListAssociationVersionsResultTypeDef,
    CreateAssociationBatchRequestRequestTypeDef,
    FailedCreateAssociationTypeDef,
    DescribeInstanceAssociationsStatusResultTypeDef,
    DescribeInventoryDeletionsResultTypeDef,
    PatchRuleGroupTypeDef,
    CreateResourceDataSyncRequestRequestTypeDef,
    UpdateResourceDataSyncRequestRequestTypeDef,
    ResourceDataSyncItemTypeDef,
    CreateAssociationBatchResultTypeDef,
    BaselineOverrideTypeDef,
    CreatePatchBaselineRequestRequestTypeDef,
    GetPatchBaselineResultTypeDef,
    UpdatePatchBaselineRequestRequestTypeDef,
    UpdatePatchBaselineResultTypeDef,
    ListResourceDataSyncResultTypeDef,
    GetDeployablePatchSnapshotForInstanceRequestRequestTypeDef,
)

def get_structure() -> AccountSharingInfoTypeDef:
    return {
      ...
    }
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-ssm` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ssm/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
