# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aio_odoorpc_base']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aio-odoorpc-base',
    'version': '2.0.5',
    'description': "Fast, simple Odoo RPC package with sync and async functions to pilot Odoo's jsonrpc API. Check aio-odoorpc for a higher-level, friendlier interface.",
    'long_description': "## Base functions to pilot Odoo's jsonrpc API (aio-odoorpc-base)\n\n---\n#### Note:\n\nA higher-level, friendlier interface is provided by aio-odoorpc, make sure to check that out\nas well.\n\n---\n\n### Description:\nThis is a core/base package with lower-level functions used by other higher-level\n'aio-odoorpc-*' packages that are used in production in at least one company.\n\nAll functions offered by this package are available in both async and sync versions. The sync\nversion is automatically generated from the async one, so they are always in sync! ;)\n\nHere you will find methods to access Odoo's external API, mirroring the dispatching\nmethods available on Odoo's jsonrpc endpoint (i.e. 'login', 'execute_kw', etc).\n\nIf you know how Odoo's external API work, this package may very well suit all your needs. Otherwise,\nif you prefer it a little higher level, you should check 'aio-odoorpc' which uses this package to\nimplement facilitating methods to call Odoo's model methods like 'search', search_read', 'read',\n'search_count', 'write', 'create', etc. Ultimately, those methods are all implemented through \n'execute_kw' API calls which this package provides.\n  \n\n### No dependencies:\nNo dependency is not a promise, just a preference. It may change in the future, but only if for very\ngood reason.\n\nThis also means that you are free to use whatever HTTP Client library you like. This package only\nrequires that:\n1. The http_client must support a '.post(url, json=a_dict)' method. All headers, etc must be\n   managed by you. Alternatively, a callable can be passed on in place of the http client, in which\n   case it will be called with a single argument: the json payload;\n2. The 'post' method mentioned above must return a response object that must have a '.json()'\n   method. This method may be synchronous or asynchronous (when using the async functions).\n   It must return a dict or dict-like object. This interface is supported by packages such\n   as 'requests', 'httpx' and 'aiohttp'. If your favorite library does not offer such interface, it\n   is easy to wrap the object yourself in order to provide it;\n\nI am willing to make modifications in the code in order to support other http client solutions, just\nget in touch (use the project's github repository for that).\n\nWhile it would be easier if this package shipped with a specific http client dependency, it should be\nnoted that having the possibility to reuse HTTP sessions is a great opportunity to improve the \nspeed of your running code. Also, it is possible that your project is already using some http client\nlibrary and here you have the opportunity to use it. \n\nRemember that you must use an async http client library if you are going to use the async functions,\nor use a synchronous http client library if you are going to use the sync function.\n\n#####Python HTTP Client packages known to be compatible:\n- sync-only: 'requests'\n- async-only: 'aiohttp'\n- sync and async: 'httpx'\n\n### Motivation:\nThe package 'odoorpc' is the most used and better maintained package to let you easily consume Odoo's\njsonrpc API. It has lots of functionality, good documentation, a large user base and was developed\nby people that are very experienced with Odoo in general and big contributors to the Odoo Community.  \nIn other words, if you are taking your first steps and do not need an async interface now, start with\nodoorpc.\n\nHowever, for my needs, once I was developing Odoo integrations that needed to make hundreds of calls\nto the Odoo API to complete a single job, I began to sorely miss an async interface as well as more\ncontrol over the HTTP client used (I wished for HTTP2 support and connection reuse).\n\nAlso, as I understood Odoo's external API, it started to sound like 'odoorpc' was too big for a task\ntoo simple. For instance, most of the time (like 99,99% of the time), you will be calling to a single\nREST method called 'execute_kw'. It is the same call over and over just changing the payload which \nitself is a simple json. \n\nSo I decided to develop a new package myself, made it async-first and tryed to keep it as simple as\npossible. Also, I decided to split it in two, a very simple base package (this one) with only methods\nthat mirror those in Odoo's external API and another one 'aio-odoorpc' that adds another layer to\nimplement Odoo's model methods like 'search', 'search_read', 'read', etc. as well as an object model\nto instantiate a class once and then make simple method invocation with few parameters to access \nwhat you need.  \n\n\n### TO-DOs:\n- Add functions to help getting data into Odoo, right now the functions are mostly to get data out;\n\n\n### Other things to know about this module:\n- It ships will a good suite of tests that run against an OCA runbot instance;\n\n- Asyncio is a python3 thing, so no python2 support;\n\n- Type hints are used everywhere;\n\n- This package uses jsonrpc only (no xmlrpc). There is a lack of async xmlrpc tooling and\n  jsonrpc is considered the best RPC protocol in Odoo (faster, more widely used);\n  \n- The synchronous version of the code is generated automatically from the asynchronous code, so at\n  least for now the effort to maintain both is minimal.\n\n- I am willing to take patches and to add other contributors to this project. Feel free to get in touch,\n  the github page is the best place to interact with the project and the project's author;\n\n- I only develop and run code in Linux environments, if you find a bug under other OS I am happy\n  to take patches but I will not myself spend time looking into these eventual bugs;\n\n\n### Things to know about Odoo RPC API:\n\n- The 'login' call is really only a lookup of the user_id (an int) of a user given a\n  database, username and password. If you are using this RPC client over and over in your code,\n  maybe even calling from a stateless cloud service, you should consider finding out the user id (uid)\n  of the user and pass the uid instead of the username to the constructor of AsyncOdooRPC. This way, \n  you do not need to call the login() RPC method to retrieve the uid, saving a RPC call;\n\n- The uid mentioned above is not a session-like id. It is really only the database id of the user\n  and it never expires. There is really no 'login' step required to access the Odoo RPC API if you\n  know the uid from the beginning;\n  \n\n### Usage\n\nOk, so let's start with some examples. I will omit the event_loop logic, I assume that if you want\nto use an async module you already have that sorted out yourself or through a framework like FastAPI.\n\nAll examples below could also be called using the synchronous OdooRPC object, but without the\n'await' syntax. Synchronous functions do not start with 'aio_', that is a marker of the async\nfunctions only.\n\nI recommend that you check the tests folder for many more examples. Also, the codebase is very very short,\ndo refer to it as well.\n\n```\nfrom aio_odoorpc_base import aio_login, aio_execute_kw, build_odoo_jsonrpc_endpoint_url\nimport httpx\n\nurl = 'https://odoo.acme.com/jsonrpc'\n\nasync with httpx.AsyncHttpClient(url=url) as client:\n    uid = await aio_login(http_client=client, database='acme', username='demo', password='demo')\n    data = await aio_execute_kw(http_client=client,\n                                database='acme',\n                                uid=uid,\n                                password='demo',\n                                model_name='sale.order',\n                                method='search_read',\n                                method_arg=[],\n                                method_kwargs = {'fields': ['partner_id', 'date_order', 'amount_total']}\n\n```\n",
    'author': 'mbello',
    'author_email': 'mbello@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mbello/aio-odoorpc-base',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
