# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UserSettings(BaseModel):
    """
    UserSettings
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Globally unique identifier of a user setting")
    dataset_count: Union[StrictFloat, StrictInt] = Field(description="The users preferred number of datasets to view per page", alias="datasetCount")
    job_count: Union[StrictFloat, StrictInt] = Field(description="The users preferred number of jobs to view per page", alias="jobCount")
    user_id: StrictStr = Field(alias="userId")
    external_settings: Dict[str, Any] = Field(description="A customizable object for storing the user's external settings, which can contain various nested properties and configurations.", alias="externalSettings")
    __properties: ClassVar[List[str]] = ["id", "datasetCount", "jobCount", "userId", "externalSettings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "datasetCount": obj.get("datasetCount") if obj.get("datasetCount") is not None else 25,
            "jobCount": obj.get("jobCount") if obj.get("jobCount") is not None else 25,
            "userId": obj.get("userId"),
            "externalSettings": obj.get("externalSettings")
        })
        return _obj


