# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from scicat_sdk_py.models.user_profile import UserProfile
from typing import Optional, Set
from typing_extensions import Self

class UserIdentity(BaseModel):
    """
    UserIdentity
    """ # noqa: E501
    auth_strategy: StrictStr = Field(alias="authStrategy")
    created: datetime
    credentials: Dict[str, Any]
    external_id: StrictStr = Field(alias="externalId")
    modified: datetime
    profile: UserProfile
    provider: StrictStr
    user_id: StrictStr = Field(alias="userId")
    __properties: ClassVar[List[str]] = ["authStrategy", "created", "credentials", "externalId", "modified", "profile", "provider", "userId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserIdentity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserIdentity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "authStrategy": obj.get("authStrategy"),
            "created": obj.get("created"),
            "credentials": obj.get("credentials"),
            "externalId": obj.get("externalId"),
            "modified": obj.get("modified"),
            "profile": UserProfile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "provider": obj.get("provider"),
            "userId": obj.get("userId")
        })
        return _obj


