# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdatePolicyDto(BaseModel):
    """
    UpdatePolicyDto
    """ # noqa: E501
    owner_group: StrictStr = Field(description="Name of the group owning this item.", alias="ownerGroup")
    access_groups: Optional[List[StrictStr]] = Field(default=None, description="List of groups which have access to this item.", alias="accessGroups")
    instrument_group: Optional[StrictStr] = Field(default=None, description="Group of the instrument which this item was acquired on.", alias="instrumentGroup")
    manager: List[StrictStr]
    tape_redundancy: StrictStr = Field(alias="tapeRedundancy")
    auto_archive: StrictBool = Field(alias="autoArchive")
    auto_archive_delay: Union[StrictFloat, StrictInt] = Field(alias="autoArchiveDelay")
    archive_email_notification: StrictBool = Field(alias="archiveEmailNotification")
    archive_emails_to_be_notified: List[StrictStr] = Field(alias="archiveEmailsToBeNotified")
    retrieve_email_notification: StrictBool = Field(alias="retrieveEmailNotification")
    retrieve_emails_to_be_notified: List[StrictStr] = Field(alias="retrieveEmailsToBeNotified")
    embargo_period: Union[StrictFloat, StrictInt] = Field(alias="embargoPeriod")
    __properties: ClassVar[List[str]] = ["ownerGroup", "accessGroups", "instrumentGroup", "manager", "tapeRedundancy", "autoArchive", "autoArchiveDelay", "archiveEmailNotification", "archiveEmailsToBeNotified", "retrieveEmailNotification", "retrieveEmailsToBeNotified", "embargoPeriod"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePolicyDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePolicyDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ownerGroup": obj.get("ownerGroup"),
            "accessGroups": obj.get("accessGroups"),
            "instrumentGroup": obj.get("instrumentGroup"),
            "manager": obj.get("manager"),
            "tapeRedundancy": obj.get("tapeRedundancy"),
            "autoArchive": obj.get("autoArchive"),
            "autoArchiveDelay": obj.get("autoArchiveDelay"),
            "archiveEmailNotification": obj.get("archiveEmailNotification"),
            "archiveEmailsToBeNotified": obj.get("archiveEmailsToBeNotified"),
            "retrieveEmailNotification": obj.get("retrieveEmailNotification"),
            "retrieveEmailsToBeNotified": obj.get("retrieveEmailsToBeNotified"),
            "embargoPeriod": obj.get("embargoPeriod")
        })
        return _obj


