# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scicat_sdk_py.models.attachment import Attachment
from scicat_sdk_py.models.dataset_class import DatasetClass
from typing import Optional, Set
from typing_extensions import Self

class SampleWithAttachmentsAndDatasets(BaseModel):
    """
    SampleWithAttachmentsAndDatasets
    """ # noqa: E501
    created_by: StrictStr = Field(description="Indicate the user who created this record. This property is added and maintained by the system.", alias="createdBy")
    updated_by: StrictStr = Field(description="Indicate the user who updated this record last. This property is added and maintained by the system.", alias="updatedBy")
    created_at: datetime = Field(description="Date and time when this record was created. This field is managed by mongoose with through the timestamp settings. The field should be a string containing a date in ISO 8601 format (2024-02-27T12:26:57.313Z)", alias="createdAt")
    updated_at: datetime = Field(description="Date and time when this record was updated last. This field is managed by mongoose with through the timestamp settings. The field should be a string containing a date in ISO 8601 format (2024-02-27T12:26:57.313Z)", alias="updatedAt")
    owner_group: StrictStr = Field(description="Defines the group which owns the data, and therefore has unrestricted access to this data. Usually a pgroup like p12151", alias="ownerGroup")
    access_groups: List[StrictStr] = Field(description="Optional additional groups which have read access to the data. Users which are members in one of the groups listed here are allowed to access this data. The special group 'public' makes data available to all users.", alias="accessGroups")
    instrument_group: Optional[StrictStr] = Field(default=None, description="Optional additional groups which have read and write access to the data. Users which are members in one of the groups listed here are allowed to access this data.", alias="instrumentGroup")
    is_published: StrictBool = Field(description="Flag is true when data are made publicly available.", alias="isPublished")
    sample_id: StrictStr = Field(description="Globally unique identifier of a sample. This could be provided as an input value or generated by the system.", alias="sampleId")
    owner: Optional[StrictStr] = Field(default=None, description="The owner of the sample.")
    description: Optional[StrictStr] = Field(default=None, description="A description of the sample.")
    sample_characteristics: Optional[Dict[str, Any]] = Field(default=None, description="JSON object containing the sample characteristics metadata.", alias="sampleCharacteristics")
    attachments: Optional[List[Attachment]] = Field(default=None, description="Attachments that are related to this sample.")
    datasets: Optional[List[DatasetClass]] = Field(default=None, description="Datasets that are related to this sample.")
    __properties: ClassVar[List[str]] = ["createdBy", "updatedBy", "createdAt", "updatedAt", "ownerGroup", "accessGroups", "instrumentGroup", "isPublished", "sampleId", "owner", "description", "sampleCharacteristics", "attachments", "datasets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SampleWithAttachmentsAndDatasets from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in datasets (list)
        _items = []
        if self.datasets:
            for _item_datasets in self.datasets:
                if _item_datasets:
                    _items.append(_item_datasets.to_dict())
            _dict['datasets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SampleWithAttachmentsAndDatasets from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdBy": obj.get("createdBy"),
            "updatedBy": obj.get("updatedBy"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "ownerGroup": obj.get("ownerGroup"),
            "accessGroups": obj.get("accessGroups"),
            "instrumentGroup": obj.get("instrumentGroup"),
            "isPublished": obj.get("isPublished") if obj.get("isPublished") is not None else False,
            "sampleId": obj.get("sampleId"),
            "owner": obj.get("owner"),
            "description": obj.get("description"),
            "sampleCharacteristics": obj.get("sampleCharacteristics"),
            "attachments": [Attachment.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "datasets": [DatasetClass.from_dict(_item) for _item in obj["datasets"]] if obj.get("datasets") is not None else None
        })
        return _obj


