# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from scicat_sdk_py.models.returned_user_dto import ReturnedUserDto
from typing import Optional, Set
from typing_extensions import Self

class ReturnedAuthLoginDto(BaseModel):
    """
    ReturnedAuthLoginDto
    """ # noqa: E501
    access_token: StrictStr = Field(description="JWT token used for authentication and authorization in subsequents calls")
    id: StrictStr = Field(description="Unique id of this request which matches the JWT token in the field above")
    expires_in: Union[StrictFloat, StrictInt] = Field(description="Expiration time of the JWT in seconds from creation time")
    ttl: Union[StrictFloat, StrictInt] = Field(description="Time to live of the JWT in seconds from creation time")
    created: StrictStr = Field(description="Date time in ISO 8601 format when the JWT was created")
    user_id: StrictStr = Field(description="Unique user id of the user logged in", alias="userId")
    user: ReturnedUserDto = Field(description="User information as they are stored in the system")
    __properties: ClassVar[List[str]] = ["access_token", "id", "expires_in", "ttl", "created", "userId", "user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReturnedAuthLoginDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReturnedAuthLoginDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_token": obj.get("access_token"),
            "id": obj.get("id"),
            "expires_in": obj.get("expires_in"),
            "ttl": obj.get("ttl"),
            "created": obj.get("created"),
            "userId": obj.get("userId"),
            "user": ReturnedUserDto.from_dict(obj["user"]) if obj.get("user") is not None else None
        })
        return _obj


