# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PublishedData(BaseModel):
    """
    PublishedData
    """ # noqa: E501
    doi: StrictStr = Field(description="Digital Object Identifier; e.g., \"10.xxx/9b1deb4d-3b7d-4bad-9bdd-2b0d7b3dcb6d\".")
    affiliation: Optional[StrictStr] = Field(default=None, description="Creator Affiliation.  This field has the semantics of [DataCite Creator/affiliation](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/creator/#affiliation).")
    creator: List[StrictStr] = Field(description="Creator of dataset/dataset collection.  This field has the semantics of Dublin Core [dcmi:creator](https://www.dublincore.org/specifications/dublin-core/dcmi-terms/terms/creator/) and [DataCite Creator/creatorName](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/creator/#creatorname).")
    publisher: StrictStr = Field(description="Dataset publisher.  This field has the semantics of Dublin Core [dcmi:publisher](https://www.dublincore.org/specifications/dublin-core/dcmi-terms/terms/publisher/) and [DataCite publisher](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/publisher).")
    publication_year: Union[StrictFloat, StrictInt] = Field(description="Year of publication.  This field has the semantics of Dublin Core [dcmi:date](https://www.dublincore.org/specifications/dublin-core/dcmi-terms/terms/date/) and [DataCite publicationYear](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/publicationyear/).", alias="publicationYear")
    title: StrictStr = Field(description="The title of the data.  This field has the semantics of Dublin Core [dcmi:title](https://www.dublincore.org/specifications/dublin-core/dcmi-terms/terms/title/) and [DataCite title](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/title/).")
    url: Optional[StrictStr] = Field(default=None, description="Full URL to the landing page for this DOI")
    abstract: StrictStr = Field(description="Abstract text for published datasets.  This field has the semantics of [DataCite description](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/description/) with [Abstract descriptionType](https://datacite-metadata-schema.readthedocs.io/en/4.5/appendices/appendix-1/descriptionType/#abstract).")
    data_description: StrictStr = Field(description="Link to description of how to re-use data.  This field has the semantics of Dublic Core [dcmi:description](https://www.dublincore.org/specifications/dublin-core/dcmi-terms/terms/description/) and [DataCite description](https://datacite-metadata-schema.readthedocs.io/en/4.5/properties/description/) with [Abstract descriptionType](https://datacite-metadata-schema.readthedocs.io/en/4.5/appendices/appendix-1/descriptionType/#abstract).", alias="dataDescription")
    resource_type: StrictStr = Field(description="e.g. raw/ derived", alias="resourceType")
    number_of_files: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of files", alias="numberOfFiles")
    size_of_archive: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Size of archive", alias="sizeOfArchive")
    pid_array: List[StrictStr] = Field(description="Array of one or more Dataset persistent identifier (pid) values that make up the published data.", alias="pidArray")
    authors: Optional[List[StrictStr]] = Field(default=None, description="List of Names of authors of the to be published data")
    registered_time: datetime = Field(description="Time when doi is successfully registered", alias="registeredTime")
    status: StrictStr = Field(description="Indication of position in publication workflow e.g. doiRegistered")
    scicat_user: Optional[StrictStr] = Field(default=None, description="The username of the user that clicks the publish button in the client", alias="scicatUser")
    thumbnail: Optional[StrictStr] = Field(default=None, description="Small, less than 16 MB base 64 image preview of dataset")
    related_publications: Optional[List[StrictStr]] = Field(default=None, description="List of URLs pointing to related publications like DOI URLS of journal articles", alias="relatedPublications")
    download_link: Optional[StrictStr] = Field(default=None, description="URL pointing to page from which data can be downloaded", alias="downloadLink")
    created_at: datetime = Field(description="Date when the published data was created. This property is added and maintained by the system", alias="createdAt")
    updated_at: datetime = Field(description="Date when the published data was last updated. This property is added and maintained by the system", alias="updatedAt")
    __properties: ClassVar[List[str]] = ["doi", "affiliation", "creator", "publisher", "publicationYear", "title", "url", "abstract", "dataDescription", "resourceType", "numberOfFiles", "sizeOfArchive", "pidArray", "authors", "registeredTime", "status", "scicatUser", "thumbnail", "relatedPublications", "downloadLink", "createdAt", "updatedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublishedData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublishedData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "doi": obj.get("doi"),
            "affiliation": obj.get("affiliation"),
            "creator": obj.get("creator"),
            "publisher": obj.get("publisher"),
            "publicationYear": obj.get("publicationYear"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "abstract": obj.get("abstract"),
            "dataDescription": obj.get("dataDescription"),
            "resourceType": obj.get("resourceType"),
            "numberOfFiles": obj.get("numberOfFiles"),
            "sizeOfArchive": obj.get("sizeOfArchive"),
            "pidArray": obj.get("pidArray"),
            "authors": obj.get("authors"),
            "registeredTime": obj.get("registeredTime"),
            "status": obj.get("status"),
            "scicatUser": obj.get("scicatUser"),
            "thumbnail": obj.get("thumbnail"),
            "relatedPublications": obj.get("relatedPublications"),
            "downloadLink": obj.get("downloadLink"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


