# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scicat_sdk_py.models.create_measurement_period_dto import CreateMeasurementPeriodDto
from typing import Optional, Set
from typing_extensions import Self

class PartialUpdateProposalDto(BaseModel):
    """
    PartialUpdateProposalDto
    """ # noqa: E501
    owner_group: Optional[StrictStr] = Field(default=None, description="Name of the group owning this item.", alias="ownerGroup")
    access_groups: Optional[List[StrictStr]] = Field(default=None, description="List of groups which have access to this item.", alias="accessGroups")
    instrument_group: Optional[StrictStr] = Field(default=None, description="Group of the instrument which this item was acquired on.", alias="instrumentGroup")
    pi_email: Optional[StrictStr] = Field(default=None, description="Email of principal investigator.")
    pi_firstname: Optional[StrictStr] = Field(default=None, description="First name of principal investigator.")
    pi_lastname: Optional[StrictStr] = Field(default=None, description="Last name of principal investigator.")
    email: Optional[StrictStr] = Field(default=None, description="Email of main proposer.")
    firstname: Optional[StrictStr] = Field(default=None, description="First name of main proposer.")
    lastname: Optional[StrictStr] = Field(default=None, description="Last name of main proposer.")
    title: Optional[StrictStr] = Field(default=None, description="The title of the proposal.")
    abstract: Optional[StrictStr] = Field(default=None, description="The proposal abstract.")
    start_time: Optional[datetime] = Field(default=None, description="The date when the data collection starts.", alias="startTime")
    end_time: Optional[datetime] = Field(default=None, description="The date when data collection finishes.", alias="endTime")
    measurement_period_list: Optional[List[CreateMeasurementPeriodDto]] = Field(default=None, description="Embedded information used inside proposals to define which type of experiment has to be pursued, where (at which instrument) and when.", alias="MeasurementPeriodList")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="JSON object containing the proposal metadata.")
    parent_proposal_id: Optional[StrictStr] = Field(default=None, description="Parent proposal id.", alias="parentProposalId")
    type: Optional[StrictStr] = Field(default=None, description="Characterize type of proposal, use some of the configured values")
    __properties: ClassVar[List[str]] = ["ownerGroup", "accessGroups", "instrumentGroup", "pi_email", "pi_firstname", "pi_lastname", "email", "firstname", "lastname", "title", "abstract", "startTime", "endTime", "MeasurementPeriodList", "metadata", "parentProposalId", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PartialUpdateProposalDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in measurement_period_list (list)
        _items = []
        if self.measurement_period_list:
            for _item_measurement_period_list in self.measurement_period_list:
                if _item_measurement_period_list:
                    _items.append(_item_measurement_period_list.to_dict())
            _dict['MeasurementPeriodList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PartialUpdateProposalDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ownerGroup": obj.get("ownerGroup"),
            "accessGroups": obj.get("accessGroups"),
            "instrumentGroup": obj.get("instrumentGroup"),
            "pi_email": obj.get("pi_email"),
            "pi_firstname": obj.get("pi_firstname"),
            "pi_lastname": obj.get("pi_lastname"),
            "email": obj.get("email"),
            "firstname": obj.get("firstname"),
            "lastname": obj.get("lastname"),
            "title": obj.get("title"),
            "abstract": obj.get("abstract"),
            "startTime": obj.get("startTime"),
            "endTime": obj.get("endTime"),
            "MeasurementPeriodList": [CreateMeasurementPeriodDto.from_dict(_item) for _item in obj["MeasurementPeriodList"]] if obj.get("MeasurementPeriodList") is not None else None,
            "metadata": obj.get("metadata"),
            "parentProposalId": obj.get("parentProposalId"),
            "type": obj.get("type")
        })
        return _obj


