# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LifecycleClass(BaseModel):
    """
    LifecycleClass
    """ # noqa: E501
    archivable: Optional[StrictBool] = Field(default=None, description="Flag indicating if dataset is available to be archived and no archive job for this dataset exists yet.")
    retrievable: Optional[StrictBool] = Field(default=None, description="Flag indicating if dataset is stored on archive system and is ready to be retrieved.")
    publishable: Optional[StrictBool] = Field(default=None, description="Flag indicating if dataset can be published. Usually requires a longterm storage option on tape or similar.")
    date_of_disk_purging: Optional[datetime] = Field(default=None, description="Day when dataset will be removed from disk, assuming that is already stored on tape.", alias="dateOfDiskPurging")
    archive_retention_time: Optional[datetime] = Field(default=None, description="Day when the dataset's future fate will be evaluated again, e.g. to decide if the dataset can be deleted from archive.", alias="archiveRetentionTime")
    date_of_publishing: Optional[datetime] = Field(default=None, description="Day when dataset is supposed to become public according to data policy.", alias="dateOfPublishing")
    published_on: Optional[datetime] = Field(default=None, description="Day when dataset was published.", alias="publishedOn")
    is_on_central_disk: Optional[StrictBool] = Field(default=None, description="Flag indicating if full dataset is available on central fileserver. If false, data needs to be copied from decentral storage places to a cache server before the ingest. This information needs to be transferred to the archive system at archive time.", alias="isOnCentralDisk")
    archive_status_message: Optional[StrictStr] = Field(default='', description="Short string defining the current status of the dataset with respect to storage on disk/tape.", alias="archiveStatusMessage")
    retrieve_status_message: Optional[StrictStr] = Field(default='', description="Latest message for this dataset concerning retrieval from archive system.", alias="retrieveStatusMessage")
    archive_return_message: Optional[Dict[str, Any]] = Field(default=None, description="Detailed status or error message returned by the archive system when archiving this dataset.", alias="archiveReturnMessage")
    retrieve_return_message: Optional[Dict[str, Any]] = Field(default=None, description="Detailed status or error message returned by the archive system when retrieving this dataset.", alias="retrieveReturnMessage")
    exported_to: Optional[StrictStr] = Field(default=None, description="Location of the last export destination.", alias="exportedTo")
    retrieve_integrity_check: Optional[StrictBool] = Field(default=False, description="Set to true when checksum tests after retrieve of datasets were successful.", alias="retrieveIntegrityCheck")
    __properties: ClassVar[List[str]] = ["archivable", "retrievable", "publishable", "dateOfDiskPurging", "archiveRetentionTime", "dateOfPublishing", "publishedOn", "isOnCentralDisk", "archiveStatusMessage", "retrieveStatusMessage", "archiveReturnMessage", "retrieveReturnMessage", "exportedTo", "retrieveIntegrityCheck"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LifecycleClass from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LifecycleClass from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "archivable": obj.get("archivable"),
            "retrievable": obj.get("retrievable"),
            "publishable": obj.get("publishable"),
            "dateOfDiskPurging": obj.get("dateOfDiskPurging"),
            "archiveRetentionTime": obj.get("archiveRetentionTime"),
            "dateOfPublishing": obj.get("dateOfPublishing"),
            "publishedOn": obj.get("publishedOn"),
            "isOnCentralDisk": obj.get("isOnCentralDisk"),
            "archiveStatusMessage": obj.get("archiveStatusMessage") if obj.get("archiveStatusMessage") is not None else '',
            "retrieveStatusMessage": obj.get("retrieveStatusMessage") if obj.get("retrieveStatusMessage") is not None else '',
            "archiveReturnMessage": obj.get("archiveReturnMessage"),
            "retrieveReturnMessage": obj.get("retrieveReturnMessage"),
            "exportedTo": obj.get("exportedTo"),
            "retrieveIntegrityCheck": obj.get("retrieveIntegrityCheck") if obj.get("retrieveIntegrityCheck") is not None else False
        })
        return _obj


