# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scicat_sdk_py.models.i_dataset_list import IDatasetList
from typing import Optional, Set
from typing_extensions import Self

class JobClass(BaseModel):
    """
    JobClass
    """ # noqa: E501
    id: StrictStr = Field(description="Globally unique identifier of a job.", alias="_id")
    id: StrictStr = Field(description="Globally unique identifier of a job.")
    email_job_initiator: StrictStr = Field(description="The email of the person initiating the job request.", alias="emailJobInitiator")
    type: StrictStr = Field(description="Type of job, e.g. archive, retrieve etc")
    creation_time: datetime = Field(description="Time when job is created. Format according to chapter 5.6 internet date/time format in RFC 3339. This is handled automatically by mongoose with timestamps flag.", alias="creationTime")
    execution_time: datetime = Field(description="Time when job should be executed. If not specified then the Job will be executed asap. Format according to chapter 5.6 internet date/time format in RFC 3339.", alias="executionTime")
    job_params: Dict[str, Any] = Field(description="Object of key-value pairs defining job input parameters, e.g. 'destinationPath' for retrieve jobs or 'tapeCopies' for archive jobs.", alias="jobParams")
    job_status_message: StrictStr = Field(description="Defines current status of job lifecycle.", alias="jobStatusMessage")
    dataset_list: Optional[List[IDatasetList]] = Field(default=None, description="Array of objects with keys: pid, files. The value for the pid key defines the dataset ID, the value for the files key is an array of file names. This array is either an empty array, implying that all files within the dataset are selected or an explicit list of dataset-relative file paths, which should be selected.", alias="datasetList")
    job_result_object: Dict[str, Any] = Field(description="Detailed return value after job is finished.", alias="jobResultObject")
    owner_group: StrictStr = Field(description="Defines the group which owns the data, and therefore has unrestricted access to this data. Usually a pgroup like p12151", alias="ownerGroup")
    __properties: ClassVar[List[str]] = ["_id", "id", "emailJobInitiator", "type", "creationTime", "executionTime", "jobParams", "jobStatusMessage", "datasetList", "jobResultObject", "ownerGroup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobClass from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dataset_list (list)
        _items = []
        if self.dataset_list:
            for _item_dataset_list in self.dataset_list:
                if _item_dataset_list:
                    _items.append(_item_dataset_list.to_dict())
            _dict['datasetList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobClass from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "id": obj.get("id"),
            "emailJobInitiator": obj.get("emailJobInitiator"),
            "type": obj.get("type"),
            "creationTime": obj.get("creationTime"),
            "executionTime": obj.get("executionTime"),
            "jobParams": obj.get("jobParams"),
            "jobStatusMessage": obj.get("jobStatusMessage"),
            "datasetList": [IDatasetList.from_dict(_item) for _item in obj["datasetList"]] if obj.get("datasetList") is not None else None,
            "jobResultObject": obj.get("jobResultObject"),
            "ownerGroup": obj.get("ownerGroup")
        })
        return _obj


