# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from scicat_sdk_py.models.create_derived_dataset_obsolete_dto import CreateDerivedDatasetObsoleteDto
from scicat_sdk_py.models.create_raw_dataset_obsolete_dto import CreateRawDatasetObsoleteDto
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

DATASETSCONTROLLERCREATEREQUEST_ONE_OF_SCHEMAS = ["CreateDerivedDatasetObsoleteDto", "CreateRawDatasetObsoleteDto"]

class DatasetsControllerCreateRequest(BaseModel):
    """
    DatasetsControllerCreateRequest
    """
    # data type: CreateRawDatasetObsoleteDto
    oneof_schema_1_validator: Optional[CreateRawDatasetObsoleteDto] = None
    # data type: CreateDerivedDatasetObsoleteDto
    oneof_schema_2_validator: Optional[CreateDerivedDatasetObsoleteDto] = None
    actual_instance: Optional[Union[CreateDerivedDatasetObsoleteDto, CreateRawDatasetObsoleteDto]] = None
    one_of_schemas: Set[str] = { "CreateDerivedDatasetObsoleteDto", "CreateRawDatasetObsoleteDto" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = DatasetsControllerCreateRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: CreateRawDatasetObsoleteDto
        if not isinstance(v, CreateRawDatasetObsoleteDto):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CreateRawDatasetObsoleteDto`")
        else:
            match += 1
        # validate data type: CreateDerivedDatasetObsoleteDto
        if not isinstance(v, CreateDerivedDatasetObsoleteDto):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CreateDerivedDatasetObsoleteDto`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in DatasetsControllerCreateRequest with oneOf schemas: CreateDerivedDatasetObsoleteDto, CreateRawDatasetObsoleteDto. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in DatasetsControllerCreateRequest with oneOf schemas: CreateDerivedDatasetObsoleteDto, CreateRawDatasetObsoleteDto. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into CreateRawDatasetObsoleteDto
        try:
            instance.actual_instance = CreateRawDatasetObsoleteDto.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CreateDerivedDatasetObsoleteDto
        try:
            instance.actual_instance = CreateDerivedDatasetObsoleteDto.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into DatasetsControllerCreateRequest with oneOf schemas: CreateDerivedDatasetObsoleteDto, CreateRawDatasetObsoleteDto. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into DatasetsControllerCreateRequest with oneOf schemas: CreateDerivedDatasetObsoleteDto, CreateRawDatasetObsoleteDto. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CreateDerivedDatasetObsoleteDto, CreateRawDatasetObsoleteDto]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


