# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from scicat_sdk_py.models.history_class import HistoryClass
from scicat_sdk_py.models.lifecycle_class import LifecycleClass
from scicat_sdk_py.models.relationship_class import RelationshipClass
from scicat_sdk_py.models.technique_class import TechniqueClass
from typing import Optional, Set
from typing_extensions import Self

class DatasetClass(BaseModel):
    """
    DatasetClass
    """ # noqa: E501
    created_by: StrictStr = Field(description="Indicate the user who created this record. This property is added and maintained by the system.", alias="createdBy")
    updated_by: StrictStr = Field(description="Indicate the user who updated this record last. This property is added and maintained by the system.", alias="updatedBy")
    created_at: datetime = Field(description="Date and time when this record was created. This field is managed by mongoose with through the timestamp settings. The field should be a string containing a date in ISO 8601 format (2024-02-27T12:26:57.313Z)", alias="createdAt")
    updated_at: datetime = Field(description="Date and time when this record was updated last. This field is managed by mongoose with through the timestamp settings. The field should be a string containing a date in ISO 8601 format (2024-02-27T12:26:57.313Z)", alias="updatedAt")
    owner_group: StrictStr = Field(description="Defines the group which owns the data, and therefore has unrestricted access to this data. Usually a pgroup like p12151", alias="ownerGroup")
    access_groups: List[StrictStr] = Field(description="Optional additional groups which have read access to the data. Users which are members in one of the groups listed here are allowed to access this data. The special group 'public' makes data available to all users.", alias="accessGroups")
    instrument_group: Optional[StrictStr] = Field(default=None, description="Optional additional groups which have read and write access to the data. Users which are members in one of the groups listed here are allowed to access this data.", alias="instrumentGroup")
    is_published: StrictBool = Field(description="Flag is true when data are made publicly available.", alias="isPublished")
    pid: StrictStr = Field(description="Persistent Identifier for datasets derived from UUIDv4 and prepended automatically by site specific PID prefix like 20.500.12345/")
    owner: StrictStr = Field(description="Owner or custodian of the dataset, usually first name + last name. The string may contain a list of persons, which should then be separated by semicolons.")
    owner_email: Optional[StrictStr] = Field(default=None, description="Email of the owner or custodian of the dataset. The string may contain a list of emails, which should then be separated by semicolons.", alias="ownerEmail")
    orcid_of_owner: Optional[StrictStr] = Field(default=None, description="ORCID of the owner or custodian. The string may contain a list of ORCIDs, which should then be separated by semicolons.", alias="orcidOfOwner")
    contact_email: StrictStr = Field(description="Email of the contact person for this dataset. The string may contain a list of emails, which should then be separated by semicolons.", alias="contactEmail")
    source_folder: StrictStr = Field(description="Absolute file path on file server containing the files of this dataset, e.g. /some/path/to/sourcefolder. In case of a single file dataset, e.g. HDF5 data, it contains the path up to, but excluding the filename. Trailing slashes are removed.", alias="sourceFolder")
    source_folder_host: Optional[StrictStr] = Field(default=None, description="DNS host name of file server hosting sourceFolder, optionally including a protocol e.g. [protocol://]fileserver1.example.com", alias="sourceFolderHost")
    size: Union[StrictFloat, StrictInt] = Field(description="Total size of all source files contained in source folder on disk when unpacked.")
    packed_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Total size of all datablock package files created for this dataset.", alias="packedSize")
    number_of_files: Union[StrictFloat, StrictInt] = Field(description="Total number of files in all OrigDatablocks for this dataset.", alias="numberOfFiles")
    number_of_files_archived: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Total number of files in all Datablocks for this dataset.", alias="numberOfFilesArchived")
    creation_time: datetime = Field(description="Time when dataset became fully available on disk, i.e. all containing files have been written,  or the dataset was created in SciCat.<br>It is expected to be in ISO8601 format according to specifications for internet date/time format in RFC 3339, chapter 5.6 (https://www.rfc-editor.org/rfc/rfc3339#section-5).<br>Local times without timezone/offset info are automatically transformed to UTC using the timezone of the API server.", alias="creationTime")
    type: StrictStr = Field(description="Characterize type of dataset, either 'raw' or 'derived'. Autofilled when choosing the proper inherited models.")
    validation_status: Optional[StrictStr] = Field(default=None, description="Defines a level of trust, e.g. a measure of how much data was verified or used by other persons.", alias="validationStatus")
    keywords: Optional[List[StrictStr]] = Field(default=None, description="Array of tags associated with the meaning or contents of this dataset. Values should ideally come from defined vocabularies, taxonomies, ontologies or knowledge graphs.")
    description: Optional[StrictStr] = Field(default=None, description="Free text explanation of contents of dataset.")
    dataset_name: StrictStr = Field(description="A name for the dataset, given by the creator to carry some semantic meaning. Useful for display purposes e.g. instead of displaying the pid.", alias="datasetName")
    classification: Optional[StrictStr] = Field(default=None, description="ACIA information about AUthenticity,COnfidentiality,INtegrity and AVailability requirements of dataset. E.g. AV(ailabilty)=medium could trigger the creation of a two tape copies. Format 'AV=medium,CO=low'. Please check the following post for more info: https://en.wikipedia.org/wiki/Parkerian_Hexad")
    license: Optional[StrictStr] = Field(default=None, description="Name of the license under which the data can be used.")
    version: StrictStr = Field(description="Version of the API used when the dataset was created or last updated. API version is defined in code for each release. Managed by the system.")
    history: Optional[List[HistoryClass]] = Field(default=None, description="List of objects containing old and new values.")
    datasetlifecycle: LifecycleClass = Field(description="Describes the current status of the dataset during its lifetime with respect to the storage handling systems.")
    techniques: Optional[List[TechniqueClass]] = Field(default=None, description="Array of techniques information, with technique name and pid.")
    relationships: Optional[List[RelationshipClass]] = Field(default=None, description="Array of relationships with other datasets. It contains relationship type and destination dataset")
    shared_with: Optional[List[StrictStr]] = Field(default=None, description="List of additional users that the dataset has been shared with.", alias="sharedWith")
    scientific_metadata: Optional[Dict[str, Any]] = Field(default=None, description="JSON object containing the scientific metadata.", alias="scientificMetadata")
    comment: Optional[StrictStr] = Field(default=None, description="Short comment provided by the user about a given dataset. This is additional to the description field.")
    data_quality_metrics: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Data Quality Metrics given by the user to rate the dataset.", alias="dataQualityMetrics")
    principal_investigator: Optional[StrictStr] = Field(default=None, description="First name and last name of principal investigator(s). If multiple PIs are present, use a semicolon separated list. This field is required if the dataset is a Raw dataset.", alias="principalInvestigator")
    start_time: Optional[datetime] = Field(default=None, description="Start time of data acquisition for the current dataset.<br>It is expected to be in ISO8601 format according to specifications for internet date/time format in RFC 3339, chapter 5.6 (https://www.rfc-editor.org/rfc/rfc3339#section-5).<br>Local times without timezone/offset info are automatically transformed to UTC using the timezone of the API server.", alias="startTime")
    end_time: Optional[datetime] = Field(default=None, description="End time of data acquisition for the current dataset.<br>It is expected to be in ISO8601 format according to specifications for internet date/time format in RFC 3339, chapter 5.6 (https://www.rfc-editor.org/rfc/rfc3339#section-5).<br>Local times without timezone/offset info are automatically transformed to UTC using the timezone of the API server.", alias="endTime")
    creation_location: StrictStr = Field(description="Unique location identifier where data was acquired. Usually in the form /Site-name/facility-name/instrumentOrBeamline-name.", alias="creationLocation")
    data_format: Optional[StrictStr] = Field(default=None, description="Defines the format of the data files in this dataset, e.g Nexus Version x.y.", alias="dataFormat")
    run_number: Optional[StrictStr] = Field(default=None, description="Run number assigned by the system to the data acquisition for the current dataset.", alias="runNumber")
    proposal_ids: Optional[List[StrictStr]] = Field(default=None, description="The ID of the proposal to which the dataset belongs to and it has been acquired under.", alias="proposalIds")
    sample_ids: Optional[List[StrictStr]] = Field(default=None, description="Single ID or array of IDS of the samples used when collecting the data.", alias="sampleIds")
    instrument_ids: Optional[List[StrictStr]] = Field(default=None, description="Id of the instrument or array of IDS of the instruments where the data contained in this dataset was created/acquired.", alias="instrumentIds")
    input_datasets: Optional[List[StrictStr]] = Field(default=None, description="Array of input dataset identifiers used in producing the derived dataset. Ideally these are the global identifier to existing datasets inside this or federated data catalogs.", alias="inputDatasets")
    used_software: Optional[List[StrictStr]] = Field(default=None, description="A list of links to software repositories which uniquely identifies the pieces of software, including versions, used for yielding the derived data.", alias="usedSoftware")
    job_parameters: Optional[Dict[str, Any]] = Field(default=None, description="The creation process of the derived data will usually depend on input job parameters. The full structure of these input parameters are stored here.", alias="jobParameters")
    job_log_data: Optional[StrictStr] = Field(default=None, description="The output job logfile. Keep the size of this log data well below 15 MB.", alias="jobLogData")
    __properties: ClassVar[List[str]] = ["createdBy", "updatedBy", "createdAt", "updatedAt", "ownerGroup", "accessGroups", "instrumentGroup", "isPublished", "pid", "owner", "ownerEmail", "orcidOfOwner", "contactEmail", "sourceFolder", "sourceFolderHost", "size", "packedSize", "numberOfFiles", "numberOfFilesArchived", "creationTime", "type", "validationStatus", "keywords", "description", "datasetName", "classification", "license", "version", "history", "datasetlifecycle", "techniques", "relationships", "sharedWith", "scientificMetadata", "comment", "dataQualityMetrics", "principalInvestigator", "startTime", "endTime", "creationLocation", "dataFormat", "runNumber", "proposalIds", "sampleIds", "instrumentIds", "inputDatasets", "usedSoftware", "jobParameters", "jobLogData"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['raw', 'derived']):
            raise ValueError("must be one of enum values ('raw', 'derived')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetClass from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item_history in self.history:
                if _item_history:
                    _items.append(_item_history.to_dict())
            _dict['history'] = _items
        # override the default output from pydantic by calling `to_dict()` of datasetlifecycle
        if self.datasetlifecycle:
            _dict['datasetlifecycle'] = self.datasetlifecycle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in techniques (list)
        _items = []
        if self.techniques:
            for _item_techniques in self.techniques:
                if _item_techniques:
                    _items.append(_item_techniques.to_dict())
            _dict['techniques'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relationships (list)
        _items = []
        if self.relationships:
            for _item_relationships in self.relationships:
                if _item_relationships:
                    _items.append(_item_relationships.to_dict())
            _dict['relationships'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetClass from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdBy": obj.get("createdBy"),
            "updatedBy": obj.get("updatedBy"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "ownerGroup": obj.get("ownerGroup"),
            "accessGroups": obj.get("accessGroups"),
            "instrumentGroup": obj.get("instrumentGroup"),
            "isPublished": obj.get("isPublished") if obj.get("isPublished") is not None else False,
            "pid": obj.get("pid"),
            "owner": obj.get("owner"),
            "ownerEmail": obj.get("ownerEmail"),
            "orcidOfOwner": obj.get("orcidOfOwner"),
            "contactEmail": obj.get("contactEmail"),
            "sourceFolder": obj.get("sourceFolder"),
            "sourceFolderHost": obj.get("sourceFolderHost"),
            "size": obj.get("size") if obj.get("size") is not None else 0,
            "packedSize": obj.get("packedSize") if obj.get("packedSize") is not None else 0,
            "numberOfFiles": obj.get("numberOfFiles") if obj.get("numberOfFiles") is not None else 0,
            "numberOfFilesArchived": obj.get("numberOfFilesArchived") if obj.get("numberOfFilesArchived") is not None else 0,
            "creationTime": obj.get("creationTime"),
            "type": obj.get("type"),
            "validationStatus": obj.get("validationStatus"),
            "keywords": obj.get("keywords"),
            "description": obj.get("description"),
            "datasetName": obj.get("datasetName"),
            "classification": obj.get("classification"),
            "license": obj.get("license"),
            "version": obj.get("version"),
            "history": [HistoryClass.from_dict(_item) for _item in obj["history"]] if obj.get("history") is not None else None,
            "datasetlifecycle": LifecycleClass.from_dict(obj["datasetlifecycle"]) if obj.get("datasetlifecycle") is not None else None,
            "techniques": [TechniqueClass.from_dict(_item) for _item in obj["techniques"]] if obj.get("techniques") is not None else None,
            "relationships": [RelationshipClass.from_dict(_item) for _item in obj["relationships"]] if obj.get("relationships") is not None else None,
            "sharedWith": obj.get("sharedWith"),
            "scientificMetadata": obj.get("scientificMetadata"),
            "comment": obj.get("comment"),
            "dataQualityMetrics": obj.get("dataQualityMetrics"),
            "principalInvestigator": obj.get("principalInvestigator"),
            "startTime": obj.get("startTime"),
            "endTime": obj.get("endTime"),
            "creationLocation": obj.get("creationLocation"),
            "dataFormat": obj.get("dataFormat"),
            "runNumber": obj.get("runNumber"),
            "proposalIds": obj.get("proposalIds"),
            "sampleIds": obj.get("sampleIds"),
            "instrumentIds": obj.get("instrumentIds"),
            "inputDatasets": obj.get("inputDatasets"),
            "usedSoftware": obj.get("usedSoftware"),
            "jobParameters": obj.get("jobParameters"),
            "jobLogData": obj.get("jobLogData")
        })
        return _obj


