# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DataFile(BaseModel):
    """
    DataFile
    """ # noqa: E501
    path: StrictStr = Field(description="Relative path of the file within the dataset folder.")
    size: Union[StrictFloat, StrictInt] = Field(description="Uncompressed file size in bytes.")
    time: datetime = Field(description="Time of file creation on disk, format according to chapter 5.6 internet date/time format in RFC 3339. Local times without timezone/offset info are automatically transformed to UTC using the timezone of the API server.")
    chk: Optional[StrictStr] = Field(default=None, description="Checksum for the file, e.g. its sha-2 hashstring. The hash algorithm should be encoded in the (Orig)Datablock.")
    uid: Optional[StrictStr] = Field(default=None, description="User ID name as seen on filesystem.")
    gid: Optional[StrictStr] = Field(default=None, description="Group ID name as seen on filesystem.")
    perm: Optional[StrictStr] = Field(default=None, description="Posix permission bits.")
    __properties: ClassVar[List[str]] = ["path", "size", "time", "chk", "uid", "gid", "perm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "path": obj.get("path"),
            "size": obj.get("size"),
            "time": obj.get("time"),
            "chk": obj.get("chk"),
            "uid": obj.get("uid"),
            "gid": obj.get("gid"),
            "perm": obj.get("perm")
        })
        return _obj


