# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateSampleDto(BaseModel):
    """
    CreateSampleDto
    """ # noqa: E501
    owner_group: StrictStr = Field(description="Name of the group owning this item.", alias="ownerGroup")
    access_groups: Optional[List[StrictStr]] = Field(default=None, description="List of groups which have access to this item.", alias="accessGroups")
    instrument_group: Optional[StrictStr] = Field(default=None, description="Group of the instrument which this item was acquired on.", alias="instrumentGroup")
    owner: Optional[StrictStr] = Field(default=None, description="The owner of the sample.")
    description: Optional[StrictStr] = Field(default=None, description="A description of the sample.")
    sample_characteristics: Optional[Dict[str, Any]] = Field(default=None, description="JSON object containing the sample characteristics metadata.", alias="sampleCharacteristics")
    is_published: Optional[StrictBool] = Field(default=False, description="Flag is true when data are made publicly available.", alias="isPublished")
    sample_id: Optional[StrictStr] = Field(default=None, description="Globally unique identifier of a sample. This could be provided as an input value or generated by the system.", alias="sampleId")
    __properties: ClassVar[List[str]] = ["ownerGroup", "accessGroups", "instrumentGroup", "owner", "description", "sampleCharacteristics", "isPublished", "sampleId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSampleDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSampleDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ownerGroup": obj.get("ownerGroup"),
            "accessGroups": obj.get("accessGroups"),
            "instrumentGroup": obj.get("instrumentGroup"),
            "owner": obj.get("owner"),
            "description": obj.get("description"),
            "sampleCharacteristics": obj.get("sampleCharacteristics"),
            "isPublished": obj.get("isPublished") if obj.get("isPublished") is not None else False,
            "sampleId": obj.get("sampleId")
        })
        return _obj


