# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CreatePublishedDataDto(BaseModel):
    """
    CreatePublishedDataDto
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    doi: Optional[StrictStr] = None
    affiliation: Optional[StrictStr] = None
    creator: List[StrictStr]
    publisher: StrictStr
    publication_year: Union[StrictFloat, StrictInt] = Field(alias="publicationYear")
    title: StrictStr
    url: Optional[StrictStr] = None
    abstract: StrictStr
    data_description: StrictStr = Field(alias="dataDescription")
    resource_type: StrictStr = Field(alias="resourceType")
    number_of_files: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="numberOfFiles")
    size_of_archive: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="sizeOfArchive")
    pid_array: List[StrictStr] = Field(alias="pidArray")
    authors: Optional[List[StrictStr]] = None
    registered_time: Optional[datetime] = Field(default=None, alias="registeredTime")
    status: Optional[StrictStr] = None
    scicat_user: Optional[StrictStr] = Field(default=None, alias="scicatUser")
    thumbnail: Optional[StrictStr] = None
    related_publications: Optional[List[StrictStr]] = Field(default=None, alias="relatedPublications")
    download_link: Optional[StrictStr] = Field(default=None, alias="downloadLink")
    __properties: ClassVar[List[str]] = ["_id", "doi", "affiliation", "creator", "publisher", "publicationYear", "title", "url", "abstract", "dataDescription", "resourceType", "numberOfFiles", "sizeOfArchive", "pidArray", "authors", "registeredTime", "status", "scicatUser", "thumbnail", "relatedPublications", "downloadLink"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePublishedDataDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePublishedDataDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "doi": obj.get("doi"),
            "affiliation": obj.get("affiliation"),
            "creator": obj.get("creator"),
            "publisher": obj.get("publisher"),
            "publicationYear": obj.get("publicationYear"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "abstract": obj.get("abstract"),
            "dataDescription": obj.get("dataDescription"),
            "resourceType": obj.get("resourceType"),
            "numberOfFiles": obj.get("numberOfFiles"),
            "sizeOfArchive": obj.get("sizeOfArchive"),
            "pidArray": obj.get("pidArray"),
            "authors": obj.get("authors"),
            "registeredTime": obj.get("registeredTime"),
            "status": obj.get("status"),
            "scicatUser": obj.get("scicatUser"),
            "thumbnail": obj.get("thumbnail"),
            "relatedPublications": obj.get("relatedPublications"),
            "downloadLink": obj.get("downloadLink")
        })
        return _obj


