# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scicat_sdk_py.models.i_dataset_list import IDatasetList
from typing import Optional, Set
from typing_extensions import Self

class CreateJobDto(BaseModel):
    """
    CreateJobDto
    """ # noqa: E501
    email_job_initiator: StrictStr = Field(alias="emailJobInitiator")
    type: StrictStr
    job_params: Optional[Dict[str, Any]] = Field(default=None, alias="jobParams")
    dataset_list: List[IDatasetList] = Field(alias="datasetList")
    execution_time: Optional[datetime] = Field(default=None, alias="executionTime")
    job_status_message: Optional[StrictStr] = Field(default=None, alias="jobStatusMessage")
    job_result_object: Optional[Dict[str, Any]] = Field(default=None, alias="jobResultObject")
    __properties: ClassVar[List[str]] = ["emailJobInitiator", "type", "jobParams", "datasetList", "executionTime", "jobStatusMessage", "jobResultObject"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateJobDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dataset_list (list)
        _items = []
        if self.dataset_list:
            for _item_dataset_list in self.dataset_list:
                if _item_dataset_list:
                    _items.append(_item_dataset_list.to_dict())
            _dict['datasetList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateJobDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "emailJobInitiator": obj.get("emailJobInitiator"),
            "type": obj.get("type"),
            "jobParams": obj.get("jobParams"),
            "datasetList": [IDatasetList.from_dict(_item) for _item in obj["datasetList"]] if obj.get("datasetList") is not None else None,
            "executionTime": obj.get("executionTime"),
            "jobStatusMessage": obj.get("jobStatusMessage"),
            "jobResultObject": obj.get("jobResultObject")
        })
        return _obj


