# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from scicat_sdk_py.models.lifecycle_class import LifecycleClass
from scicat_sdk_py.models.relationship_class import RelationshipClass
from scicat_sdk_py.models.technique_class import TechniqueClass
from typing import Optional, Set
from typing_extensions import Self

class CreateDerivedDatasetObsoleteDto(BaseModel):
    """
    CreateDerivedDatasetObsoleteDto
    """ # noqa: E501
    owner_group: StrictStr = Field(description="Name of the group owning this item.", alias="ownerGroup")
    access_groups: Optional[List[StrictStr]] = Field(default=None, description="List of groups which have access to this item.", alias="accessGroups")
    instrument_group: Optional[StrictStr] = Field(default=None, description="Group of the instrument which this item was acquired on.", alias="instrumentGroup")
    owner: StrictStr = Field(description="Owner or custodian of the dataset, usually first name + last name. The string may contain a list of persons, which should then be separated by semicolons.")
    owner_email: Optional[StrictStr] = Field(default=None, description="Email of the owner or custodian of the dataset. The string may contain a list of emails, which should then be separated by semicolons.", alias="ownerEmail")
    orcid_of_owner: Optional[StrictStr] = Field(default=None, description="ORCID of the owner or custodian. The string may contain a list of ORCIDs, which should then be separated by semicolons.", alias="orcidOfOwner")
    contact_email: StrictStr = Field(description="Email of the contact person for this dataset. The string may contain a list of emails, which should then be separated by semicolons.", alias="contactEmail")
    source_folder: StrictStr = Field(description="Absolute file path on file server containing the files of this dataset, e.g. /some/path/to/sourcefolder. In case of a single file dataset, e.g. HDF5 data, it contains the path up to, but excluding the filename. Trailing slashes are removed.", alias="sourceFolder")
    source_folder_host: Optional[StrictStr] = Field(default=None, description="DNS host name of file server hosting sourceFolder, optionally including a protocol e.g. [protocol://]fileserver1.example.com", alias="sourceFolderHost")
    size: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Total size of all source files contained in source folder on disk when unpacked.")
    packed_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Total size of all datablock package files created for this dataset.", alias="packedSize")
    number_of_files: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Total number of files in all OrigDatablocks for this dataset.", alias="numberOfFiles")
    number_of_files_archived: Union[StrictFloat, StrictInt] = Field(description="Total number of files in all Datablocks for this dataset.", alias="numberOfFilesArchived")
    creation_time: datetime = Field(description="Time when dataset became fully available on disk, i.e. all containing files have been written,  or the dataset was created in SciCat.<br>It is expected to be in ISO8601 format according to specifications for internet date/time format in RFC 3339, chapter 5.6 (https://www.rfc-editor.org/rfc/rfc3339#section-5).<br>Local times without timezone/offset info are automatically transformed to UTC using the timezone of the API server.", alias="creationTime")
    validation_status: Optional[StrictStr] = Field(default=None, description="Defines a level of trust, e.g. a measure of how much data was verified or used by other persons.", alias="validationStatus")
    keywords: Optional[List[StrictStr]] = Field(default=None, description="Array of tags associated with the meaning or contents of this dataset. Values should ideally come from defined vocabularies, taxonomies, ontologies or knowledge graphs.")
    description: Optional[StrictStr] = Field(default=None, description="Free text explanation of contents of dataset.")
    dataset_name: Optional[StrictStr] = Field(default=None, description="A name for the dataset, given by the creator to carry some semantic meaning. Useful for display purposes e.g. instead of displaying the pid. Will be autofilled if missing using info from sourceFolder.", alias="datasetName")
    classification: Optional[StrictStr] = Field(default=None, description="ACIA information about AUthenticity,COnfidentiality,INtegrity and AVailability requirements of dataset. E.g. AV(ailabilty)=medium could trigger the creation of a two tape copies. Format 'AV=medium,CO=low'")
    license: Optional[StrictStr] = Field(default=None, description="Name of the license under which the data can be used.")
    is_published: Optional[StrictBool] = Field(default=False, description="Flag is true when data are made publicly available.", alias="isPublished")
    techniques: Optional[List[TechniqueClass]] = Field(default=None, description="Stores the metadata information for techniques.")
    shared_with: Optional[List[StrictStr]] = Field(default=None, description="List of users that the dataset has been shared with.", alias="sharedWith")
    relationships: Optional[List[RelationshipClass]] = Field(default=None, description="Stores the relationships with other datasets.")
    datasetlifecycle: Optional[LifecycleClass] = Field(default=None, description="Describes the current status of the dataset during its lifetime with respect to the storage handling systems.")
    scientific_metadata: Optional[Dict[str, Any]] = Field(default=None, description="JSON object containing the scientific metadata.", alias="scientificMetadata")
    comment: Optional[StrictStr] = Field(default=None, description="Comment the user has about a given dataset.")
    data_quality_metrics: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Data Quality Metrics is a number given by the user to rate the dataset.", alias="dataQualityMetrics")
    proposal_id: Optional[StrictStr] = Field(default=None, description="The ID of the proposal to which the dataset belongs.", alias="proposalId")
    run_number: Optional[StrictStr] = Field(default=None, description="Run number assigned by the system to the data acquisition for the current dataset.", alias="runNumber")
    investigator: StrictStr = Field(description="First name and last name of the person or people pursuing the data analysis. The string may contain a list of names, which should then be separated by semicolons.")
    input_datasets: List[StrictStr] = Field(description="Array of input dataset identifiers used in producing the derived dataset. Ideally these are the global identifier to existing datasets inside this or federated data catalogs.", alias="inputDatasets")
    used_software: List[StrictStr] = Field(description="A list of links to software repositories which uniquely identifies the pieces of software, including versions, used for yielding the derived data.", alias="usedSoftware")
    job_parameters: Optional[Dict[str, Any]] = Field(default=None, description="The creation process of the derived data will usually depend on input job parameters. The full structure of these input parameters are stored here.", alias="jobParameters")
    job_log_data: Optional[StrictStr] = Field(default=None, description="The output job logfile. Keep the size of this log data well below 15 MB.", alias="jobLogData")
    pid: Optional[StrictStr] = Field(default=None, description="Persistent identifier of the dataset.")
    version: Optional[StrictStr] = Field(default=None, description="Version of the API used in creation of the dataset.")
    type: StrictStr
    __properties: ClassVar[List[str]] = ["ownerGroup", "accessGroups", "instrumentGroup", "owner", "ownerEmail", "orcidOfOwner", "contactEmail", "sourceFolder", "sourceFolderHost", "size", "packedSize", "numberOfFiles", "numberOfFilesArchived", "creationTime", "validationStatus", "keywords", "description", "datasetName", "classification", "license", "isPublished", "techniques", "sharedWith", "relationships", "datasetlifecycle", "scientificMetadata", "comment", "dataQualityMetrics", "proposalId", "runNumber", "investigator", "inputDatasets", "usedSoftware", "jobParameters", "jobLogData", "pid", "version", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDerivedDatasetObsoleteDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in techniques (list)
        _items = []
        if self.techniques:
            for _item_techniques in self.techniques:
                if _item_techniques:
                    _items.append(_item_techniques.to_dict())
            _dict['techniques'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relationships (list)
        _items = []
        if self.relationships:
            for _item_relationships in self.relationships:
                if _item_relationships:
                    _items.append(_item_relationships.to_dict())
            _dict['relationships'] = _items
        # override the default output from pydantic by calling `to_dict()` of datasetlifecycle
        if self.datasetlifecycle:
            _dict['datasetlifecycle'] = self.datasetlifecycle.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDerivedDatasetObsoleteDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ownerGroup": obj.get("ownerGroup"),
            "accessGroups": obj.get("accessGroups"),
            "instrumentGroup": obj.get("instrumentGroup"),
            "owner": obj.get("owner"),
            "ownerEmail": obj.get("ownerEmail"),
            "orcidOfOwner": obj.get("orcidOfOwner"),
            "contactEmail": obj.get("contactEmail"),
            "sourceFolder": obj.get("sourceFolder"),
            "sourceFolderHost": obj.get("sourceFolderHost"),
            "size": obj.get("size") if obj.get("size") is not None else 0,
            "packedSize": obj.get("packedSize") if obj.get("packedSize") is not None else 0,
            "numberOfFiles": obj.get("numberOfFiles") if obj.get("numberOfFiles") is not None else 0,
            "numberOfFilesArchived": obj.get("numberOfFilesArchived") if obj.get("numberOfFilesArchived") is not None else 0,
            "creationTime": obj.get("creationTime"),
            "validationStatus": obj.get("validationStatus"),
            "keywords": obj.get("keywords"),
            "description": obj.get("description"),
            "datasetName": obj.get("datasetName"),
            "classification": obj.get("classification"),
            "license": obj.get("license"),
            "isPublished": obj.get("isPublished") if obj.get("isPublished") is not None else False,
            "techniques": [TechniqueClass.from_dict(_item) for _item in obj["techniques"]] if obj.get("techniques") is not None else None,
            "sharedWith": obj.get("sharedWith"),
            "relationships": [RelationshipClass.from_dict(_item) for _item in obj["relationships"]] if obj.get("relationships") is not None else None,
            "datasetlifecycle": LifecycleClass.from_dict(obj["datasetlifecycle"]) if obj.get("datasetlifecycle") is not None else None,
            "scientificMetadata": obj.get("scientificMetadata"),
            "comment": obj.get("comment"),
            "dataQualityMetrics": obj.get("dataQualityMetrics"),
            "proposalId": obj.get("proposalId"),
            "runNumber": obj.get("runNumber"),
            "investigator": obj.get("investigator"),
            "inputDatasets": obj.get("inputDatasets"),
            "usedSoftware": obj.get("usedSoftware"),
            "jobParameters": obj.get("jobParameters"),
            "jobLogData": obj.get("jobLogData"),
            "pid": obj.get("pid"),
            "version": obj.get("version"),
            "type": obj.get("type") if obj.get("type") is not None else 'derived'
        })
        return _obj


