# coding: utf-8

"""
    SciCat backend API

    This is the API for the SciCat Backend

    The version of the OpenAPI document: api/v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from scicat_sdk_py.models.data_file import DataFile
from typing import Optional, Set
from typing_extensions import Self

class CreateDatasetDatablockDto(BaseModel):
    """
    CreateDatasetDatablockDto
    """ # noqa: E501
    archive_id: StrictStr = Field(description="Unique identifier given by the archive system to the stored datablock. This id is used when data is retrieved back.", alias="archiveId")
    size: Union[StrictFloat, StrictInt] = Field(description="Total size in bytes of all files in the datablock when on accessible.")
    packed_size: Union[StrictFloat, StrictInt] = Field(description="Total size in bytes of all files in the datablock when on archived.", alias="packedSize")
    chk_alg: Optional[StrictStr] = Field(default=None, description="Name of the hashing algorithm used to compute the hash for each file.", alias="chkAlg")
    version: StrictStr = Field(description="Version string defining the format of how data is packed and stored in archive.")
    data_file_list: List[DataFile] = Field(alias="dataFileList")
    __properties: ClassVar[List[str]] = ["archiveId", "size", "packedSize", "chkAlg", "version", "dataFileList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDatasetDatablockDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in data_file_list (list)
        _items = []
        if self.data_file_list:
            for _item_data_file_list in self.data_file_list:
                if _item_data_file_list:
                    _items.append(_item_data_file_list.to_dict())
            _dict['dataFileList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDatasetDatablockDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "archiveId": obj.get("archiveId"),
            "size": obj.get("size"),
            "packedSize": obj.get("packedSize"),
            "chkAlg": obj.get("chkAlg"),
            "version": obj.get("version"),
            "dataFileList": [DataFile.from_dict(_item) for _item in obj["dataFileList"]] if obj.get("dataFileList") is not None else None
        })
        return _obj


