# scicat_sdk_py
This is the API for the SciCat Backend

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: api/v3
- Package version: 4.8.0
- Generator version: 7.11.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/SciCatProject/scicat-backend-next.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/SciCatProject/scicat-backend-next.git`)

Then import the package:
```python
import scicat_sdk_py
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import scicat_sdk_py
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import scicat_sdk_py
from scicat_sdk_py.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = scicat_sdk_py.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with scicat_sdk_py.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = scicat_sdk_py.AdminApi(api_client)

    try:
        api_response = api_instance.admin_controller_get_config()
        print("The response of AdminApi->admin_controller_get_config:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->admin_controller_get_config: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**admin_controller_get_config**](docs/AdminApi.md#admin_controller_get_config) | **GET** /api/v3/admin/config | 
*AdminApi* | [**admin_controller_get_theme**](docs/AdminApi.md#admin_controller_get_theme) | **GET** /api/v3/admin/theme | 
*AuthApi* | [**auth_controller_ldap_login**](docs/AuthApi.md#auth_controller_ldap_login) | **POST** /api/v3/auth/ldap | Endpoint to authenticate users through an ldap service.
*AuthApi* | [**auth_controller_login**](docs/AuthApi.md#auth_controller_login) | **POST** /api/v3/auth/login | 
*AuthApi* | [**auth_controller_login_callback**](docs/AuthApi.md#auth_controller_login_callback) | **GET** /api/v3/auth/oidc/callback | 
*AuthApi* | [**auth_controller_logout**](docs/AuthApi.md#auth_controller_logout) | **POST** /api/v3/auth/logout | It logs the current user out.
*AuthApi* | [**auth_controller_msad_login**](docs/AuthApi.md#auth_controller_msad_login) | **POST** /api/v3/auth/msad | Legacy endpoint to authenticate users through an ldap service.
*AuthApi* | [**auth_controller_oidc_login**](docs/AuthApi.md#auth_controller_oidc_login) | **GET** /api/v3/auth/oidc | 
*AuthApi* | [**auth_controller_whoami**](docs/AuthApi.md#auth_controller_whoami) | **GET** /api/v3/auth/whoami | 
*DatasetsApi* | [**datasets_controller_append_to_array_field**](docs/DatasetsApi.md#datasets_controller_append_to_array_field) | **POST** /api/v3/datasets/{pid}/appendToArrayField | It appends a new value to the specific field.
*DatasetsApi* | [**datasets_controller_count**](docs/DatasetsApi.md#datasets_controller_count) | **GET** /api/v3/datasets/count | It returns the number of datasets.
*DatasetsApi* | [**datasets_controller_create**](docs/DatasetsApi.md#datasets_controller_create) | **POST** /api/v3/datasets | It creates a new dataset which can be a raw or derived one.
*DatasetsApi* | [**datasets_controller_create_attachment**](docs/DatasetsApi.md#datasets_controller_create_attachment) | **POST** /api/v3/datasets/{pid}/attachments | It creates a new attachement for the dataset specified.
*DatasetsApi* | [**datasets_controller_create_datablock**](docs/DatasetsApi.md#datasets_controller_create_datablock) | **POST** /api/v3/datasets/{pid}/datablocks | It creates a new datablock for the dataset specified.
*DatasetsApi* | [**datasets_controller_create_orig_datablock**](docs/DatasetsApi.md#datasets_controller_create_orig_datablock) | **POST** /api/v3/datasets/{pid}/origdatablocks | It creates a new origDatablock for the dataset specified.
*DatasetsApi* | [**datasets_controller_find_all**](docs/DatasetsApi.md#datasets_controller_find_all) | **GET** /api/v3/datasets | It returns a list of datasets.
*DatasetsApi* | [**datasets_controller_find_all_attachments**](docs/DatasetsApi.md#datasets_controller_find_all_attachments) | **GET** /api/v3/datasets/{pid}/attachments | It returns all the attachments for the dataset specified.
*DatasetsApi* | [**datasets_controller_find_all_datablocks**](docs/DatasetsApi.md#datasets_controller_find_all_datablocks) | **GET** /api/v3/datasets/{pid}/datablocks | It returns all the datablock for the dataset specified.
*DatasetsApi* | [**datasets_controller_find_all_orig_datablocks**](docs/DatasetsApi.md#datasets_controller_find_all_orig_datablocks) | **GET** /api/v3/datasets/{pid}/origdatablocks | It returns all the origDatablock for the dataset specified.
*DatasetsApi* | [**datasets_controller_find_by_id**](docs/DatasetsApi.md#datasets_controller_find_by_id) | **GET** /api/v3/datasets/{pid} | 
*DatasetsApi* | [**datasets_controller_find_by_id_and_delete**](docs/DatasetsApi.md#datasets_controller_find_by_id_and_delete) | **DELETE** /api/v3/datasets/{pid} | It deletes the dataset.
*DatasetsApi* | [**datasets_controller_find_by_id_and_replace**](docs/DatasetsApi.md#datasets_controller_find_by_id_and_replace) | **PUT** /api/v3/datasets/{pid} | It updates the dataset.
*DatasetsApi* | [**datasets_controller_find_by_id_and_update**](docs/DatasetsApi.md#datasets_controller_find_by_id_and_update) | **PATCH** /api/v3/datasets/{pid} | It partially updates the dataset.
*DatasetsApi* | [**datasets_controller_find_logbook_by_pid**](docs/DatasetsApi.md#datasets_controller_find_logbook_by_pid) | **GET** /api/v3/datasets/{pid}/logbook | Retrive logbook associated with dataset.
*DatasetsApi* | [**datasets_controller_find_one**](docs/DatasetsApi.md#datasets_controller_find_one) | **GET** /api/v3/datasets/findOne | It returns the first dataset found.
*DatasetsApi* | [**datasets_controller_find_one_attachment_and_remove**](docs/DatasetsApi.md#datasets_controller_find_one_attachment_and_remove) | **DELETE** /api/v3/datasets/{pid}/attachments/{aid} | It deletes the attachment from the dataset.
*DatasetsApi* | [**datasets_controller_find_one_attachment_and_update**](docs/DatasetsApi.md#datasets_controller_find_one_attachment_and_update) | **PUT** /api/v3/datasets/{pid}/attachments/{aid} | It updates the attachment specified for the dataset indicated.
*DatasetsApi* | [**datasets_controller_find_one_datablock_and_remove**](docs/DatasetsApi.md#datasets_controller_find_one_datablock_and_remove) | **DELETE** /api/v3/datasets/{pid}/datablocks/{did} | It deletes the datablock from the dataset.
*DatasetsApi* | [**datasets_controller_find_one_datablock_and_update**](docs/DatasetsApi.md#datasets_controller_find_one_datablock_and_update) | **PATCH** /api/v3/datasets/{pid}/datablocks/{did} | It updates the datablocks specified for the dataset indicated.
*DatasetsApi* | [**datasets_controller_find_one_orig_datablock_and_remove**](docs/DatasetsApi.md#datasets_controller_find_one_orig_datablock_and_remove) | **DELETE** /api/v3/datasets/{pid}/origdatablocks/{oid} | It deletes the origdatablock from the dataset.
*DatasetsApi* | [**datasets_controller_find_one_orig_datablock_and_update**](docs/DatasetsApi.md#datasets_controller_find_one_orig_datablock_and_update) | **PATCH** /api/v3/datasets/{pid}/origdatablocks/{oid} | It updates the origDatablocks specified for the dataset indicated.
*DatasetsApi* | [**datasets_controller_fullfacet**](docs/DatasetsApi.md#datasets_controller_fullfacet) | **GET** /api/v3/datasets/fullfacet | 
*DatasetsApi* | [**datasets_controller_fullquery**](docs/DatasetsApi.md#datasets_controller_fullquery) | **GET** /api/v3/datasets/fullquery | It returns a list of datasets matching the query provided.
*DatasetsApi* | [**datasets_controller_is_valid**](docs/DatasetsApi.md#datasets_controller_is_valid) | **POST** /api/v3/datasets/isValid | It validates the dataset provided as input.
*DatasetsApi* | [**datasets_controller_metadata_keys**](docs/DatasetsApi.md#datasets_controller_metadata_keys) | **GET** /api/v3/datasets/metadataKeys | It returns a list of metadata keys contained in the datasets matching the filter provided.
*DatasetsApi* | [**datasets_controller_orig_datablock_is_valid**](docs/DatasetsApi.md#datasets_controller_orig_datablock_is_valid) | **POST** /api/v3/datasets/{pid}/origdatablocks/isValid | It validates the origDatablock values passed.
*DatasetsApi* | [**datasets_controller_thumbnail**](docs/DatasetsApi.md#datasets_controller_thumbnail) | **GET** /api/v3/datasets/{pid}/thumbnail | It returns the thumbnail associated with the dataset.
*DefaultApi* | [**health_controller_check**](docs/DefaultApi.md#health_controller_check) | **GET** /api/v3/health | 
*ElasticSearchApi* | [**elastic_search_service_controller_create_index**](docs/ElasticSearchApi.md#elastic_search_service_controller_create_index) | **POST** /api/v3/elastic-search/create-index | 
*ElasticSearchApi* | [**elastic_search_service_controller_delete_index**](docs/ElasticSearchApi.md#elastic_search_service_controller_delete_index) | **POST** /api/v3/elastic-search/delete-index | 
*ElasticSearchApi* | [**elastic_search_service_controller_fetch_es_results**](docs/ElasticSearchApi.md#elastic_search_service_controller_fetch_es_results) | **POST** /api/v3/elastic-search/search | 
*ElasticSearchApi* | [**elastic_search_service_controller_get_index**](docs/ElasticSearchApi.md#elastic_search_service_controller_get_index) | **GET** /api/v3/elastic-search/get-index | 
*ElasticSearchApi* | [**elastic_search_service_controller_sync_database**](docs/ElasticSearchApi.md#elastic_search_service_controller_sync_database) | **POST** /api/v3/elastic-search/sync-database | 
*ElasticSearchApi* | [**elastic_search_service_controller_update_index**](docs/ElasticSearchApi.md#elastic_search_service_controller_update_index) | **POST** /api/v3/elastic-search/update-index | 
*InstrumentsApi* | [**instruments_controller_create**](docs/InstrumentsApi.md#instruments_controller_create) | **POST** /api/v3/instruments | 
*InstrumentsApi* | [**instruments_controller_find_all**](docs/InstrumentsApi.md#instruments_controller_find_all) | **GET** /api/v3/instruments | 
*InstrumentsApi* | [**instruments_controller_find_by_id**](docs/InstrumentsApi.md#instruments_controller_find_by_id) | **GET** /api/v3/instruments/{id} | 
*InstrumentsApi* | [**instruments_controller_find_one**](docs/InstrumentsApi.md#instruments_controller_find_one) | **GET** /api/v3/instruments/findOne | It returns the first instrument found.
*InstrumentsApi* | [**instruments_controller_remove**](docs/InstrumentsApi.md#instruments_controller_remove) | **DELETE** /api/v3/instruments/{id} | 
*InstrumentsApi* | [**instruments_controller_update**](docs/InstrumentsApi.md#instruments_controller_update) | **PATCH** /api/v3/instruments/{id} | 
*JobsApi* | [**jobs_controller_create**](docs/JobsApi.md#jobs_controller_create) | **POST** /api/v3/jobs | 
*JobsApi* | [**jobs_controller_find_all**](docs/JobsApi.md#jobs_controller_find_all) | **GET** /api/v3/jobs | 
*JobsApi* | [**jobs_controller_find_one**](docs/JobsApi.md#jobs_controller_find_one) | **GET** /api/v3/jobs/{id} | 
*JobsApi* | [**jobs_controller_fullfacet**](docs/JobsApi.md#jobs_controller_fullfacet) | **GET** /api/v3/jobs/fullfacet | 
*JobsApi* | [**jobs_controller_fullquery**](docs/JobsApi.md#jobs_controller_fullquery) | **GET** /api/v3/jobs/fullquery | 
*JobsApi* | [**jobs_controller_remove**](docs/JobsApi.md#jobs_controller_remove) | **DELETE** /api/v3/jobs/{id} | 
*JobsApi* | [**jobs_controller_update**](docs/JobsApi.md#jobs_controller_update) | **PATCH** /api/v3/jobs/{id} | 
*LogbooksApi* | [**logbooks_controller_find_all**](docs/LogbooksApi.md#logbooks_controller_find_all) | **GET** /api/v3/logbooks | 
*LogbooksApi* | [**logbooks_controller_find_by_name**](docs/LogbooksApi.md#logbooks_controller_find_by_name) | **GET** /api/v3/logbooks/{name} | 
*OrigdatablocksApi* | [**orig_datablocks_controller_create**](docs/OrigdatablocksApi.md#orig_datablocks_controller_create) | **POST** /api/v3/origdatablocks | It creates a new orig datablock for the specified dataset.
*OrigdatablocksApi* | [**orig_datablocks_controller_find_all**](docs/OrigdatablocksApi.md#orig_datablocks_controller_find_all) | **GET** /api/v3/origdatablocks | It returns a list of orig datablocks.
*OrigdatablocksApi* | [**orig_datablocks_controller_find_by_id**](docs/OrigdatablocksApi.md#orig_datablocks_controller_find_by_id) | **GET** /api/v3/origdatablocks/{id} | It retrieve the origdatablock.
*OrigdatablocksApi* | [**orig_datablocks_controller_fullfacet**](docs/OrigdatablocksApi.md#orig_datablocks_controller_fullfacet) | **GET** /api/v3/origdatablocks/fullfacet | 
*OrigdatablocksApi* | [**orig_datablocks_controller_fullfacet_files**](docs/OrigdatablocksApi.md#orig_datablocks_controller_fullfacet_files) | **GET** /api/v3/origdatablocks/fullfacet/files | 
*OrigdatablocksApi* | [**orig_datablocks_controller_fullquery**](docs/OrigdatablocksApi.md#orig_datablocks_controller_fullquery) | **GET** /api/v3/origdatablocks/fullquery | 
*OrigdatablocksApi* | [**orig_datablocks_controller_fullquery_files**](docs/OrigdatablocksApi.md#orig_datablocks_controller_fullquery_files) | **GET** /api/v3/origdatablocks/fullquery/files | 
*OrigdatablocksApi* | [**orig_datablocks_controller_is_valid**](docs/OrigdatablocksApi.md#orig_datablocks_controller_is_valid) | **POST** /api/v3/origdatablocks/isValid | It validates the orig datablock provided as input.
*OrigdatablocksApi* | [**orig_datablocks_controller_remove**](docs/OrigdatablocksApi.md#orig_datablocks_controller_remove) | **DELETE** /api/v3/origdatablocks/{id} | It deletes the origdatablock.
*OrigdatablocksApi* | [**orig_datablocks_controller_update**](docs/OrigdatablocksApi.md#orig_datablocks_controller_update) | **PATCH** /api/v3/origdatablocks/{id} | It updates the origdatablock.
*PoliciesApi* | [**policies_controller_count**](docs/PoliciesApi.md#policies_controller_count) | **GET** /api/v3/policies/count | 
*PoliciesApi* | [**policies_controller_create**](docs/PoliciesApi.md#policies_controller_create) | **POST** /api/v3/policies | 
*PoliciesApi* | [**policies_controller_find_all**](docs/PoliciesApi.md#policies_controller_find_all) | **GET** /api/v3/policies | 
*PoliciesApi* | [**policies_controller_find_one**](docs/PoliciesApi.md#policies_controller_find_one) | **GET** /api/v3/policies/{id} | 
*PoliciesApi* | [**policies_controller_remove**](docs/PoliciesApi.md#policies_controller_remove) | **DELETE** /api/v3/policies/{id} | 
*PoliciesApi* | [**policies_controller_update**](docs/PoliciesApi.md#policies_controller_update) | **PATCH** /api/v3/policies/{id} | 
*PoliciesApi* | [**policies_controller_update_where**](docs/PoliciesApi.md#policies_controller_update_where) | **POST** /api/v3/policies/updateWhere | 
*ProposalsApi* | [**proposals_controller_create**](docs/ProposalsApi.md#proposals_controller_create) | **POST** /api/v3/proposals | It creates a new proposal.
*ProposalsApi* | [**proposals_controller_create_attachment**](docs/ProposalsApi.md#proposals_controller_create_attachment) | **POST** /api/v3/proposals/{pid}/attachments | It creates a new attachement for the proposal specified.
*ProposalsApi* | [**proposals_controller_find_all**](docs/ProposalsApi.md#proposals_controller_find_all) | **GET** /api/v3/proposals | It returns a list of proposals.
*ProposalsApi* | [**proposals_controller_find_all_attachments**](docs/ProposalsApi.md#proposals_controller_find_all_attachments) | **GET** /api/v3/proposals/{pid}/attachments | It returns all the attachments for the proposal specified.
*ProposalsApi* | [**proposals_controller_find_all_datasets**](docs/ProposalsApi.md#proposals_controller_find_all_datasets) | **GET** /api/v3/proposals/{pid}/datasets | It returns all the datasets associated with the proposal indicated.
*ProposalsApi* | [**proposals_controller_find_by_id**](docs/ProposalsApi.md#proposals_controller_find_by_id) | **GET** /api/v3/proposals/{pid} | It returns the proposal requested.
*ProposalsApi* | [**proposals_controller_find_by_id_access**](docs/ProposalsApi.md#proposals_controller_find_by_id_access) | **GET** /api/v3/proposals/{pid}/authorization | Check user access to a specific proposal.
*ProposalsApi* | [**proposals_controller_find_one_attachment_and_remove**](docs/ProposalsApi.md#proposals_controller_find_one_attachment_and_remove) | **DELETE** /api/v3/proposals/{pid}/attachments/{aid} | It deletes the attachment from the proposal.
*ProposalsApi* | [**proposals_controller_find_one_attachment_and_update**](docs/ProposalsApi.md#proposals_controller_find_one_attachment_and_update) | **PATCH** /api/v3/proposals/{pid}/attachments/{aid} | It updates the attachment specified for the proposal indicated.
*ProposalsApi* | [**proposals_controller_fullfacet**](docs/ProposalsApi.md#proposals_controller_fullfacet) | **GET** /api/v3/proposals/fullfacet | It returns a list of proposal facets matching the filter provided.
*ProposalsApi* | [**proposals_controller_fullquery**](docs/ProposalsApi.md#proposals_controller_fullquery) | **GET** /api/v3/proposals/fullquery | It returns a list of proposals matching the query provided.
*ProposalsApi* | [**proposals_controller_is_valid**](docs/ProposalsApi.md#proposals_controller_is_valid) | **POST** /api/v3/proposals/isValid | It validates the proposal provided as input.
*ProposalsApi* | [**proposals_controller_remove**](docs/ProposalsApi.md#proposals_controller_remove) | **DELETE** /api/v3/proposals/{pid} | It deletes the proposal.
*ProposalsApi* | [**proposals_controller_update**](docs/ProposalsApi.md#proposals_controller_update) | **PATCH** /api/v3/proposals/{pid} | It updates the proposal.
*PublishedDataApi* | [**published_data_controller_count**](docs/PublishedDataApi.md#published_data_controller_count) | **GET** /api/v3/publisheddata/count | 
*PublishedDataApi* | [**published_data_controller_create**](docs/PublishedDataApi.md#published_data_controller_create) | **POST** /api/v3/publisheddata | 
*PublishedDataApi* | [**published_data_controller_find_all**](docs/PublishedDataApi.md#published_data_controller_find_all) | **GET** /api/v3/publisheddata | 
*PublishedDataApi* | [**published_data_controller_find_one**](docs/PublishedDataApi.md#published_data_controller_find_one) | **GET** /api/v3/publisheddata/{id} | It returns the published data requested.
*PublishedDataApi* | [**published_data_controller_form_populate**](docs/PublishedDataApi.md#published_data_controller_form_populate) | **GET** /api/v3/publisheddata/formpopulate | 
*PublishedDataApi* | [**published_data_controller_register**](docs/PublishedDataApi.md#published_data_controller_register) | **POST** /api/v3/publisheddata/{id}/register | 
*PublishedDataApi* | [**published_data_controller_remove**](docs/PublishedDataApi.md#published_data_controller_remove) | **DELETE** /api/v3/publisheddata/{id} | 
*PublishedDataApi* | [**published_data_controller_resync**](docs/PublishedDataApi.md#published_data_controller_resync) | **POST** /api/v3/publisheddata/{id}/resync | Edits published data.
*PublishedDataApi* | [**published_data_controller_update**](docs/PublishedDataApi.md#published_data_controller_update) | **PATCH** /api/v3/publisheddata/{id} | 
*SamplesApi* | [**samples_controller_create**](docs/SamplesApi.md#samples_controller_create) | **POST** /api/v3/samples | It creates a new sample.
*SamplesApi* | [**samples_controller_create_attachments**](docs/SamplesApi.md#samples_controller_create_attachments) | **POST** /api/v3/samples/{id}/attachments | It creates a new attachment related with this sample.
*SamplesApi* | [**samples_controller_find_all**](docs/SamplesApi.md#samples_controller_find_all) | **GET** /api/v3/samples | It returns a list of samples
*SamplesApi* | [**samples_controller_find_all_attachments**](docs/SamplesApi.md#samples_controller_find_all_attachments) | **GET** /api/v3/samples/{id}/attachments | It returns the attachments related to a specific sample.
*SamplesApi* | [**samples_controller_find_all_datasets**](docs/SamplesApi.md#samples_controller_find_all_datasets) | **GET** /api/v3/samples/{id}/datasets | It returns the datasets related to a specific sample.
*SamplesApi* | [**samples_controller_find_by_id**](docs/SamplesApi.md#samples_controller_find_by_id) | **GET** /api/v3/samples/{id} | It returns the sample requested.
*SamplesApi* | [**samples_controller_find_by_id_access**](docs/SamplesApi.md#samples_controller_find_by_id_access) | **GET** /api/v3/samples/{id}/authorization | 
*SamplesApi* | [**samples_controller_find_one**](docs/SamplesApi.md#samples_controller_find_one) | **GET** /api/v3/samples/findOne | It returns a sample matching the query provided.
*SamplesApi* | [**samples_controller_find_one_attachment**](docs/SamplesApi.md#samples_controller_find_one_attachment) | **GET** /api/v3/samples/{id}/attachments/{fk} | It returns the attachment related to a specific sample.
*SamplesApi* | [**samples_controller_find_one_attachment_and_remove**](docs/SamplesApi.md#samples_controller_find_one_attachment_and_remove) | **DELETE** /api/v3/samples/{id}/attachments/{fk} | It deletes the attachment related to a specific sample.
*SamplesApi* | [**samples_controller_fullquery**](docs/SamplesApi.md#samples_controller_fullquery) | **GET** /api/v3/samples/fullquery | It returns a list of samples matching the query provided.
*SamplesApi* | [**samples_controller_metadata_keys**](docs/SamplesApi.md#samples_controller_metadata_keys) | **GET** /api/v3/samples/metadataKeys | It returns a list of sample metadata keys matching the query provided.
*SamplesApi* | [**samples_controller_remove**](docs/SamplesApi.md#samples_controller_remove) | **DELETE** /api/v3/samples/{id} | It deletes the sample.
*SamplesApi* | [**samples_controller_update**](docs/SamplesApi.md#samples_controller_update) | **PATCH** /api/v3/samples/{id} | It updates the sample.
*UserIdentitiesApi* | [**user_identities_controller_find_one**](docs/UserIdentitiesApi.md#user_identities_controller_find_one) | **GET** /api/v3/useridentities/findOne | 
*UserIdentitiesApi* | [**user_identities_controller_is_valid_email**](docs/UserIdentitiesApi.md#user_identities_controller_is_valid_email) | **GET** /api/v3/useridentities/isValidEmail | It returns true if the emailed passed in is linked to any registered users
*UsersApi* | [**users_controller_can_user_create_dataset**](docs/UsersApi.md#users_controller_can_user_create_dataset) | **GET** /api/v3/users/{id}/authorization/dataset/create | 
*UsersApi* | [**users_controller_create_custom_jwt**](docs/UsersApi.md#users_controller_create_custom_jwt) | **POST** /api/v3/users/{id}/jwt | It creates a new jwt token for the user specified.
*UsersApi* | [**users_controller_create_settings**](docs/UsersApi.md#users_controller_create_settings) | **POST** /api/v3/users/{id}/settings | 
*UsersApi* | [**users_controller_find_by_id**](docs/UsersApi.md#users_controller_find_by_id) | **GET** /api/v3/users/{id} | 
*UsersApi* | [**users_controller_get_my_settings**](docs/UsersApi.md#users_controller_get_my_settings) | **GET** /api/v3/users/my/settings | 
*UsersApi* | [**users_controller_get_my_user**](docs/UsersApi.md#users_controller_get_my_user) | **GET** /api/v3/users/my/self | Returns the information of the user currently logged in.
*UsersApi* | [**users_controller_get_my_user_identity**](docs/UsersApi.md#users_controller_get_my_user_identity) | **GET** /api/v3/users/my/identity | 
*UsersApi* | [**users_controller_get_settings**](docs/UsersApi.md#users_controller_get_settings) | **GET** /api/v3/users/{id}/settings | 
*UsersApi* | [**users_controller_get_user_identity**](docs/UsersApi.md#users_controller_get_user_identity) | **GET** /api/v3/users/{id}/userIdentity | 
*UsersApi* | [**users_controller_get_user_jwt**](docs/UsersApi.md#users_controller_get_user_jwt) | **POST** /api/v3/users/jwt | It creates a new jwt token.
*UsersApi* | [**users_controller_login**](docs/UsersApi.md#users_controller_login) | **POST** /api/v3/users/login | This endpoint is deprecated and will be removed soon. Use /auth/login instead
*UsersApi* | [**users_controller_logout**](docs/UsersApi.md#users_controller_logout) | **POST** /api/v3/users/logout | It logs the current user out.
*UsersApi* | [**users_controller_patch_external_settings**](docs/UsersApi.md#users_controller_patch_external_settings) | **PATCH** /api/v3/users/{id}/settings/external | 
*UsersApi* | [**users_controller_patch_settings**](docs/UsersApi.md#users_controller_patch_settings) | **PATCH** /api/v3/users/{id}/settings | 
*UsersApi* | [**users_controller_remove_settings**](docs/UsersApi.md#users_controller_remove_settings) | **DELETE** /api/v3/users/{id}/settings | 
*UsersApi* | [**users_controller_update_settings**](docs/UsersApi.md#users_controller_update_settings) | **PUT** /api/v3/users/{id}/settings | 


## Documentation For Models

 - [Attachment](docs/Attachment.md)
 - [CountApiResponse](docs/CountApiResponse.md)
 - [CreateAttachmentDto](docs/CreateAttachmentDto.md)
 - [CreateCustomJwt](docs/CreateCustomJwt.md)
 - [CreateDatasetDatablockDto](docs/CreateDatasetDatablockDto.md)
 - [CreateDatasetOrigDatablockDto](docs/CreateDatasetOrigDatablockDto.md)
 - [CreateDerivedDatasetObsoleteDto](docs/CreateDerivedDatasetObsoleteDto.md)
 - [CreateInstrumentDto](docs/CreateInstrumentDto.md)
 - [CreateJobDto](docs/CreateJobDto.md)
 - [CreateMeasurementPeriodDto](docs/CreateMeasurementPeriodDto.md)
 - [CreateOrigDatablockDto](docs/CreateOrigDatablockDto.md)
 - [CreatePolicyDto](docs/CreatePolicyDto.md)
 - [CreateProposalDto](docs/CreateProposalDto.md)
 - [CreatePublishedDataDto](docs/CreatePublishedDataDto.md)
 - [CreateRawDatasetObsoleteDto](docs/CreateRawDatasetObsoleteDto.md)
 - [CreateSampleDto](docs/CreateSampleDto.md)
 - [CreateSubAttachmentDto](docs/CreateSubAttachmentDto.md)
 - [CreateUserJWT](docs/CreateUserJWT.md)
 - [CreateUserSettingsDto](docs/CreateUserSettingsDto.md)
 - [CredentialsDto](docs/CredentialsDto.md)
 - [DataFile](docs/DataFile.md)
 - [Datablock](docs/Datablock.md)
 - [DatasetClass](docs/DatasetClass.md)
 - [DatasetsControllerCreateRequest](docs/DatasetsControllerCreateRequest.md)
 - [DatasetsControllerFindByIdAndReplaceRequest](docs/DatasetsControllerFindByIdAndReplaceRequest.md)
 - [DatasetsControllerFindByIdAndUpdateRequest](docs/DatasetsControllerFindByIdAndUpdateRequest.md)
 - [FindByIdAccessResponse](docs/FindByIdAccessResponse.md)
 - [FormPopulateData](docs/FormPopulateData.md)
 - [FullFacetResponse](docs/FullFacetResponse.md)
 - [HealthControllerCheck200Response](docs/HealthControllerCheck200Response.md)
 - [HealthControllerCheck200ResponseInfoValue](docs/HealthControllerCheck200ResponseInfoValue.md)
 - [HealthControllerCheck503Response](docs/HealthControllerCheck503Response.md)
 - [HistoryClass](docs/HistoryClass.md)
 - [ICount](docs/ICount.md)
 - [IDatasetList](docs/IDatasetList.md)
 - [Instrument](docs/Instrument.md)
 - [IsValidResponse](docs/IsValidResponse.md)
 - [JobClass](docs/JobClass.md)
 - [LifecycleClass](docs/LifecycleClass.md)
 - [Logbook](docs/Logbook.md)
 - [MeasurementPeriodClass](docs/MeasurementPeriodClass.md)
 - [OrigDatablock](docs/OrigDatablock.md)
 - [OutputDatasetObsoleteDto](docs/OutputDatasetObsoleteDto.md)
 - [PartialUpdateAttachmentDto](docs/PartialUpdateAttachmentDto.md)
 - [PartialUpdateDatablockDto](docs/PartialUpdateDatablockDto.md)
 - [PartialUpdateDerivedDatasetObsoleteDto](docs/PartialUpdateDerivedDatasetObsoleteDto.md)
 - [PartialUpdateInstrumentDto](docs/PartialUpdateInstrumentDto.md)
 - [PartialUpdateJobDto](docs/PartialUpdateJobDto.md)
 - [PartialUpdateOrigDatablockDto](docs/PartialUpdateOrigDatablockDto.md)
 - [PartialUpdatePolicyDto](docs/PartialUpdatePolicyDto.md)
 - [PartialUpdateProposalDto](docs/PartialUpdateProposalDto.md)
 - [PartialUpdatePublishedDataDto](docs/PartialUpdatePublishedDataDto.md)
 - [PartialUpdateRawDatasetObsoleteDto](docs/PartialUpdateRawDatasetObsoleteDto.md)
 - [PartialUpdateSampleDto](docs/PartialUpdateSampleDto.md)
 - [PartialUpdateUserSettingsDto](docs/PartialUpdateUserSettingsDto.md)
 - [Policy](docs/Policy.md)
 - [ProposalClass](docs/ProposalClass.md)
 - [PublishedData](docs/PublishedData.md)
 - [RelationshipClass](docs/RelationshipClass.md)
 - [ReturnedAuthLoginDto](docs/ReturnedAuthLoginDto.md)
 - [ReturnedUserDto](docs/ReturnedUserDto.md)
 - [SampleClass](docs/SampleClass.md)
 - [SampleWithAttachmentsAndDatasets](docs/SampleWithAttachmentsAndDatasets.md)
 - [SearchDto](docs/SearchDto.md)
 - [TechniqueClass](docs/TechniqueClass.md)
 - [TotalSets](docs/TotalSets.md)
 - [UpdateAttachmentDto](docs/UpdateAttachmentDto.md)
 - [UpdateDerivedDatasetObsoleteDto](docs/UpdateDerivedDatasetObsoleteDto.md)
 - [UpdateOrigDatablockDto](docs/UpdateOrigDatablockDto.md)
 - [UpdatePolicyDto](docs/UpdatePolicyDto.md)
 - [UpdatePublishedDataDto](docs/UpdatePublishedDataDto.md)
 - [UpdateRawDatasetObsoleteDto](docs/UpdateRawDatasetObsoleteDto.md)
 - [UpdateWherePolicyDto](docs/UpdateWherePolicyDto.md)
 - [UserIdentity](docs/UserIdentity.md)
 - [UserProfile](docs/UserProfile.md)
 - [UserSettings](docs/UserSettings.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer"></a>
### bearer

- **Type**: Bearer authentication (JWT)


## Author




