"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .models import MarkdownPostBody
from .types import MarkdownPostBodyType

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class MarkdownClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    @overload
    def render(self, *, data: MarkdownPostBodyType) -> "Response[str]":
        ...

    @overload
    def render(
        self,
        *,
        data: Unset = UNSET,
        text: str,
        mode: Union[Unset, Literal["markdown", "gfm"]] = "markdown",
        context: Union[Unset, str] = UNSET,
    ) -> "Response[str]":
        ...

    def render(
        self, *, data: Union[Unset, MarkdownPostBodyType] = UNSET, **kwargs
    ) -> "Response[str]":
        url = "/markdown"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(MarkdownPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=str,
        )

    @overload
    async def async_render(self, *, data: MarkdownPostBodyType) -> "Response[str]":
        ...

    @overload
    async def async_render(
        self,
        *,
        data: Unset = UNSET,
        text: str,
        mode: Union[Unset, Literal["markdown", "gfm"]] = "markdown",
        context: Union[Unset, str] = UNSET,
    ) -> "Response[str]":
        ...

    async def async_render(
        self, *, data: Union[Unset, MarkdownPostBodyType] = UNSET, **kwargs
    ) -> "Response[str]":
        url = "/markdown"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(MarkdownPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=str,
        )

    def render_raw(self, *, data: str, **kwargs) -> "Response[str]":
        url = "/markdown/raw"

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(str, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return self._github.request(
            "POST",
            url,
            content=exclude_unset(content),
            response_model=str,
        )

    async def async_render_raw(self, *, data: str, **kwargs) -> "Response[str]":
        url = "/markdown/raw"

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(str, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return await self._github.arequest(
            "POST",
            url,
            content=exclude_unset(content),
            response_model=str,
        )
