"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    SelectedActionsType,
    ScimV2EnterprisesEnterpriseUsersPostBodyType,
    ScimV2EnterprisesEnterpriseGroupsPostBodyType,
    EnterprisesEnterpriseActionsPermissionsPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType,
    ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType,
    ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType,
    EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
)
from .models import (
    Runner,
    BasicError,
    AuditLogEvent,
    SelectedActions,
    RunnerApplication,
    ScimEnterpriseUser,
    AuthenticationToken,
    ScimEnterpriseGroup,
    ValidationErrorSimple,
    RunnerGroupsEnterprise,
    ScimUserListEnterprise,
    ScimGroupListEnterprise,
    ActionsEnterprisePermissions,
    ScimV2EnterprisesEnterpriseUsersPostBody,
    ScimV2EnterprisesEnterpriseGroupsPostBody,
    EnterprisesEnterpriseActionsPermissionsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsPostBody,
    EnterprisesEnterpriseActionsRunnersGetResponse200,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody,
    EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
    EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
    EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class EnterpriseAdminClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsEnterprisePermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsEnterprisePermissions,
        )

    async def async_get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsEnterprisePermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsEnterprisePermissions,
        )

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    async def async_list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_allowed_actions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[SelectedActions]":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[SelectedActions]":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_enterprise(
        self, enterprise: str, *, data: SelectedActionsType
    ) -> "Response":
        ...

    @overload
    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_allowed_actions_enterprise(
        self, enterprise: str, *, data: SelectedActionsType
    ) -> "Response":
        ...

    @overload
    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_organization: Union[Unset, str] = UNSET,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_organization: Union[Unset, str] = UNSET,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        name: str,
        visibility: Union[Unset, Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsRunnerGroupsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        name: str,
        visibility: Union[Unset, Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsRunnerGroupsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    def get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "GET",
            url,
            response_model=RunnerGroupsEnterprise,
        )

    async def async_get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RunnerGroupsEnterprise,
        )

    def delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["selected", "all"]] = "all",
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["selected", "all"]] = "all",
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    def list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    async def async_list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        runners: List[int],
    ) -> "Response":
        ...

    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        runners: List[int],
    ) -> "Response":
        ...

    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_audit_log(
        self,
        enterprise: str,
        phrase: Union[Unset, str] = UNSET,
        include: Union[Unset, Literal["web", "git", "all"]] = UNSET,
        after: Union[Unset, str] = UNSET,
        before: Union[Unset, str] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = UNSET,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[AuditLogEvent]]":
        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[AuditLogEvent],
        )

    async def async_get_audit_log(
        self,
        enterprise: str,
        phrase: Union[Unset, str] = UNSET,
        include: Union[Unset, Literal["web", "git", "all"]] = UNSET,
        after: Union[Unset, str] = UNSET,
        before: Union[Unset, str] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = UNSET,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[AuditLogEvent]]":
        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[AuditLogEvent],
        )

    def list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimGroupListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimGroupListEnterprise,
        )

    async def async_list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimGroupListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimGroupListEnterprise,
        )

    @overload
    def provision_and_invite_enterprise_group(
        self, enterprise: str, *, data: ScimV2EnterprisesEnterpriseGroupsPostBodyType
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    @overload
    def provision_and_invite_enterprise_group(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset, List[ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    def provision_and_invite_enterprise_group(
        self,
        enterprise: str,
        *,
        data: Union[Unset, ScimV2EnterprisesEnterpriseGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseGroupsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    @overload
    async def async_provision_and_invite_enterprise_group(
        self, enterprise: str, *, data: ScimV2EnterprisesEnterpriseGroupsPostBodyType
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    @overload
    async def async_provision_and_invite_enterprise_group(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset, List[ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    async def async_provision_and_invite_enterprise_group(
        self,
        enterprise: str,
        *,
        data: Union[Unset, ScimV2EnterprisesEnterpriseGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseGroupsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    def get_provisioning_information_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimEnterpriseGroup,
        )

    async def async_get_provisioning_information_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimEnterpriseGroup,
        )

    @overload
    def set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    @overload
    def set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset,
            List[
                ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType
            ],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    def set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    @overload
    async def async_set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    @overload
    async def async_set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset,
            List[
                ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType
            ],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    async def async_set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    def delete_scim_group_from_enterprise(
        self,
        enterprise: str,
        scim_group_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_scim_group_from_enterprise(
        self,
        enterprise: str,
        scim_group_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    @overload
    def update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    def update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    @overload
    async def async_update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType,
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    @overload
    async def async_update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseGroup]":
        ...

    async def async_update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    def list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
    ) -> "Response[ScimUserListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimUserListEnterprise,
        )

    async def async_list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
    ) -> "Response[ScimUserListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimUserListEnterprise,
        )

    @overload
    def provision_and_invite_enterprise_user(
        self, enterprise: str, *, data: ScimV2EnterprisesEnterpriseUsersPostBodyType
    ) -> "Response[ScimEnterpriseUser]":
        ...

    @overload
    def provision_and_invite_enterprise_user(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType,
        emails: List[ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType],
        groups: Union[
            Unset, List[ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    def provision_and_invite_enterprise_user(
        self,
        enterprise: str,
        *,
        data: Union[Unset, ScimV2EnterprisesEnterpriseUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseUsersPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    @overload
    async def async_provision_and_invite_enterprise_user(
        self, enterprise: str, *, data: ScimV2EnterprisesEnterpriseUsersPostBodyType
    ) -> "Response[ScimEnterpriseUser]":
        ...

    @overload
    async def async_provision_and_invite_enterprise_user(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType,
        emails: List[ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType],
        groups: Union[
            Unset, List[ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    async def async_provision_and_invite_enterprise_user(
        self,
        enterprise: str,
        *,
        data: Union[Unset, ScimV2EnterprisesEnterpriseUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseUsersPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    def get_provisioning_information_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ScimEnterpriseUser,
        )

    async def async_get_provisioning_information_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ScimEnterpriseUser,
        )

    @overload
    def set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    @overload
    def set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType,
        emails: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType
        ],
        groups: Union[
            Unset,
            List[ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    def set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    @overload
    async def async_set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    @overload
    async def async_set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType,
        emails: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType
        ],
        groups: Union[
            Unset,
            List[ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    async def async_set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    def delete_user_from_enterprise(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_user_from_enterprise(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    @overload
    def update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseUser]":
        ...

    def update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    @overload
    async def async_update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType,
    ) -> "Response[ScimEnterpriseUser]":
        ...

    @overload
    async def async_update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Unset = UNSET,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseUser]":
        ...

    async def async_update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        data: Union[
            Unset, ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )
