"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const stepfunctions = require("../lib");
describe('Condition Variables', () => {
    test('Condition variables must start with $. or $[', () => {
        expect(() => stepfunctions.Condition.stringEquals('a', 'b')).toThrow();
    }),
        test('Condition variables can start with $.', () => {
            expect(() => stepfunctions.Condition.stringEquals('$.a', 'b')).not.toThrow();
        }),
        test('Condition variables can start with $[', () => {
            expect(() => stepfunctions.Condition.stringEquals('$[0]', 'a')).not.toThrow();
        }),
        test('Condition variables can reference the state input $', () => {
            expect(() => stepfunctions.Condition.stringEquals('$', 'a')).not.toThrow();
        }),
        test('NotConditon must render properly', () => {
            assertRendersTo(stepfunctions.Condition.not(stepfunctions.Condition.stringEquals('$.a', 'b')), { Not: { Variable: '$.a', StringEquals: 'b' } });
        }),
        test('CompoundCondition must render properly', () => {
            assertRendersTo(stepfunctions.Condition.and(stepfunctions.Condition.booleanEquals('$.a', true), stepfunctions.Condition.numberGreaterThan('$.b', 3)), {
                And: [
                    { Variable: '$.a', BooleanEquals: true },
                    { Variable: '$.b', NumericGreaterThan: 3 },
                ],
            });
        }),
        test('Exercise a number of other conditions', () => {
            const cases = [
                [stepfunctions.Condition.stringLessThan('$.a', 'foo'), { Variable: '$.a', StringLessThan: 'foo' }],
                [stepfunctions.Condition.stringLessThanEquals('$.a', 'foo'), { Variable: '$.a', StringLessThanEquals: 'foo' }],
                [stepfunctions.Condition.stringGreaterThan('$.a', 'foo'), { Variable: '$.a', StringGreaterThan: 'foo' }],
                [stepfunctions.Condition.stringGreaterThanEquals('$.a', 'foo'), { Variable: '$.a', StringGreaterThanEquals: 'foo' }],
                [stepfunctions.Condition.numberEquals('$.a', 5), { Variable: '$.a', NumericEquals: 5 }],
            ];
            for (const [cond, expected] of cases) {
                assertRendersTo(cond, expected);
            }
        });
});
function assertRendersTo(cond, expected) {
    expect(cond.renderCondition()).toStrictEqual(expected);
}
//# sourceMappingURL=data:application/json;base64,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