# Generated by Django 2.2.14 on 2020-07-30 23:00

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        ('arvestust', '0008_auto_20200730_1516'),
    ]

    operations = [
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=250, unique=True, verbose_name='slug')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('activity_type', models.CharField(choices=[('BOOKMARK', 'Bookmark'), ('FAVORITE', 'Favorite'), ('FOLLOW', 'Follow'), ('LIKE', 'Like'), ('REPORT', 'Report'), ('DOWN_VOTE', 'Down Vote'), ('UP_VOTE', 'Up Vote')], max_length=15)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='activity', to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'db_table': 'arvestust_activities',
                'unique_together': {('object_id', 'user', 'content_type')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='like',
            unique_together=None,
        ),
        migrations.RemoveField(
            model_name='like',
            name='content_type',
        ),
        migrations.RemoveField(
            model_name='like',
            name='user',
        ),
        migrations.AlterUniqueTogether(
            name='save',
            unique_together=None,
        ),
        migrations.RemoveField(
            model_name='save',
            name='content_type',
        ),
        migrations.RemoveField(
            model_name='save',
            name='user',
        ),
        migrations.RemoveField(
            model_name='comment',
            name='reports',
        ),
        migrations.DeleteModel(
            name='Follow',
        ),
        migrations.DeleteModel(
            name='Like',
        ),
        migrations.DeleteModel(
            name='Save',
        ),
    ]
