# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ciscoconfparse']

package_data = \
{'': ['*']}

install_requires = \
['dnspython>=2.1.0,<3.0.0',
 'loguru==0.5.3',
 'passlib>=1.7.4,<2.0.0',
 'toml==0.10.2']

setup_kwargs = {
    'name': 'ciscoconfparse',
    'version': '1.6.30',
    'description': 'Parse, Audit, Query, Build, and Modify Cisco IOS-style and JunOS-style configurations',
    'long_description': '==============\nciscoconfparse\n==============\n\n.. image:: https://github.com/mpenning/ciscoconfparse/actions/workflows/tests.yml/badge.svg\n   :target: https://github.com/mpenning/ciscoconfparse/actions/workflows/tests.yml\n   :alt: Github unittest workflow\n\n.. image:: https://img.shields.io/pypi/v/ciscoconfparse.svg\n   :target: https://pypi.python.org/pypi/ciscoconfparse/\n   :alt: Version\n\n.. image:: https://pepy.tech/badge/ciscoconfparse\n   :target: https://pepy.tech/project/ciscoconfparse\n   :alt: Downloads\n\n.. image:: http://img.shields.io/badge/license-GPLv3-blue.svg\n   :target: https://www.gnu.org/copyleft/gpl.html\n   :alt: License\n\n.. contents::\n\n.. _introduction:\n\nIntroduction: What is ciscoconfparse?\n=====================================\n\nShort answer: ciscoconfparse is a Python_ library that helps you quickly answer questions like these about your configurations:\n\n- What interfaces are shutdown?\n- Which interfaces are in trunk mode?\n- What address and subnet mask is assigned to each interface?\n- Which interfaces are missing a critical command?\n- Is this configuration missing a standard config line?\n\nIt can help you:\n\n- Audit existing router / switch / firewall / wlc configurations\n- Modify existing configurations\n- Build new configurations\n\nSpeaking generally, the library examines an IOS-style config and breaks it\ninto a set of linked parent / child relationships.  You can perform complex\nqueries about these relationships.\n\n.. image:: https://raw.githubusercontent.com/mpenning/ciscoconfparse/master/sphinx-doc/_static/ciscoconfparse_overview_75pct.png\n   :target: https://raw.githubusercontent.com/mpenning/ciscoconfparse/master/sphinx-doc/_static/ciscoconfparse_overview_75pct.png\n   :alt: CiscoConfParse Parent / Child relationships\n\nUsage\n=====\n\nThe following code will parse a configuration stored in \'exampleswitch.conf\'\nand select interfaces that are shutdown.\n\n.. code:: python\n\n    from ciscoconfparse import CiscoConfParse\n\n    parse = CiscoConfParse(\'exampleswitch.conf\', syntax=\'ios\')\n\n    for intf_obj in parse.find_objects_w_child(\'^interface\', \'^\\s+shutdown\'):\n        print("Shutdown: " + intf_obj.text)\n\n\nThe next example will find the IP address assigned to interfaces.\n\n.. code:: python\n\n    from ciscoconfparse import CiscoConfParse\n\n    parse = CiscoConfParse(\'exampleswitch.conf\', syntax=\'ios\')\n\n    for intf_obj in parse.find_objects(\'^interface\'):\n\n        intf_name = intf_obj.re_match_typed(\'^interface\\s+(\\S.+?)$\')\n\n        # Search children of all interfaces for a regex match and return\n        # the value matched in regex match group 1.  If there is no match,\n        # return a default value: \'\'\n        intf_ip_addr = intf_obj.re_match_iter_typed(\n            r\'ip\\saddress\\s(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s\', result_type=str,\n            group=1, default=\'\')\n        print("{0}: {1}".format(intf_name, intf_ip_addr))\n\nWhat if we don\'t use Cisco?\n===========================\n\nDon\'t let that stop you.\n\nAs of CiscoConfParse 1.2.4, you can parse `brace-delimited configurations`_\ninto a Cisco IOS style (see `Github Issue #17`_), which means that\nCiscoConfParse can parse these configurations:\n\n- Juniper Networks Junos\n- Palo Alto Networks Firewall configurations\n- F5 Networks configurations\n\nCiscoConfParse also handles anything that has a Cisco IOS style of configuration, which includes:\n\n- Cisco IOS, Cisco Nexus, Cisco IOS-XR, Cisco IOS-XE, Aironet OS, Cisco ASA, Cisco CatOS\n- Arista EOS\n- Brocade\n- HP Switches\n- Force 10 Switches\n- Dell PowerConnect Switches\n- Extreme Networks\n- Enterasys\n- Screenos\n\nDocs\n====\n\n- The latest copy of the docs are `archived on the web <http://www.pennington.net/py/ciscoconfparse/>`_\n- There is also a `CiscoConfParse Tutorial <http://pennington.net/tutorial/ciscoconfparse/ccp_tutorial.html>`_\n\nBuilding the Package\n====================\n\n- ``cd`` into the root ciscoconfparse directory\n- Edit the version number in `pyproject.toml` (as required)\n- ``git commit`` all pending changes\n- ``make test``\n- ``make repo-push``\n- ``make pypi``\n\n.. _Pre-Requisites:\n\nPre-requisites\n==============\n\nciscoconfparse_ requires Python versions 3.5+ (note: version 3.7.0 has\na bug - ref Github issue #117, but version 3.7.1 works); the OS should not\nmatter.\n\n.. _Installation:\n\nInstallation and Downloads\n==========================\n\n- Use ``poetry`` for Python3.x...\n  ::\n\n      python -m pip install ciscoconfparse\n\n\nIf you\'re interested in the source, you can always pull from the `github repo`_:\n\n- From github_ source download:\n  ::\n\n      git clone git://github.com/mpenning/ciscoconfparse\n      cd ciscoconfparse/\n      python -m pip install .\n\n\n.. _`Other-Resources`:\n\nOther Resources\n===============\n\n- `Dive into Python3`_ is a good way to learn Python\n- `Team CYMRU`_ has a `Secure IOS Template`_, which is especially useful for external-facing routers / switches\n- `Cisco\'s Guide to hardening IOS devices`_\n- `Center for Internet Security Benchmarks`_ (An email address, cookies, and javascript are required)\n\n.. _`Bug-Tracker-and-Support`:\n\nBug Tracker and Support\n=======================\n\n- Please report any suggestions, bug reports, or annoyances with ciscoconfparse_ through the `github bug tracker`_.\n- If you\'re having problems with general python issues, consider searching for a solution on `Stack Overflow`_.  If you can\'t find a solution for your problem or need more help, you can `ask a question`_.\n- If you\'re having problems with your Cisco devices, you can open a case with `Cisco TAC`_; if you prefer crowd-sourcing, you can ask on the Stack Exchange `Network Engineering`_ site.\n\n.. _Unit-Tests:\n\nUnit-Tests\n==========\n\n`Github workflow <https://github.com/mpenning/ciscoconfparse/tree/master/.github/workflows>`_ tests ciscoconfparse on Python versions 3.6 and higher, as well as a `pypy JIT`_ executable.\n\nClick the image below for details; the current build status is:\n\n.. image:: https://github.com/mpenning/ciscoconfparse/actions/workflows/tests.yml/badge.svg\n   :target: https://github.com/mpenning/ciscoconfparse/actions/workflows/tests.yml\n   :alt: Github unittest workflow\n\n.. _`License and Copyright`:\n\nLicense and Copyright\n=====================\n\nciscoconfparse_ is licensed GPLv3_\n\n- Copyright (C) 2021      David Michael Pennington\n- Copyright (C) 2020-2021 David Michael Pennington at Cisco Systems\n- Copyright (C) 2019      David Michael Pennington at ThousandEyes\n- Copyright (C) 2012-2019 David Michael Pennington at Samsung Data Services\n- Copyright (C) 2011-2012 David Michael Pennington at Dell Computer Corp\n- Copyright (C) 2007-2011 David Michael Pennington\n\nThe word "Cisco" is a registered trademark of Cisco Systems\n\n.. _Author:\n\nAuthor and Thanks\n=================\n\nciscoconfparse_ was written by David Michael Pennington (mike [~at~]\npennington [/dot\\] net).\n\nSpecial thanks:\n\n- Thanks to David Muir Sharnoff for his suggestion about making a special case for IOS banners.\n- Thanks to Alan Cownie for his API suggestions.\n- Thanks to CrackerJackMack_ for reporting `Github Issue #13`_\n- Soli Deo Gloria\n\n\n.. _ciscoconfparse: https://pypi.python.org/pypi/ciscoconfparse\n\n.. _Python: http://python.org/\n\n.. _`pypy JIT`: http://pypy.org/\n\n.. _`Github Issue #13`: https://github.com/mpenning/ciscoconfparse/issues/13\n\n.. _`Github Issue #14`: https://github.com/mpenning/ciscoconfparse/issues/14\n\n.. _`Github Issue #17`: https://github.com/mpenning/ciscoconfparse/issues/17\n\n.. _`brace-delimited configurations`: https://github.com/mpenning/ciscoconfparse/blob/master/configs/sample_01.junos\n\n.. _CrackerJackMack: https://github.com/CrackerJackMack\n\n.. _`David Michael Pennington`: http://pennington.net/\n\n.. _pip: https://pypi.python.org/pypi/pip\n\n.. _virtualenv: https://pypi.python.org/pypi/virtualenv\n\n.. _`github repo`: https://github.com/mpenning/ciscoconfparse\n\n.. _github: https://github.com/mpenning/ciscoconfparse\n\n.. _`github bug tracker`: https://github.com/mpenning/ciscoconfparse/issues\n\n.. _`regular expressions`: http://docs.python.org/2/howto/regex.html\n\n.. _`docs`: http://www.pennington.net/py/ciscoconfparse/\n\n.. _`ipaddr`: https://code.google.com/p/ipaddr-py/\n\n.. _`GPLv3`: http://www.gnu.org/licenses/gpl-3.0.html\n\n.. _`ASF License 2.0`: http://www.apache.org/licenses/LICENSE-2.0\n\n.. _`Dive into Python3`: http://www.diveintopython3.net/\n\n.. _`Network Engineering`: http://networkengineering.stackexchange.com/\n\n.. _`Stack Overflow`: http://stackoverflow.com/\n\n.. _`ask a question`: http://stackoverflow.com/questions/ask\n\n.. _`ciscoconfparse NetworkToCode slack channel`: https://app.slack.com/client/T09LQ7E9E/C015B4U8MMF/\n\n.. _`Secure IOS Template`: https://www.cymru.com/Documents/secure-ios-template.html\n\n.. _`Center for Internet Security Benchmarks`: https://learn.cisecurity.org/benchmarks\n\n.. _`Team CYMRU`: http://www.team-cymru.org/\n\n.. _`Cisco TAC`: http://cisco.com/go/support\n\n.. _`Juniper networks`: http://www.juniper.net/\n\n.. _`Cisco\'s Guide to hardening IOS devices`: http://www.cisco.com/c/en/us/support/docs/ip/access-lists/13608-21.html\n',
    'author': 'Mike Pennington',
    'author_email': 'mike@pennington.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mpenning/ciscoconfparse',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
