"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosStackArtifact = void 0;
const cxschema = require("@alicloud/ros-cdk-assembly-schema");
const fs = require("fs");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
class RosStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        const properties = (this.manifest.properties ||
            {});
        if (!properties.templateFile) {
            throw new Error('Invalid ROS stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters || {};
        this.stackName = properties.stackName || artifactId;
        this.displayName =
            this.stackName === artifactId
                ? this.stackName
                : `${artifactId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
        this.tags = properties.tags ?? this.tagsFromMetadata();
    }
    /**
     * The ROS template for this stack.
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(path.join(this.assembly.directory, this.templateFile), "utf-8"));
        }
        return this._template;
    }
    tagsFromMetadata() {
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of (metadataEntry.data ?? [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.RosStackArtifact = RosStackArtifact;
//# sourceMappingURL=data:application/json;base64,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