# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudmersive_convert_api_client.models.pdf_metadata import PdfMetadata  # noqa: F401,E501


class SetPdfMetadataRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'input_file_bytes': 'str',
        'metadata_to_set': 'PdfMetadata'
    }

    attribute_map = {
        'input_file_bytes': 'InputFileBytes',
        'metadata_to_set': 'MetadataToSet'
    }

    def __init__(self, input_file_bytes=None, metadata_to_set=None):  # noqa: E501
        """SetPdfMetadataRequest - a model defined in Swagger"""  # noqa: E501

        self._input_file_bytes = None
        self._metadata_to_set = None
        self.discriminator = None

        if input_file_bytes is not None:
            self.input_file_bytes = input_file_bytes
        if metadata_to_set is not None:
            self.metadata_to_set = metadata_to_set

    @property
    def input_file_bytes(self):
        """Gets the input_file_bytes of this SetPdfMetadataRequest.  # noqa: E501

        Input file contents bytes for the file to modify  # noqa: E501

        :return: The input_file_bytes of this SetPdfMetadataRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_bytes

    @input_file_bytes.setter
    def input_file_bytes(self, input_file_bytes):
        """Sets the input_file_bytes of this SetPdfMetadataRequest.

        Input file contents bytes for the file to modify  # noqa: E501

        :param input_file_bytes: The input_file_bytes of this SetPdfMetadataRequest.  # noqa: E501
        :type: str
        """
        if input_file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', input_file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `input_file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._input_file_bytes = input_file_bytes

    @property
    def metadata_to_set(self):
        """Gets the metadata_to_set of this SetPdfMetadataRequest.  # noqa: E501

        PDF metadata to set on the file  # noqa: E501

        :return: The metadata_to_set of this SetPdfMetadataRequest.  # noqa: E501
        :rtype: PdfMetadata
        """
        return self._metadata_to_set

    @metadata_to_set.setter
    def metadata_to_set(self, metadata_to_set):
        """Sets the metadata_to_set of this SetPdfMetadataRequest.

        PDF metadata to set on the file  # noqa: E501

        :param metadata_to_set: The metadata_to_set of this SetPdfMetadataRequest.  # noqa: E501
        :type: PdfMetadata
        """

        self._metadata_to_set = metadata_to_set

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SetPdfMetadataRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SetPdfMetadataRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
