# TP Importer

This package is used for importing our main Titelplanung Excel file;
<br>
as this data is used in different systems this package provides adapters to use the imported data within different products
<br>
## Usage
Usage Example (Transaktional - Feature):
```
def import_tp_data_for_mam():
    """
    importiert TP-Daten mit den fürs MAM genutzten Keys
    """
    tp_path = "G:\Listen\TPDD aktuell absolutiert.xlsm"
    tp_data = TP_Importer().get_tp_data_from_file(tp_path)
    tp_data_mam = Adapter_For_MAM().transform(tp_data)
    for title in tp_data_mam:
        # do something with title


if __name__ == '__main__':
    tp_data_mam = import_tp_data_for_mam()
```

Usage Example for Channels (Feature):
```
channel_tp_data_feature = dict()
importer = TP_Importer_Channels(
        valid_statuses=(("ok", "change", "new"))
    )
wb = importer._load_workbook(
    path='G:\Listen\Titelplanung Channels aktuell_absolutiert_new.xlsm'
)
for worksheet_name, channel_type in {
    'Planung ACNMA': 'arthousecnma',
    'Planung HOH': 'homeofhorror',
    'Planung Filmtastic': 'filmtastic',
    'Planung Cinehearts': 'cinehearts',
    'Planung Filmlegenden': 'filmlegenden',
}.items():
    tp_data = importer._get_data_from_wb(
        workbook=wb,
        first_row=4,
        worksheet_name=worksheet_name,
        channel_type=channel_type
    )
    channel_tp_data_feature[channel_type] = tp_data
    

for channel_type, channel_titles in tp_data.items():
    # durch alle Channels iterieren
    for title in tqdm(channel_titles):
        # durch Titel in jeweiligem Channel iterieren
```

Usage Example for TVTP Transaktional:

```
def _get_data(self) -> dict:
    """
    diese Methode liest die Daten aus der TV Titelplanung ein
    :return: Dict (one entry per series with the series-Basis-VendorID as key) - die Daten zu den Staffeln
        kann man als Liste von Dicts unter dem Key "seasons" aufrufen
        (auch wieder als Dict mit Key = Season-Basis-VID),
        die zu den Episoden sind im Staffel-Dict als Liste von Dicts unter dem Key "episodes" zu finden
        (auch wieder als Dict mit Key = Episode-Basis-VID)
    """
    filepath = "G:\Listen\TV Titelplanung DD_absolutiert_v2.xlsm"
    tp_data = TVTP_Importer(
        valid_statuses=(
            "ok",
            "change",
            "new",
            "alt/keine Rechte",
            "canceled",
            "INDIZIERT",
            "no avail",
            "Rights expired",
            "ausgelaufen",
        )
    ).get_tp_data_from_file(filepath)
    return tp_data


tp_data = self._get_date()
for vendor_id, series in tqdm(tp_data.items()):
    # do something for series
    for vendor_id_season, season in series.get('seasons').items():
        # do something for seasons
        for vendor_id_episode, episode in series.get('episodes').items():
            # do something for episodes
```