# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.1

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.devices.enumeration
except Exception:
    pass

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.foundation.numerics
except Exception:
    pass

try:
    import winsdk.windows.media
except Exception:
    pass

try:
    import winsdk.windows.media.capture
except Exception:
    pass

try:
    import winsdk.windows.media.core
except Exception:
    pass

try:
    import winsdk.windows.media.devices
except Exception:
    pass

try:
    import winsdk.windows.media.effects
except Exception:
    pass

try:
    import winsdk.windows.media.mediaproperties
except Exception:
    pass

try:
    import winsdk.windows.media.render
except Exception:
    pass

try:
    import winsdk.windows.media.transcoding
except Exception:
    pass

try:
    import winsdk.windows.storage
except Exception:
    pass

class AudioDeviceNodeCreationStatus(enum.IntEnum):
    SUCCESS = 0
    DEVICE_NOT_AVAILABLE = 1
    FORMAT_NOT_SUPPORTED = 2
    UNKNOWN_FAILURE = 3
    ACCESS_DENIED = 4

class AudioFileNodeCreationStatus(enum.IntEnum):
    SUCCESS = 0
    FILE_NOT_FOUND = 1
    INVALID_FILE_TYPE = 2
    FORMAT_NOT_SUPPORTED = 3
    UNKNOWN_FAILURE = 4

class AudioGraphCreationStatus(enum.IntEnum):
    SUCCESS = 0
    DEVICE_NOT_AVAILABLE = 1
    FORMAT_NOT_SUPPORTED = 2
    UNKNOWN_FAILURE = 3

class AudioGraphUnrecoverableError(enum.IntEnum):
    NONE = 0
    AUDIO_DEVICE_LOST = 1
    AUDIO_SESSION_DISCONNECTED = 2
    UNKNOWN_FAILURE = 3

class AudioNodeEmitterDecayKind(enum.IntEnum):
    NATURAL = 0
    CUSTOM = 1

class AudioNodeEmitterSettings(enum.IntFlag):
    NONE = 0
    DISABLE_DOPPLER = 0x1

class AudioNodeEmitterShapeKind(enum.IntEnum):
    OMNIDIRECTIONAL = 0
    CONE = 1

class AudioPlaybackConnectionOpenResultStatus(enum.IntEnum):
    SUCCESS = 0
    REQUEST_TIMED_OUT = 1
    DENIED_BY_SYSTEM = 2
    UNKNOWN_FAILURE = 3

class AudioPlaybackConnectionState(enum.IntEnum):
    CLOSED = 0
    OPENED = 1

class MediaSourceAudioInputNodeCreationStatus(enum.IntEnum):
    SUCCESS = 0
    FORMAT_NOT_SUPPORTED = 1
    NETWORK_ERROR = 2
    UNKNOWN_FAILURE = 3

class MixedRealitySpatialAudioFormatPolicy(enum.IntEnum):
    USE_MIXED_REALITY_DEFAULT_SPATIAL_AUDIO_FORMAT = 0
    USE_DEVICE_CONFIGURATION_DEFAULT_SPATIAL_AUDIO_FORMAT = 1

class QuantumSizeSelectionMode(enum.IntEnum):
    SYSTEM_DEFAULT = 0
    LOWEST_LATENCY = 1
    CLOSEST_TO_DESIRED = 2

class SetDefaultSpatialAudioFormatStatus(enum.IntEnum):
    SUCCEEDED = 0
    ACCESS_DENIED = 1
    LICENSE_EXPIRED = 2
    LICENSE_NOT_VALID_FOR_AUDIO_ENDPOINT = 3
    NOT_SUPPORTED_ON_AUDIO_ENDPOINT = 4
    UNKNOWN_ERROR = 5

class SpatialAudioModel(enum.IntEnum):
    OBJECT_BASED = 0
    FOLD_DOWN = 1

class AudioDeviceInputNode(IAudioInputNode, IAudioNode, winsdk.windows.foundation.IClosable, IAudioInputNode2, _winrt.Object):
    ...
    device: winsdk.windows.devices.enumeration.DeviceInformation
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    emitter: AudioNodeEmitter
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...

class AudioDeviceOutputNode(IAudioNode, winsdk.windows.foundation.IClosable, IAudioNodeWithListener, _winrt.Object):
    ...
    device: winsdk.windows.devices.enumeration.DeviceInformation
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    listener: AudioNodeListener
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...

class AudioFileInputNode(IAudioInputNode, IAudioNode, winsdk.windows.foundation.IClosable, IAudioInputNode2, _winrt.Object):
    ...
    playback_speed_factor: _winrt.Double
    loop_count: typing.Optional[_winrt.Int32]
    end_time: typing.Optional[winsdk.windows.foundation.TimeSpan]
    start_time: typing.Optional[winsdk.windows.foundation.TimeSpan]
    position: winsdk.windows.foundation.TimeSpan
    source_file: winsdk.windows.storage.StorageFile
    duration: winsdk.windows.foundation.TimeSpan
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    emitter: AudioNodeEmitter
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def reset() -> None:
        ...
    def seek(position: winsdk.windows.foundation.TimeSpan) -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def add_file_completed(handler: winsdk.windows.foundation.TypedEventHandler[AudioFileInputNode, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_file_completed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class AudioFileOutputNode(IAudioNode, winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    file: winsdk.windows.storage.IStorageFile
    file_encoding_profile: winsdk.windows.media.mediaproperties.MediaEncodingProfile
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def finalize_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.media.transcoding.TranscodeFailureReason]:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...

class AudioFrameCompletedEventArgs(_winrt.Object):
    ...
    frame: winsdk.windows.media.AudioFrame

class AudioFrameInputNode(IAudioInputNode, IAudioNode, winsdk.windows.foundation.IClosable, IAudioInputNode2, _winrt.Object):
    ...
    playback_speed_factor: _winrt.Double
    queued_sample_count: _winrt.UInt64
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    emitter: AudioNodeEmitter
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    def add_frame(frame: winsdk.windows.media.AudioFrame) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def discard_queued_frames() -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def add_audio_frame_completed(handler: winsdk.windows.foundation.TypedEventHandler[AudioFrameInputNode, AudioFrameCompletedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_audio_frame_completed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...
    def add_quantum_started(handler: winsdk.windows.foundation.TypedEventHandler[AudioFrameInputNode, FrameInputNodeQuantumStartedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_quantum_started(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class AudioFrameOutputNode(IAudioNode, winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def get_frame() -> winsdk.windows.media.AudioFrame:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...

class AudioGraph(winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    completed_quantum_count: _winrt.UInt64
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    latency_in_samples: _winrt.Int32
    primary_render_device: winsdk.windows.devices.enumeration.DeviceInformation
    render_device_audio_processing: winsdk.windows.media.AudioProcessing
    samples_per_quantum: _winrt.Int32
    def close() -> None:
        ...
    def create_async(settings: AudioGraphSettings) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioGraphResult]:
        ...
    def create_batch_updater() -> AudioGraphBatchUpdater:
        ...
    def create_device_input_node_async(category: winsdk.windows.media.capture.MediaCategory) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]:
        ...
    def create_device_input_node_async(category: winsdk.windows.media.capture.MediaCategory, encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]:
        ...
    def create_device_input_node_async(category: winsdk.windows.media.capture.MediaCategory, encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties, device: winsdk.windows.devices.enumeration.DeviceInformation) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]:
        ...
    def create_device_input_node_async(category: winsdk.windows.media.capture.MediaCategory, encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties, device: winsdk.windows.devices.enumeration.DeviceInformation, emitter: AudioNodeEmitter) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]:
        ...
    def create_device_output_node_async() -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceOutputNodeResult]:
        ...
    def create_file_input_node_async(file: winsdk.windows.storage.IStorageFile) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileInputNodeResult]:
        ...
    def create_file_input_node_async(file: winsdk.windows.storage.IStorageFile, emitter: AudioNodeEmitter) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileInputNodeResult]:
        ...
    def create_file_output_node_async(file: winsdk.windows.storage.IStorageFile) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileOutputNodeResult]:
        ...
    def create_file_output_node_async(file: winsdk.windows.storage.IStorageFile, file_encoding_profile: winsdk.windows.media.mediaproperties.MediaEncodingProfile) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileOutputNodeResult]:
        ...
    def create_frame_input_node() -> AudioFrameInputNode:
        ...
    def create_frame_input_node(encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties) -> AudioFrameInputNode:
        ...
    def create_frame_input_node(encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties, emitter: AudioNodeEmitter) -> AudioFrameInputNode:
        ...
    def create_frame_output_node() -> AudioFrameOutputNode:
        ...
    def create_frame_output_node(encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties) -> AudioFrameOutputNode:
        ...
    def create_media_source_audio_input_node_async(media_source: winsdk.windows.media.core.MediaSource) -> winsdk.windows.foundation.IAsyncOperation[CreateMediaSourceAudioInputNodeResult]:
        ...
    def create_media_source_audio_input_node_async(media_source: winsdk.windows.media.core.MediaSource, emitter: AudioNodeEmitter) -> winsdk.windows.foundation.IAsyncOperation[CreateMediaSourceAudioInputNodeResult]:
        ...
    def create_submix_node() -> AudioSubmixNode:
        ...
    def create_submix_node(encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties) -> AudioSubmixNode:
        ...
    def create_submix_node(encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties, emitter: AudioNodeEmitter) -> AudioSubmixNode:
        ...
    def reset_all_nodes() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def add_quantum_processed(handler: winsdk.windows.foundation.TypedEventHandler[AudioGraph, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_quantum_processed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...
    def add_quantum_started(handler: winsdk.windows.foundation.TypedEventHandler[AudioGraph, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_quantum_started(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...
    def add_unrecoverable_error_occurred(handler: winsdk.windows.foundation.TypedEventHandler[AudioGraph, AudioGraphUnrecoverableErrorOccurredEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_unrecoverable_error_occurred(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class AudioGraphBatchUpdater(winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    def close() -> None:
        ...

class AudioGraphConnection(_winrt.Object):
    ...
    gain: _winrt.Double
    destination: IAudioNode

class AudioGraphSettings(_winrt.Object):
    ...
    quantum_size_selection_mode: QuantumSizeSelectionMode
    primary_render_device: winsdk.windows.devices.enumeration.DeviceInformation
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    desired_samples_per_quantum: _winrt.Int32
    desired_render_device_audio_processing: winsdk.windows.media.AudioProcessing
    audio_render_category: winsdk.windows.media.render.AudioRenderCategory
    max_playback_speed_factor: _winrt.Double
    def __init__(self, audio_render_category: winsdk.windows.media.render.AudioRenderCategory) -> None:
        ...

class AudioGraphUnrecoverableErrorOccurredEventArgs(_winrt.Object):
    ...
    error: AudioGraphUnrecoverableError

class AudioNodeEmitter(_winrt.Object):
    ...
    position: winsdk.windows.foundation.numerics.Vector3
    gain: _winrt.Double
    doppler_velocity: winsdk.windows.foundation.numerics.Vector3
    doppler_scale: _winrt.Double
    distance_scale: _winrt.Double
    direction: winsdk.windows.foundation.numerics.Vector3
    decay_model: AudioNodeEmitterDecayModel
    is_doppler_disabled: _winrt.Boolean
    shape: AudioNodeEmitterShape
    spatial_audio_model: SpatialAudioModel
    def __init__(self, shape: AudioNodeEmitterShape, decay_model: AudioNodeEmitterDecayModel, settings: AudioNodeEmitterSettings) -> None:
        ...
    def __init__(self, ) -> None:
        ...

class AudioNodeEmitterConeProperties(_winrt.Object):
    ...
    inner_angle: _winrt.Double
    outer_angle: _winrt.Double
    outer_angle_gain: _winrt.Double

class AudioNodeEmitterDecayModel(_winrt.Object):
    ...
    kind: AudioNodeEmitterDecayKind
    max_gain: _winrt.Double
    min_gain: _winrt.Double
    natural_properties: AudioNodeEmitterNaturalDecayModelProperties
    def create_custom(min_gain: _winrt.Double, max_gain: _winrt.Double) -> AudioNodeEmitterDecayModel:
        ...
    def create_natural(min_gain: _winrt.Double, max_gain: _winrt.Double, unity_gain_distance: _winrt.Double, cutoff_distance: _winrt.Double) -> AudioNodeEmitterDecayModel:
        ...

class AudioNodeEmitterNaturalDecayModelProperties(_winrt.Object):
    ...
    cutoff_distance: _winrt.Double
    unity_gain_distance: _winrt.Double

class AudioNodeEmitterShape(_winrt.Object):
    ...
    cone_properties: AudioNodeEmitterConeProperties
    kind: AudioNodeEmitterShapeKind
    def create_cone(inner_angle: _winrt.Double, outer_angle: _winrt.Double, outer_angle_gain: _winrt.Double) -> AudioNodeEmitterShape:
        ...
    def create_omnidirectional() -> AudioNodeEmitterShape:
        ...

class AudioNodeListener(_winrt.Object):
    ...
    speed_of_sound: _winrt.Double
    position: winsdk.windows.foundation.numerics.Vector3
    orientation: winsdk.windows.foundation.numerics.Quaternion
    doppler_velocity: winsdk.windows.foundation.numerics.Vector3
    def __init__(self, ) -> None:
        ...

class AudioPlaybackConnection(winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    device_id: str
    state: AudioPlaybackConnectionState
    def close() -> None:
        ...
    def get_device_selector() -> str:
        ...
    def open() -> AudioPlaybackConnectionOpenResult:
        ...
    def open_async() -> winsdk.windows.foundation.IAsyncOperation[AudioPlaybackConnectionOpenResult]:
        ...
    def start() -> None:
        ...
    def start_async() -> winsdk.windows.foundation.IAsyncAction:
        ...
    def try_create_from_id(id: str) -> AudioPlaybackConnection:
        ...
    def add_state_changed(handler: winsdk.windows.foundation.TypedEventHandler[AudioPlaybackConnection, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_state_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class AudioPlaybackConnectionOpenResult(_winrt.Object):
    ...
    extended_error: winsdk.windows.foundation.HResult
    status: AudioPlaybackConnectionOpenResultStatus

class AudioStateMonitor(_winrt.Object):
    ...
    sound_level: winsdk.windows.media.SoundLevel
    def create_for_capture_monitoring() -> AudioStateMonitor:
        ...
    def create_for_capture_monitoring(category: winsdk.windows.media.capture.MediaCategory) -> AudioStateMonitor:
        ...
    def create_for_capture_monitoring(category: winsdk.windows.media.capture.MediaCategory, role: winsdk.windows.media.devices.AudioDeviceRole) -> AudioStateMonitor:
        ...
    def create_for_capture_monitoring_with_category_and_device_id(category: winsdk.windows.media.capture.MediaCategory, device_id: str) -> AudioStateMonitor:
        ...
    def create_for_render_monitoring() -> AudioStateMonitor:
        ...
    def create_for_render_monitoring(category: winsdk.windows.media.render.AudioRenderCategory) -> AudioStateMonitor:
        ...
    def create_for_render_monitoring(category: winsdk.windows.media.render.AudioRenderCategory, role: winsdk.windows.media.devices.AudioDeviceRole) -> AudioStateMonitor:
        ...
    def create_for_render_monitoring_with_category_and_device_id(category: winsdk.windows.media.render.AudioRenderCategory, device_id: str) -> AudioStateMonitor:
        ...
    def add_sound_level_changed(handler: winsdk.windows.foundation.TypedEventHandler[AudioStateMonitor, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_sound_level_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class AudioSubmixNode(IAudioInputNode, IAudioNode, winsdk.windows.foundation.IClosable, IAudioInputNode2, _winrt.Object):
    ...
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    emitter: AudioNodeEmitter
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...

class CreateAudioDeviceInputNodeResult(_winrt.Object):
    ...
    device_input_node: AudioDeviceInputNode
    status: AudioDeviceNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult

class CreateAudioDeviceOutputNodeResult(_winrt.Object):
    ...
    device_output_node: AudioDeviceOutputNode
    status: AudioDeviceNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult

class CreateAudioFileInputNodeResult(_winrt.Object):
    ...
    file_input_node: AudioFileInputNode
    status: AudioFileNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult

class CreateAudioFileOutputNodeResult(_winrt.Object):
    ...
    file_output_node: AudioFileOutputNode
    status: AudioFileNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult

class CreateAudioGraphResult(_winrt.Object):
    ...
    graph: AudioGraph
    status: AudioGraphCreationStatus
    extended_error: winsdk.windows.foundation.HResult

class CreateMediaSourceAudioInputNodeResult(_winrt.Object):
    ...
    node: MediaSourceAudioInputNode
    status: MediaSourceAudioInputNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult

class EchoEffectDefinition(winsdk.windows.media.effects.IAudioEffectDefinition, _winrt.Object):
    ...
    wet_dry_mix: _winrt.Double
    feedback: _winrt.Double
    delay: _winrt.Double
    activatable_class_id: str
    properties: winsdk.windows.foundation.collections.IPropertySet
    def __init__(self, audio_graph: AudioGraph) -> None:
        ...

class EqualizerBand(_winrt.Object):
    ...
    gain: _winrt.Double
    frequency_center: _winrt.Double
    bandwidth: _winrt.Double

class EqualizerEffectDefinition(winsdk.windows.media.effects.IAudioEffectDefinition, _winrt.Object):
    ...
    bands: winsdk.windows.foundation.collections.IVectorView[EqualizerBand]
    activatable_class_id: str
    properties: winsdk.windows.foundation.collections.IPropertySet
    def __init__(self, audio_graph: AudioGraph) -> None:
        ...

class FrameInputNodeQuantumStartedEventArgs(_winrt.Object):
    ...
    required_samples: _winrt.Int32

class LimiterEffectDefinition(winsdk.windows.media.effects.IAudioEffectDefinition, _winrt.Object):
    ...
    release: _winrt.UInt32
    loudness: _winrt.UInt32
    activatable_class_id: str
    properties: winsdk.windows.foundation.collections.IPropertySet
    def __init__(self, audio_graph: AudioGraph) -> None:
        ...

class MediaSourceAudioInputNode(IAudioInputNode2, IAudioInputNode, IAudioNode, winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    emitter: AudioNodeEmitter
    outgoing_gain: _winrt.Double
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    start_time: typing.Optional[winsdk.windows.foundation.TimeSpan]
    playback_speed_factor: _winrt.Double
    loop_count: typing.Optional[_winrt.Int32]
    end_time: typing.Optional[winsdk.windows.foundation.TimeSpan]
    duration: winsdk.windows.foundation.TimeSpan
    media_source: winsdk.windows.media.core.MediaSource
    position: winsdk.windows.foundation.TimeSpan
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def reset() -> None:
        ...
    def seek(position: winsdk.windows.foundation.TimeSpan) -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def add_media_source_completed(handler: winsdk.windows.foundation.TypedEventHandler[MediaSourceAudioInputNode, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_media_source_completed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class ReverbEffectDefinition(winsdk.windows.media.effects.IAudioEffectDefinition, _winrt.Object):
    ...
    high_e_q_gain: _winrt.UInt8
    high_e_q_cutoff: _winrt.UInt8
    disable_late_field: _winrt.Boolean
    density: _winrt.Double
    position_right: _winrt.UInt8
    decay_time: _winrt.Double
    late_diffusion: _winrt.UInt8
    position_matrix_right: _winrt.UInt8
    position_matrix_left: _winrt.UInt8
    position_left: _winrt.UInt8
    low_e_q_gain: _winrt.UInt8
    low_e_q_cutoff: _winrt.UInt8
    room_filter_freq: _winrt.Double
    reverb_gain: _winrt.Double
    reverb_delay: _winrt.UInt8
    reflections_gain: _winrt.Double
    reflections_delay: _winrt.UInt32
    rear_delay: _winrt.UInt8
    wet_dry_mix: _winrt.Double
    early_diffusion: _winrt.UInt8
    room_size: _winrt.Double
    room_filter_main: _winrt.Double
    room_filter_h_f: _winrt.Double
    activatable_class_id: str
    properties: winsdk.windows.foundation.collections.IPropertySet
    def __init__(self, audio_graph: AudioGraph) -> None:
        ...

class SetDefaultSpatialAudioFormatResult(_winrt.Object):
    ...
    status: SetDefaultSpatialAudioFormatStatus

class SpatialAudioDeviceConfiguration(_winrt.Object):
    ...
    active_spatial_audio_format: str
    default_spatial_audio_format: str
    device_id: str
    is_spatial_audio_supported: _winrt.Boolean
    def get_for_device_id(device_id: str) -> SpatialAudioDeviceConfiguration:
        ...
    def is_spatial_audio_format_supported(subtype: str) -> _winrt.Boolean:
        ...
    def set_default_spatial_audio_format_async(subtype: str) -> winsdk.windows.foundation.IAsyncOperation[SetDefaultSpatialAudioFormatResult]:
        ...
    def add_configuration_changed(handler: winsdk.windows.foundation.TypedEventHandler[SpatialAudioDeviceConfiguration, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_configuration_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class SpatialAudioFormatConfiguration(_winrt.Object):
    ...
    mixed_reality_exclusive_mode_policy: MixedRealitySpatialAudioFormatPolicy
    def get_default() -> SpatialAudioFormatConfiguration:
        ...
    def report_configuration_changed_async(subtype: str) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def report_license_changed_async(subtype: str) -> winsdk.windows.foundation.IAsyncAction:
        ...

class SpatialAudioFormatSubtype(_winrt.Object):
    ...
    d_t_s_headphone_x: str
    d_t_s_x_ultra: str
    dolby_atmos_for_headphones: str
    dolby_atmos_for_home_theater: str
    dolby_atmos_for_speakers: str
    windows_sonic: str
    d_t_s_x_for_home_theater: str

class IAudioInputNode(IAudioNode, winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    outgoing_gain: _winrt.Double
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def close() -> None:
        ...

class IAudioInputNode2(IAudioNode, winsdk.windows.foundation.IClosable, IAudioInputNode, _winrt.Object):
    ...
    emitter: AudioNodeEmitter
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    outgoing_gain: _winrt.Double
    outgoing_connections: winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def close() -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode) -> None:
        ...
    def add_outgoing_connection(destination: IAudioNode, gain: _winrt.Double) -> None:
        ...
    def remove_outgoing_connection(destination: IAudioNode) -> None:
        ...

class IAudioNode(winsdk.windows.foundation.IClosable, _winrt.Object):
    ...
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    outgoing_gain: _winrt.Double
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...
    def close() -> None:
        ...

class IAudioNodeWithListener(winsdk.windows.foundation.IClosable, IAudioNode, _winrt.Object):
    ...
    listener: AudioNodeListener
    consume_input: _winrt.Boolean
    effect_definitions: winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]
    encoding_properties: winsdk.windows.media.mediaproperties.AudioEncodingProperties
    outgoing_gain: _winrt.Double
    def close() -> None:
        ...
    def disable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def enable_effects_by_definition(definition: winsdk.windows.media.effects.IAudioEffectDefinition) -> None:
        ...
    def reset() -> None:
        ...
    def start() -> None:
        ...
    def stop() -> None:
        ...

