# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.1

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.media.mediaproperties
except Exception:
    pass

try:
    import winsdk.windows.security.credentials
except Exception:
    pass

try:
    import winsdk.windows.storage.streams
except Exception:
    pass

class ChatConversationThreadingKind(enum.IntEnum):
    PARTICIPANTS = 0
    CONTACT_ID = 1
    CONVERSATION_ID = 2
    CUSTOM = 3

class ChatItemKind(enum.IntEnum):
    MESSAGE = 0
    CONVERSATION = 1

class ChatMessageChangeType(enum.IntEnum):
    MESSAGE_CREATED = 0
    MESSAGE_MODIFIED = 1
    MESSAGE_DELETED = 2
    CHANGE_TRACKING_LOST = 3

class ChatMessageKind(enum.IntEnum):
    STANDARD = 0
    FILE_TRANSFER_REQUEST = 1
    TRANSPORT_CUSTOM = 2
    JOINED_CONVERSATION = 3
    LEFT_CONVERSATION = 4
    OTHER_PARTICIPANT_JOINED_CONVERSATION = 5
    OTHER_PARTICIPANT_LEFT_CONVERSATION = 6

class ChatMessageOperatorKind(enum.IntEnum):
    UNSPECIFIED = 0
    SMS = 1
    MMS = 2
    RCS = 3

class ChatMessageStatus(enum.IntEnum):
    DRAFT = 0
    SENDING = 1
    SENT = 2
    SEND_RETRY_NEEDED = 3
    SEND_FAILED = 4
    RECEIVED = 5
    RECEIVE_DOWNLOAD_NEEDED = 6
    RECEIVE_DOWNLOAD_FAILED = 7
    RECEIVE_DOWNLOADING = 8
    DELETED = 9
    DECLINED = 10
    CANCELLED = 11
    RECALLED = 12
    RECEIVE_RETRY_NEEDED = 13

class ChatMessageTransportKind(enum.IntEnum):
    TEXT = 0
    UNTRIAGED = 1
    BLOCKED = 2
    CUSTOM = 3

class ChatMessageValidationStatus(enum.IntEnum):
    VALID = 0
    NO_RECIPIENTS = 1
    INVALID_DATA = 2
    MESSAGE_TOO_LARGE = 3
    TOO_MANY_RECIPIENTS = 4
    TRANSPORT_INACTIVE = 5
    TRANSPORT_NOT_FOUND = 6
    TOO_MANY_ATTACHMENTS = 7
    INVALID_RECIPIENTS = 8
    INVALID_BODY = 9
    INVALID_OTHER = 10
    VALID_WITH_LARGE_MESSAGE = 11
    VOICE_ROAMING_RESTRICTION = 12
    DATA_ROAMING_RESTRICTION = 13

class ChatRestoreHistorySpan(enum.IntEnum):
    LAST_MONTH = 0
    LAST_YEAR = 1
    ANY_TIME = 2

class ChatStoreChangedEventKind(enum.IntEnum):
    NOTIFICATIONS_MISSED = 0
    STORE_MODIFIED = 1
    MESSAGE_CREATED = 2
    MESSAGE_MODIFIED = 3
    MESSAGE_DELETED = 4
    CONVERSATION_MODIFIED = 5
    CONVERSATION_DELETED = 6
    CONVERSATION_TRANSPORT_DELETED = 7

class ChatTransportErrorCodeCategory(enum.IntEnum):
    NONE = 0
    HTTP = 1
    NETWORK = 2
    MMS_SERVER = 3

class ChatTransportInterpretedErrorCode(enum.IntEnum):
    NONE = 0
    UNKNOWN = 1
    INVALID_RECIPIENT_ADDRESS = 2
    NETWORK_CONNECTIVITY = 3
    SERVICE_DENIED = 4
    TIMEOUT = 5

class RcsServiceKind(enum.IntEnum):
    CHAT = 0
    GROUP_CHAT = 1
    FILE_TRANSFER = 2
    CAPABILITY = 3

class ChatCapabilities(_winrt.Object):
    ...
    is_chat_capable: _winrt.Boolean
    is_file_transfer_capable: _winrt.Boolean
    is_geo_location_push_capable: _winrt.Boolean
    is_integrated_messaging_capable: _winrt.Boolean
    is_online: _winrt.Boolean

class ChatCapabilitiesManager(_winrt.Object):
    ...
    def get_cached_capabilities_async(address: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]:
        ...
    def get_cached_capabilities_async(address: str, transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]:
        ...
    def get_capabilities_from_network_async(address: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]:
        ...
    def get_capabilities_from_network_async(address: str, transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]:
        ...

class ChatConversation(IChatItem, _winrt.Object):
    ...
    subject: str
    is_conversation_muted: _winrt.Boolean
    has_unread_messages: _winrt.Boolean
    id: str
    most_recent_message_id: str
    participants: winsdk.windows.foundation.collections.IVector[str]
    threading_info: ChatConversationThreadingInfo
    can_modify_participants: _winrt.Boolean
    item_kind: ChatItemKind
    def delete_async() -> winsdk.windows.foundation.IAsyncAction:
        ...
    def get_message_reader() -> ChatMessageReader:
        ...
    def mark_messages_as_read_async() -> winsdk.windows.foundation.IAsyncAction:
        ...
    def mark_messages_as_read_async(value: winsdk.windows.foundation.DateTime) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def notify_local_participant_composing(transport_id: str, participant_address: str, is_composing: _winrt.Boolean) -> None:
        ...
    def notify_remote_participant_composing(transport_id: str, participant_address: str, is_composing: _winrt.Boolean) -> None:
        ...
    def save_async() -> winsdk.windows.foundation.IAsyncAction:
        ...
    def add_remote_participant_composing_changed(handler: winsdk.windows.foundation.TypedEventHandler[ChatConversation, RemoteParticipantComposingChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_remote_participant_composing_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class ChatConversationReader(_winrt.Object):
    ...
    def read_batch_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatConversation]]:
        ...
    def read_batch_async(count: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatConversation]]:
        ...

class ChatConversationThreadingInfo(_winrt.Object):
    ...
    kind: ChatConversationThreadingKind
    custom: str
    conversation_id: str
    contact_id: str
    participants: winsdk.windows.foundation.collections.IVector[str]
    def __init__(self, ) -> None:
        ...

class ChatMessage(IChatItem, _winrt.Object):
    ...
    item_kind: ChatItemKind
    is_incoming: _winrt.Boolean
    is_forwarding_disabled: _winrt.Boolean
    transport_id: str
    status: ChatMessageStatus
    from: str
    body: str
    subject: str
    is_read: _winrt.Boolean
    network_timestamp: winsdk.windows.foundation.DateTime
    local_timestamp: winsdk.windows.foundation.DateTime
    recipient_send_statuses: winsdk.windows.foundation.collections.IMapView[str, ChatMessageStatus]
    recipients: winsdk.windows.foundation.collections.IVector[str]
    transport_friendly_name: str
    attachments: winsdk.windows.foundation.collections.IVector[ChatMessageAttachment]
    id: str
    is_seen: _winrt.Boolean
    message_kind: ChatMessageKind
    is_received_during_quiet_hours: _winrt.Boolean
    is_auto_reply: _winrt.Boolean
    estimated_download_size: _winrt.UInt64
    threading_info: ChatConversationThreadingInfo
    should_suppress_notification: _winrt.Boolean
    remote_id: str
    message_operator_kind: ChatMessageOperatorKind
    is_reply_disabled: _winrt.Boolean
    is_sim_message: _winrt.Boolean
    recipients_delivery_infos: winsdk.windows.foundation.collections.IVector[ChatRecipientDeliveryInfo]
    sync_id: str
    def __init__(self, ) -> None:
        ...

class ChatMessageAttachment(_winrt.Object):
    ...
    text: str
    mime_type: str
    group_id: _winrt.UInt32
    data_stream_reference: winsdk.windows.storage.streams.IRandomAccessStreamReference
    transfer_progress: _winrt.Double
    thumbnail: winsdk.windows.storage.streams.IRandomAccessStreamReference
    original_file_name: str
    def __init__(self, mime_type: str, data_stream_reference: winsdk.windows.storage.streams.IRandomAccessStreamReference) -> None:
        ...

class ChatMessageBlocking(_winrt.Object):
    ...
    def mark_message_as_blocked_async(local_chat_message_id: str, blocked: _winrt.Boolean) -> winsdk.windows.foundation.IAsyncAction:
        ...

class ChatMessageChange(_winrt.Object):
    ...
    change_type: ChatMessageChangeType
    message: ChatMessage

class ChatMessageChangeReader(_winrt.Object):
    ...
    def accept_changes() -> None:
        ...
    def accept_changes_through(last_change_to_acknowledge: ChatMessageChange) -> None:
        ...
    def read_batch_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessageChange]]:
        ...

class ChatMessageChangeTracker(_winrt.Object):
    ...
    def enable() -> None:
        ...
    def get_change_reader() -> ChatMessageChangeReader:
        ...
    def reset() -> None:
        ...

class ChatMessageChangedDeferral(_winrt.Object):
    ...
    def complete() -> None:
        ...

class ChatMessageChangedEventArgs(_winrt.Object):
    ...
    def get_deferral() -> ChatMessageChangedDeferral:
        ...

class ChatMessageManager(_winrt.Object):
    ...
    def get_transport_async(transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessageTransport]:
        ...
    def get_transports_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessageTransport]]:
        ...
    def register_transport_async() -> winsdk.windows.foundation.IAsyncOperation[str]:
        ...
    def request_store_async() -> winsdk.windows.foundation.IAsyncOperation[ChatMessageStore]:
        ...
    def request_sync_manager_async() -> winsdk.windows.foundation.IAsyncOperation[ChatSyncManager]:
        ...
    def show_compose_sms_message_async(message: ChatMessage) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def show_sms_settings() -> None:
        ...

class ChatMessageNotificationTriggerDetails(_winrt.Object):
    ...
    chat_message: ChatMessage
    should_display_toast: _winrt.Boolean
    should_update_action_center: _winrt.Boolean
    should_update_badge: _winrt.Boolean
    should_update_detail_text: _winrt.Boolean

class ChatMessageReader(_winrt.Object):
    ...
    def read_batch_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessage]]:
        ...
    def read_batch_async(count: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessage]]:
        ...

class ChatMessageStore(_winrt.Object):
    ...
    change_tracker: ChatMessageChangeTracker
    def delete_message_async(local_message_id: str) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def download_message_async(local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def forward_message_async(local_chat_message_id: str, addresses: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]:
        ...
    def get_conversation_async(conversation_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatConversation]:
        ...
    def get_conversation_async(conversation_id: str, transport_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[ChatConversation]:
        ...
    def get_conversation_from_threading_info_async(threading_info: ChatConversationThreadingInfo) -> winsdk.windows.foundation.IAsyncOperation[ChatConversation]:
        ...
    def get_conversation_reader() -> ChatConversationReader:
        ...
    def get_conversation_reader(transport_ids: typing.Iterable[str]) -> ChatConversationReader:
        ...
    def get_message_async(local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]:
        ...
    def get_message_by_remote_id_async(transport_id: str, remote_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]:
        ...
    def get_message_by_sync_id_async(sync_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]:
        ...
    def get_message_reader() -> ChatMessageReader:
        ...
    def get_message_reader(recent_time_limit: winsdk.windows.foundation.TimeSpan) -> ChatMessageReader:
        ...
    def get_search_reader(value: ChatQueryOptions) -> ChatSearchReader:
        ...
    def get_unseen_count_async() -> winsdk.windows.foundation.IAsyncOperation[_winrt.Int32]:
        ...
    def get_unseen_count_async(transport_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Int32]:
        ...
    def mark_as_seen_async() -> winsdk.windows.foundation.IAsyncAction:
        ...
    def mark_as_seen_async(transport_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def mark_message_read_async(local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def retry_send_message_async(local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def save_message_async(chat_message: ChatMessage) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def send_message_async(chat_message: ChatMessage) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def try_cancel_download_message_async(local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]:
        ...
    def try_cancel_send_message_async(local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]:
        ...
    def validate_message(chat_message: ChatMessage) -> ChatMessageValidationResult:
        ...
    def add_message_changed(value: winsdk.windows.foundation.TypedEventHandler[ChatMessageStore, ChatMessageChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_message_changed(value: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...
    def add_store_changed(handler: winsdk.windows.foundation.TypedEventHandler[ChatMessageStore, ChatMessageStoreChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_store_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class ChatMessageStoreChangedEventArgs(_winrt.Object):
    ...
    id: str
    kind: ChatStoreChangedEventKind

class ChatMessageTransport(_winrt.Object):
    ...
    is_active: _winrt.Boolean
    is_app_set_as_notification_provider: _winrt.Boolean
    transport_friendly_name: str
    transport_id: str
    configuration: ChatMessageTransportConfiguration
    transport_kind: ChatMessageTransportKind
    def request_set_as_notification_provider_async() -> winsdk.windows.foundation.IAsyncAction:
        ...

class ChatMessageTransportConfiguration(_winrt.Object):
    ...
    extended_properties: winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]
    max_attachment_count: _winrt.Int32
    max_message_size_in_kilobytes: _winrt.Int32
    max_recipient_count: _winrt.Int32
    supported_video_format: winsdk.windows.media.mediaproperties.MediaEncodingProfile

class ChatMessageValidationResult(_winrt.Object):
    ...
    max_part_count: typing.Optional[_winrt.UInt32]
    part_count: typing.Optional[_winrt.UInt32]
    remaining_character_count_in_part: typing.Optional[_winrt.UInt32]
    status: ChatMessageValidationStatus

class ChatQueryOptions(_winrt.Object):
    ...
    search_string: str
    def __init__(self, ) -> None:
        ...

class ChatRecipientDeliveryInfo(_winrt.Object):
    ...
    transport_address: str
    read_time: typing.Optional[winsdk.windows.foundation.DateTime]
    delivery_time: typing.Optional[winsdk.windows.foundation.DateTime]
    is_error_permanent: _winrt.Boolean
    status: ChatMessageStatus
    transport_error_code: _winrt.Int32
    transport_error_code_category: ChatTransportErrorCodeCategory
    transport_interpreted_error_code: ChatTransportInterpretedErrorCode
    def __init__(self, ) -> None:
        ...

class ChatSearchReader(_winrt.Object):
    ...
    def read_batch_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IChatItem]]:
        ...
    def read_batch_async(count: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IChatItem]]:
        ...

class ChatSyncConfiguration(_winrt.Object):
    ...
    restore_history_span: ChatRestoreHistorySpan
    is_sync_enabled: _winrt.Boolean

class ChatSyncManager(_winrt.Object):
    ...
    configuration: ChatSyncConfiguration
    def associate_account_async(web_account: winsdk.windows.security.credentials.WebAccount) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def is_account_associated(web_account: winsdk.windows.security.credentials.WebAccount) -> _winrt.Boolean:
        ...
    def set_configuration_async(configuration: ChatSyncConfiguration) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def start_sync() -> None:
        ...
    def unassociate_account_async() -> winsdk.windows.foundation.IAsyncAction:
        ...

class RcsEndUserMessage(_winrt.Object):
    ...
    actions: winsdk.windows.foundation.collections.IVectorView[RcsEndUserMessageAction]
    is_pin_required: _winrt.Boolean
    text: str
    title: str
    transport_id: str
    def send_response_async(action: RcsEndUserMessageAction) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def send_response_with_pin_async(action: RcsEndUserMessageAction, pin: str) -> winsdk.windows.foundation.IAsyncAction:
        ...

class RcsEndUserMessageAction(_winrt.Object):
    ...
    label: str

class RcsEndUserMessageAvailableEventArgs(_winrt.Object):
    ...
    is_message_available: _winrt.Boolean
    message: RcsEndUserMessage

class RcsEndUserMessageAvailableTriggerDetails(_winrt.Object):
    ...
    text: str
    title: str

class RcsEndUserMessageManager(_winrt.Object):
    ...
    def add_message_available_changed(handler: winsdk.windows.foundation.TypedEventHandler[RcsEndUserMessageManager, RcsEndUserMessageAvailableEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_message_available_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class RcsManager(_winrt.Object):
    ...
    def get_end_user_message_manager() -> RcsEndUserMessageManager:
        ...
    def get_transport_async(transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[RcsTransport]:
        ...
    def get_transports_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[RcsTransport]]:
        ...
    def leave_conversation_async(conversation: ChatConversation) -> winsdk.windows.foundation.IAsyncAction:
        ...
    def add_transport_list_changed(handler: winsdk.windows.foundation.EventHandler[_winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_transport_list_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class RcsServiceKindSupportedChangedEventArgs(_winrt.Object):
    ...
    service_kind: RcsServiceKind

class RcsTransport(_winrt.Object):
    ...
    configuration: RcsTransportConfiguration
    extended_properties: winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]
    is_active: _winrt.Boolean
    transport_friendly_name: str
    transport_id: str
    def is_service_kind_supported(service_kind: RcsServiceKind) -> _winrt.Boolean:
        ...
    def is_store_and_forward_enabled(service_kind: RcsServiceKind) -> _winrt.Boolean:
        ...
    def add_service_kind_supported_changed(handler: winsdk.windows.foundation.TypedEventHandler[RcsTransport, RcsServiceKindSupportedChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken:
        ...
    def remove_service_kind_supported_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None:
        ...

class RcsTransportConfiguration(_winrt.Object):
    ...
    max_attachment_count: _winrt.Int32
    max_file_size_in_kilobytes: _winrt.Int32
    max_group_message_size_in_kilobytes: _winrt.Int32
    max_message_size_in_kilobytes: _winrt.Int32
    max_recipient_count: _winrt.Int32
    warning_file_size_in_kilobytes: _winrt.Int32

class RemoteParticipantComposingChangedEventArgs(_winrt.Object):
    ...
    is_composing: _winrt.Boolean
    participant_address: str
    transport_id: str

class IChatItem(_winrt.Object):
    ...
    item_kind: ChatItemKind

