# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetLoggingConfigurationResult',
    'AwaitableGetLoggingConfigurationResult',
    'get_logging_configuration',
    'get_logging_configuration_output',
]

@pulumi.output_type
class GetLoggingConfigurationResult:
    def __init__(__self__, arn=None, destination_configuration=None, id=None, name=None, state=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if destination_configuration and not isinstance(destination_configuration, dict):
            raise TypeError("Expected argument 'destination_configuration' to be a dict")
        pulumi.set(__self__, "destination_configuration", destination_configuration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        LoggingConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="destinationConfiguration")
    def destination_configuration(self) -> Optional['outputs.LoggingConfigurationDestinationConfiguration']:
        return pulumi.get(self, "destination_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The system-generated ID of the logging configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the logging configuration. The value does not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional['LoggingConfigurationState']:
        """
        The state of the logging configuration. When the state is ACTIVE, the configuration is ready to log chat content.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.LoggingConfigurationTag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLoggingConfigurationResult(GetLoggingConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoggingConfigurationResult(
            arn=self.arn,
            destination_configuration=self.destination_configuration,
            id=self.id,
            name=self.name,
            state=self.state,
            tags=self.tags)


def get_logging_configuration(arn: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoggingConfigurationResult:
    """
    Resource type definition for AWS::IVSChat::LoggingConfiguration.


    :param str arn: LoggingConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ivschat:getLoggingConfiguration', __args__, opts=opts, typ=GetLoggingConfigurationResult).value

    return AwaitableGetLoggingConfigurationResult(
        arn=__ret__.arn,
        destination_configuration=__ret__.destination_configuration,
        id=__ret__.id,
        name=__ret__.name,
        state=__ret__.state,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_logging_configuration)
def get_logging_configuration_output(arn: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLoggingConfigurationResult]:
    """
    Resource type definition for AWS::IVSChat::LoggingConfiguration.


    :param str arn: LoggingConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
    """
    ...
