# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LocationArgs', 'Location']

@pulumi.input_type
class LocationArgs:
    def __init__(__self__, *,
                 location_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['LocationTagArgs']]]] = None):
        """
        The set of arguments for constructing a Location resource.
        :param pulumi.Input[Sequence[pulumi.Input['LocationTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location_name")

    @location_name.setter
    def location_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocationTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocationTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Location(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocationTagArgs']]]]] = None,
                 __props__=None):
        """
        The AWS::GameLift::Location resource creates an Amazon GameLift (GameLift) custom location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocationTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LocationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::GameLift::Location resource creates an Amazon GameLift (GameLift) custom location.

        :param str resource_name: The name of the resource.
        :param LocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocationTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationArgs.__new__(LocationArgs)

            __props__.__dict__["location_name"] = location_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["location_arn"] = None
        super(Location, __self__).__init__(
            'aws-native:gamelift:Location',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Location':
        """
        Get an existing Location resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocationArgs.__new__(LocationArgs)

        __props__.__dict__["location_arn"] = None
        __props__.__dict__["location_name"] = None
        __props__.__dict__["tags"] = None
        return Location(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.LocationTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

