"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnProject = exports.toJson_Email = exports.toJson_PagerDuty = exports.toJson_Webhook = exports.toJson_Slack = exports.toJson_CfnProjectProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnProjectProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnProjectProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Slack': toJson_Slack(obj.slack),
        'Webhook': toJson_Webhook(obj.webhook),
        'PagerDuty': toJson_PagerDuty(obj.pagerDuty),
        'Email': toJson_Email(obj.email),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnProjectProps = toJson_CfnProjectProps;
/**
 * Converts an object of type 'Slack' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Slack(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
        'ServiceAccountId': obj.serviceAccountId,
        'Channel': obj.channel,
        'ShowMessageButtons': obj.showMessageButtons,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Slack = toJson_Slack;
/**
 * Converts an object of type 'Webhook' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Webhook(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
        'Url': obj.url,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Webhook = toJson_Webhook;
/**
 * Converts an object of type 'PagerDuty' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PagerDuty(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
        'ServiceKey': obj.serviceKey,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PagerDuty = toJson_PagerDuty;
/**
 * Converts an object of type 'Email' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Email(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
        'IncludeRequestParams': obj.includeRequestParams,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Email = toJson_Email;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Rollbar::Projects::Project`
 *
 * @cloudformationResource Rollbar::Projects::Project
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
 */
class CfnProject extends cdk.CfnResource {
    /**
     * Create a new `Rollbar::Projects::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnProject.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnProjectProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asNumber(this.getAtt('Id'));
        this.attrAccountId = cdk.Token.asNumber(this.getAtt('AccountId'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
    }
}
exports.CfnProject = CfnProject;
_a = JSII_RTTI_SYMBOL_1;
CfnProject[_a] = { fqn: "@cdk-cloudformation/rollbar-projects-project.CfnProject", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnProject.CFN_RESOURCE_TYPE_NAME = "Rollbar::Projects::Project";
//# sourceMappingURL=data:application/json;base64,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