import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a project on Rollbar.
 *
 * @schema CfnProjectProps
 */
export interface CfnProjectProps {
    /**
     * Name of the project. Must start with a letter; can contain letters, numbers, spaces, underscores, hyphens, periods, and commas. Max length 32 characters.
     *
     * @schema CfnProjectProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnProjectProps#Slack
     */
    readonly slack?: Slack;
    /**
     * @schema CfnProjectProps#Webhook
     */
    readonly webhook?: Webhook;
    /**
     * @schema CfnProjectProps#PagerDuty
     */
    readonly pagerDuty?: PagerDuty;
    /**
     * @schema CfnProjectProps#Email
     */
    readonly email?: Email;
}
/**
 * Converts an object of type 'CfnProjectProps' to JSON representation.
 */
export declare function toJson_CfnProjectProps(obj: CfnProjectProps | undefined): Record<string, any> | undefined;
/**
 * Configuring Slack notifications integration.
 *
 * @schema Slack
 */
export interface Slack {
    /**
     * Enable the Slack notifications globally
     *
     * @schema Slack#Enabled
     */
    readonly enabled: boolean;
    /**
     * You can find your Service Account ID in https://rollbar.com/settings/integrations/#slack
     *
     * @schema Slack#ServiceAccountId
     */
    readonly serviceAccountId: number;
    /**
     * The default Slack channel to send the messages
     *
     * @schema Slack#Channel
     */
    readonly channel: string;
    /**
     * Show the Slack actionable buttons
     *
     * @schema Slack#ShowMessageButtons
     */
    readonly showMessageButtons?: boolean;
}
/**
 * Converts an object of type 'Slack' to JSON representation.
 */
export declare function toJson_Slack(obj: Slack | undefined): Record<string, any> | undefined;
/**
 * Configuring Webhook notifications integration.
 *
 * @schema Webhook
 */
export interface Webhook {
    /**
     * Enable the webhook notifications globally
     *
     * @schema Webhook#Enabled
     */
    readonly enabled: boolean;
    /**
     * The webhook url
     *
     * @schema Webhook#Url
     */
    readonly url: string;
}
/**
 * Converts an object of type 'Webhook' to JSON representation.
 */
export declare function toJson_Webhook(obj: Webhook | undefined): Record<string, any> | undefined;
/**
 * Configuring PagerDuty notifications integration.
 *
 * @schema PagerDuty
 */
export interface PagerDuty {
    /**
     * Enable the PagerDuty notifications globally
     *
     * @schema PagerDuty#Enabled
     */
    readonly enabled: boolean;
    /**
     * PagerDuty Service API Key
     *
     * @schema PagerDuty#ServiceKey
     */
    readonly serviceKey: string;
}
/**
 * Converts an object of type 'PagerDuty' to JSON representation.
 */
export declare function toJson_PagerDuty(obj: PagerDuty | undefined): Record<string, any> | undefined;
/**
 * Configuring Email notifications integration.
 *
 * @schema Email
 */
export interface Email {
    /**
     * Enable the Email notifications globally
     *
     * @schema Email#Enabled
     */
    readonly enabled: boolean;
    /**
     * Whether to include request parameters
     *
     * @schema Email#IncludeRequestParams
     */
    readonly includeRequestParams?: boolean;
}
/**
 * Converts an object of type 'Email' to JSON representation.
 */
export declare function toJson_Email(obj: Email | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Rollbar::Projects::Project`
 *
 * @cloudformationResource Rollbar::Projects::Project
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
 */
export declare class CfnProject extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Rollbar::Projects::Project";
    /**
     * Resource props.
     */
    readonly props: CfnProjectProps;
    /**
     * Attribute `Rollbar::Projects::Project.Id`
     * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
     */
    readonly attrId: number;
    /**
     * Attribute `Rollbar::Projects::Project.AccountId`
     * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
     */
    readonly attrAccountId: number;
    /**
     * Attribute `Rollbar::Projects::Project.Status`
     * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
     */
    readonly attrStatus: string;
    /**
     * Create a new `Rollbar::Projects::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnProjectProps);
}
