## Meta-Network

[![Travis](https://flat.badgen.net/travis/paradoxysm/metanetwork?label=build)](https://travis-ci.com/paradoxysm/metanetwork)
[![Codecov](https://flat.badgen.net/codecov/c/github/paradoxysm/metanetwork?label=coverage)](https://codecov.io/gh/paradoxysm/metanetwork)
[![GitHub](https://flat.badgen.net/github/license/paradoxysm/metanetwork)](https://github.com/paradoxysm/metanetwork/blob/master/LICENSE)

Meta-Network is an approach to ensemble learning where base learners are not constrained to the same task but rather take on distinct roles in the ensemble. Commonly, ensembles of classifiers do not have a distinction in each base learner's role. While each base learner may be diversified through bootstrapping or use of different parameters/models, their objectives are universally the same: classify its input to the best of its ability. Stacking and meta-classifiers introduce a sense of roles but each layer retains the same objective. Meta-Networks, however, remove this universal objective. By training the ensemble as a whole unit through backpropagation, each base learner may learn different objectives that orchestrate together to produce the ultimate objective, resulting in greater capacity for higher performance and solutions for complex problems.

This package hosts the basic meta-network model as well as additional implementations of the principle.

More details regarding Meta-Networks can be found in the documentation [here](https://github.com/paradoxysm/metanetwork/tree/master/doc).

## Installation

Once you have a suitable python environment setup, `metanetwork` can be easily installed using `pip`:
```
pip install metanetwork
```
> `metanetwork` is tested and supported on Python 3.4 up to Python 3.8. Usage on other versions of Python is not guaranteed to work as intended.

## Usage

Meta-Networks are quite simple to use, although they do need some encouragement by creating the meta-network structure first. They generally follow `sklearn` API style.

```python
from metanetwork import MetaNetwork, NeuralNetwork

# Create ensemble with a first layer of 3 estimators and a final layer of 1 estimator
estimators = [NeuralNetwork(), NeuralNetwork(), NeuralNetwork(), NeuralNetwork()]
for e in estimators[:-1]:
	e.n_classes_ = 2 	# Each estimator in the first layer produces 2 outputs
e[-1].n_classes_ =  4 		# The final estimator produces the 4 class outputs
network = [estimators[:-1], estimators[-1:]]

# Create and train the metanetwork
mn = MetaNetwork(network).fit(train_X, train_Y)

# Predict some data
p = mn.predict(test_X)
```
For full details on usage, see the [documentation](https://github.com/paradoxysm/metanetwork/tree/master/doc).

## Changelog

See the [changelog](https://github.com/paradoxysm/metanetwork/blob/master/CHANGES.md) for a history of notable changes to `metanetwork`.

## Development

[![Code Climate maintainability](https://img.shields.io/codeclimate/maintainability-percentage/paradoxysm/metanetwork?style=flat-square)](https://codeclimate.com/github/paradoxysm/metanetwork/maintainability)

`metanetwork` is in heavy development. Don't look, it's embarrassing!

## Help and Support

### Documentation

Documentation for `metanetwork` can be found [here](https://github.com/paradoxysm/metanetwork/tree/master/doc).

### Issues and Questions

Issues and Questions should be posed to the issue tracker [here](https://github.com/paradoxysm/metanetwork/issues).
