# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddDataForApiSourceRequest(TeaModel):
    def __init__(self, api_id=None, content=None, iot_instance_id=None):
        self.api_id = api_id  # type: str
        self.content = content  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDataForApiSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.content is not None:
            result['Content'] = self.content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class AddDataForApiSourceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDataForApiSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddDataForApiSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddDataForApiSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddDataForApiSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDataForApiSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddShareTaskDeviceRequest(TeaModel):
    def __init__(self, iot_id_list=None, iot_instance_id=None, product_key=None, share_task_id=None):
        self.iot_id_list = iot_id_list  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.share_task_id = share_task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddShareTaskDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id_list is not None:
            result['IotIdList'] = self.iot_id_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.share_task_id is not None:
            result['ShareTaskId'] = self.share_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotIdList') is not None:
            self.iot_id_list = m.get('IotIdList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ShareTaskId') is not None:
            self.share_task_id = m.get('ShareTaskId')
        return self


class AddShareTaskDeviceResponseBodyData(TeaModel):
    def __init__(self, fail_sum=None, failed_result_csv_file=None, progress=None, progress_id=None,
                 success_sum=None):
        self.fail_sum = fail_sum  # type: int
        self.failed_result_csv_file = failed_result_csv_file  # type: str
        self.progress = progress  # type: int
        self.progress_id = progress_id  # type: str
        self.success_sum = success_sum  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddShareTaskDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_sum is not None:
            result['FailSum'] = self.fail_sum
        if self.failed_result_csv_file is not None:
            result['FailedResultCsvFile'] = self.failed_result_csv_file
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.progress_id is not None:
            result['ProgressId'] = self.progress_id
        if self.success_sum is not None:
            result['SuccessSum'] = self.success_sum
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailSum') is not None:
            self.fail_sum = m.get('FailSum')
        if m.get('FailedResultCsvFile') is not None:
            self.failed_result_csv_file = m.get('FailedResultCsvFile')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProgressId') is not None:
            self.progress_id = m.get('ProgressId')
        if m.get('SuccessSum') is not None:
            self.success_sum = m.get('SuccessSum')
        return self


class AddShareTaskDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: AddShareTaskDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddShareTaskDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddShareTaskDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddShareTaskDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddShareTaskDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddShareTaskDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddShareTaskDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None, is_failover=None, parser_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.is_failover = is_failover  # type: bool
        self.parser_id = parser_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class AttachDestinationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachDestinationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachDestinationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachDestinationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachDestinationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None, parser_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class AttachParserDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachParserDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachParserDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachParserDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachParserDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddDataForApiSourceRequest(TeaModel):
    def __init__(self, api_id=None, content_list=None, iot_instance_id=None):
        self.api_id = api_id  # type: str
        self.content_list = content_list  # type: dict[str, any]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDataForApiSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.content_list is not None:
            result['ContentList'] = self.content_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ContentList') is not None:
            self.content_list = m.get('ContentList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchAddDataForApiSourceShrinkRequest(TeaModel):
    def __init__(self, api_id=None, content_list_shrink=None, iot_instance_id=None):
        self.api_id = api_id  # type: str
        self.content_list_shrink = content_list_shrink  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDataForApiSourceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.content_list_shrink is not None:
            result['ContentList'] = self.content_list_shrink
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ContentList') is not None:
            self.content_list_shrink = m.get('ContentList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchAddDataForApiSourceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: dict[str, any]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDataForApiSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddDataForApiSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchAddDataForApiSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchAddDataForApiSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchAddDataForApiSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsRequestDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchAddDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, device=None, group_id=None, iot_instance_id=None):
        self.device = device  # type: list[BatchAddDeviceGroupRelationsRequestDevice]
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchAddDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchAddDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(self, already_related_group_device_count=None, code=None, error_message=None,
                 exceed_ten_group_device_count=None, request_id=None, success=None, success_added_device_count=None, valid_device_count=None):
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.exceed_ten_group_device_count = exceed_ten_group_device_count  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.success_added_device_count = success_added_device_count  # type: int
        self.valid_device_count = valid_device_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.exceed_ten_group_device_count is not None:
            result['ExceedTenGroupDeviceCount'] = self.exceed_ten_group_device_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.success_added_device_count is not None:
            result['SuccessAddedDeviceCount'] = self.success_added_device_count
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ExceedTenGroupDeviceCount') is not None:
            self.exceed_ten_group_device_count = m.get('ExceedTenGroupDeviceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SuccessAddedDeviceCount') is not None:
            self.success_added_device_count = m.get('SuccessAddedDeviceCount')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        return self


class BatchAddDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchAddDeviceGroupRelationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchAddDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(self, client_id=None, device_name=None, product_key=None, sign=None, sign_method=None,
                 timestamp=None):
        self.client_id = client_id  # type: str
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str
        self.sign = sign  # type: str
        self.sign_method = sign_method  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddThingTopoRequestTopoAddItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(self, gw_device_name=None, gw_product_key=None, iot_instance_id=None, topo_add_item=None):
        self.gw_device_name = gw_device_name  # type: str
        self.gw_product_key = gw_product_key  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.topo_add_item = topo_add_item  # type: list[BatchAddThingTopoRequestTopoAddItem]

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchAddThingTopoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        return self


class BatchAddThingTopoResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddThingTopoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchAddThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchAddThingTopoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(self, driver_id=None, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchBindDeviceToEdgeInstanceWithDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchBindDeviceToEdgeInstanceWithDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDevicesIntoProjectRequestDevices(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchBindDevicesIntoProjectRequest(TeaModel):
    def __init__(self, devices=None, iot_instance_id=None, project_id=None):
        self.devices = devices  # type: list[BatchBindDevicesIntoProjectRequestDevices]
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchBindDevicesIntoProjectRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindDevicesIntoProjectResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindDevicesIntoProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchBindDevicesIntoProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchBindDevicesIntoProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindProductsIntoProjectRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_keys = product_keys  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindProductsIntoProjectResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindProductsIntoProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchBindProductsIntoProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchBindProductsIntoProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckDeviceNamesRequestDeviceNameList(TeaModel):
    def __init__(self, device_name=None, device_nickname=None):
        self.device_name = device_name  # type: str
        self.device_nickname = device_nickname  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesRequestDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_nickname is not None:
            result['DeviceNickname'] = self.device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNickname') is not None:
            self.device_nickname = m.get('DeviceNickname')
        return self


class BatchCheckDeviceNamesRequest(TeaModel):
    def __init__(self, device_name=None, device_name_list=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.device_name_list = device_name_list  # type: list[BatchCheckDeviceNamesRequestDeviceNameList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_name_list:
            for k in self.device_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        result['DeviceNameList'] = []
        if self.device_name_list is not None:
            for k in self.device_name_list:
                result['DeviceNameList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        self.device_name_list = []
        if m.get('DeviceNameList') is not None:
            for k in m.get('DeviceNameList'):
                temp_model = BatchCheckDeviceNamesRequestDeviceNameList()
                self.device_name_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList(TeaModel):
    def __init__(self, invalid_device_name=None):
        self.invalid_device_name = invalid_device_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name is not None:
            result['InvalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceName') is not None:
            self.invalid_device_name = m.get('InvalidDeviceName')
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList(TeaModel):
    def __init__(self, invalid_device_nickname=None):
        self.invalid_device_nickname = invalid_device_nickname  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_nickname is not None:
            result['InvalidDeviceNickname'] = self.invalid_device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceNickname') is not None:
            self.invalid_device_nickname = m.get('InvalidDeviceNickname')
        return self


class BatchCheckDeviceNamesResponseBodyData(TeaModel):
    def __init__(self, apply_id=None, invalid_device_name_list=None, invalid_device_nickname_list=None):
        self.apply_id = apply_id  # type: long
        self.invalid_device_name_list = invalid_device_name_list  # type: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList
        self.invalid_device_nickname_list = invalid_device_nickname_list  # type: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList

    def validate(self):
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        if self.invalid_device_nickname_list:
            self.invalid_device_nickname_list.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_nickname_list is not None:
            result['InvalidDeviceNicknameList'] = self.invalid_device_nickname_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceNicknameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList()
            self.invalid_device_nickname_list = temp_model.from_map(m['InvalidDeviceNicknameList'])
        return self


class BatchCheckDeviceNamesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchCheckDeviceNamesResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCheckDeviceNamesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCheckDeviceNamesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCheckDeviceNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckImportDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_name=None, device_secret=None, sn=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.sn = sn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckImportDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.sn is not None:
            result['Sn'] = self.sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        return self


class BatchCheckImportDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchCheckImportDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchCheckImportDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchCheckImportDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchCheckImportDeviceResponseBodyData(TeaModel):
    def __init__(self, invalid_device_name_list=None, invalid_device_secret_list=None, invalid_sn_list=None,
                 repeated_device_name_list=None):
        self.invalid_device_name_list = invalid_device_name_list  # type: list[str]
        self.invalid_device_secret_list = invalid_device_secret_list  # type: list[str]
        self.invalid_sn_list = invalid_sn_list  # type: list[str]
        self.repeated_device_name_list = repeated_device_name_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckImportDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list
        if self.invalid_device_secret_list is not None:
            result['InvalidDeviceSecretList'] = self.invalid_device_secret_list
        if self.invalid_sn_list is not None:
            result['InvalidSnList'] = self.invalid_sn_list
        if self.repeated_device_name_list is not None:
            result['RepeatedDeviceNameList'] = self.repeated_device_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceNameList') is not None:
            self.invalid_device_name_list = m.get('InvalidDeviceNameList')
        if m.get('InvalidDeviceSecretList') is not None:
            self.invalid_device_secret_list = m.get('InvalidDeviceSecretList')
        if m.get('InvalidSnList') is not None:
            self.invalid_sn_list = m.get('InvalidSnList')
        if m.get('RepeatedDeviceNameList') is not None:
            self.repeated_device_name_list = m.get('RepeatedDeviceNameList')
        return self


class BatchCheckImportDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchCheckImportDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckImportDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchCheckImportDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCheckImportDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCheckImportDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCheckImportDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCheckImportDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckVehicleDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_id=None, device_model=None, manufacturer=None):
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.manufacturer = manufacturer  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        return self


class BatchCheckVehicleDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchCheckVehicleDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchCheckVehicleDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchCheckVehicleDeviceResponseBodyData(TeaModel):
    def __init__(self, invalid_device_id_list=None, invalid_device_model_list=None,
                 invalid_manufacturer_list=None, repeated_device_id_list=None):
        self.invalid_device_id_list = invalid_device_id_list  # type: list[str]
        self.invalid_device_model_list = invalid_device_model_list  # type: list[str]
        self.invalid_manufacturer_list = invalid_manufacturer_list  # type: list[str]
        self.repeated_device_id_list = repeated_device_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_id_list is not None:
            result['InvalidDeviceIdList'] = self.invalid_device_id_list
        if self.invalid_device_model_list is not None:
            result['InvalidDeviceModelList'] = self.invalid_device_model_list
        if self.invalid_manufacturer_list is not None:
            result['InvalidManufacturerList'] = self.invalid_manufacturer_list
        if self.repeated_device_id_list is not None:
            result['RepeatedDeviceIdList'] = self.repeated_device_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceIdList') is not None:
            self.invalid_device_id_list = m.get('InvalidDeviceIdList')
        if m.get('InvalidDeviceModelList') is not None:
            self.invalid_device_model_list = m.get('InvalidDeviceModelList')
        if m.get('InvalidManufacturerList') is not None:
            self.invalid_manufacturer_list = m.get('InvalidManufacturerList')
        if m.get('RepeatedDeviceIdList') is not None:
            self.repeated_device_id_list = m.get('RepeatedDeviceIdList')
        return self


class BatchCheckVehicleDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchCheckVehicleDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchCheckVehicleDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCheckVehicleDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCheckVehicleDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCheckVehicleDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchClearEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchClearEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchClearEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateSoundCodeLabelRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, schedule_code=None, total=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class BatchCreateSoundCodeLabelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateSoundCodeLabelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCreateSoundCodeLabelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateSoundCodeLabelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateSoundCodeLabelWithLabelsRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, labels=None, schedule_code=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.labels = labels  # type: list[str]
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelWithLabelsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class BatchCreateSoundCodeLabelWithLabelsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelWithLabelsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateSoundCodeLabelWithLabelsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCreateSoundCodeLabelWithLabelsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelWithLabelsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateSoundCodeLabelWithLabelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsRequestDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchDeleteDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, device=None, group_id=None, iot_instance_id=None):
        self.device = device  # type: list[BatchDeleteDeviceGroupRelationsRequestDevice]
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchDeleteDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchDeleteDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(self, already_related_group_device_count=None, code=None, error_message=None, request_id=None,
                 success=None, success_device_count=None, valid_device_count=None):
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.success_device_count = success_device_count  # type: int
        self.valid_device_count = valid_device_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.success_device_count is not None:
            result['SuccessDeviceCount'] = self.success_device_count
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SuccessDeviceCount') is not None:
            self.success_device_count = m.get('SuccessDeviceCount')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        return self


class BatchDeleteDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchDeleteDeviceGroupRelationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, channel_ids=None, driver_id=None, instance_id=None, iot_instance_id=None):
        self.channel_ids = channel_ids  # type: list[str]
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchDeleteEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchDeleteEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(self, iot_ids=None, iot_instance_id=None):
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetDeviceBindStatusResponseBodyData(TeaModel):
    def __init__(self, bind_status=None, instance_id=None, iot_id=None):
        self.bind_status = bind_status  # type: int
        self.instance_id = instance_id  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceBindStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[BatchGetDeviceBindStatusResponseBodyData]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetDeviceBindStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceBindStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceStateRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.iot_id = iot_id  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus(TeaModel):
    def __init__(self, as_address=None, device_id=None, device_name=None, iot_id=None, last_online_time=None,
                 status=None):
        self.as_address = as_address  # type: str
        self.device_id = device_id  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.last_online_time = last_online_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_address is not None:
            result['AsAddress'] = self.as_address
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsAddress') is not None:
            self.as_address = m.get('AsAddress')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusList(TeaModel):
    def __init__(self, device_status=None):
        self.device_status = device_status  # type: list[BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus]

    def validate(self):
        if self.device_status:
            for k in self.device_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseBodyDeviceStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceStatus'] = []
        if self.device_status is not None:
            for k in self.device_status:
                result['DeviceStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_status = []
        if m.get('DeviceStatus') is not None:
            for k in m.get('DeviceStatus'):
                temp_model = BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus()
                self.device_status.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateResponseBody(TeaModel):
    def __init__(self, code=None, device_status_list=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.device_status_list = device_status_list  # type: BatchGetDeviceStateResponseBodyDeviceStatusList
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.device_status_list:
            self.device_status_list.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.device_status_list is not None:
            result['DeviceStatusList'] = self.device_status_list.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DeviceStatusList') is not None:
            temp_model = BatchGetDeviceStateResponseBodyDeviceStatusList()
            self.device_status_list = temp_model.from_map(m['DeviceStatusList'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceStateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetDeviceStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(self, driver_ids=None, iot_instance_id=None):
        self.driver_ids = driver_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeDriverResponseBodyDriverList(TeaModel):
    def __init__(self, cpu_arch=None, driver_id=None, driver_name=None, driver_protocol=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, is_built_in=None, runtime=None, type=None):
        self.cpu_arch = cpu_arch  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_name = driver_name  # type: str
        self.driver_protocol = driver_protocol  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.is_built_in = is_built_in  # type: bool
        self.runtime = runtime  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponseBodyDriverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BatchGetEdgeDriverResponseBody(TeaModel):
    def __init__(self, code=None, driver_list=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.driver_list = driver_list  # type: list[BatchGetEdgeDriverResponseBodyDriverList]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseBodyDriverList()
                self.driver_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, channel_ids=None, driver_id=None, instance_id=None, iot_instance_id=None):
        self.channel_ids = channel_ids  # type: list[str]
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig(TeaModel):
    def __init__(self, config_id=None, content=None, format=None, key=None):
        self.config_id = config_id  # type: str
        self.content = content  # type: str
        self.format = format  # type: str
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig]

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannel(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, config_list=None):
        self.channel_id = channel_id  # type: str
        self.channel_name = channel_name  # type: str
        self.config_list = config_list  # type: BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList

    def validate(self):
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyDataChannel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseBodyData(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[BatchGetEdgeInstanceChannelResponseBodyDataChannel]

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchGetEdgeInstanceChannelResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, driver_id=None, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, iot_id=None):
        self.channel_id = channel_id  # type: str
        self.channel_name = channel_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(self, code=None, device_channel_list=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.device_channel_list = device_channel_list  # type: list[BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetEdgeInstanceDeviceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig(TeaModel):
    def __init__(self, content=None, format=None):
        self.content = content  # type: str
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList(TeaModel):
    def __init__(self, config=None, iot_id=None):
        self.config = config  # type: BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig
        self.iot_id = iot_id  # type: str

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, code=None, device_config_list=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.device_config_list = device_config_list  # type: list[BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList(TeaModel):
    def __init__(self, driver_id=None, iot_id=None):
        self.driver_id = driver_id  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBody(TeaModel):
    def __init__(self, code=None, device_driver_list=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.device_driver_list = device_driver_list  # type: list[BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetEdgeInstanceDeviceDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, driver_ids=None, instance_id=None, iot_instance_id=None):
        self.driver_ids = driver_ids  # type: list[str]
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList(TeaModel):
    def __init__(self, config_id=None, content=None, format=None, key=None):
        self.config_id = config_id  # type: str
        self.content = content  # type: str
        self.format = format  # type: str
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList(TeaModel):
    def __init__(self, config_list=None, driver_id=None):
        self.config_list = config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList]
        self.driver_id = driver_id  # type: str

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(self, code=None, driver_config_list=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.driver_config_list = driver_config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetEdgeInstanceDriverConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchImportDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_name=None, device_secret=None, sn=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.sn = sn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.sn is not None:
            result['Sn'] = self.sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        return self


class BatchImportDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchImportDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchImportDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchImportDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchImportDeviceResponseBodyDataInvalidDeviceNameList(TeaModel):
    def __init__(self, invalid_device_name=None):
        self.invalid_device_name = invalid_device_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportDeviceResponseBodyDataInvalidDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name is not None:
            result['invalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('invalidDeviceName') is not None:
            self.invalid_device_name = m.get('invalidDeviceName')
        return self


class BatchImportDeviceResponseBodyDataInvalidDeviceSecretList(TeaModel):
    def __init__(self, invalid_device_secret=None):
        self.invalid_device_secret = invalid_device_secret  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportDeviceResponseBodyDataInvalidDeviceSecretList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_secret is not None:
            result['invalidDeviceSecret'] = self.invalid_device_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('invalidDeviceSecret') is not None:
            self.invalid_device_secret = m.get('invalidDeviceSecret')
        return self


class BatchImportDeviceResponseBodyDataInvalidSnList(TeaModel):
    def __init__(self, invalid_sn=None):
        self.invalid_sn = invalid_sn  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportDeviceResponseBodyDataInvalidSnList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_sn is not None:
            result['invalidSn'] = self.invalid_sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('invalidSn') is not None:
            self.invalid_sn = m.get('invalidSn')
        return self


class BatchImportDeviceResponseBodyDataRepeatedDeviceNameList(TeaModel):
    def __init__(self, repeated_device_name=None):
        self.repeated_device_name = repeated_device_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportDeviceResponseBodyDataRepeatedDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.repeated_device_name is not None:
            result['repeatedDeviceName'] = self.repeated_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('repeatedDeviceName') is not None:
            self.repeated_device_name = m.get('repeatedDeviceName')
        return self


class BatchImportDeviceResponseBodyData(TeaModel):
    def __init__(self, apply_id=None, invalid_device_name_list=None, invalid_device_secret_list=None,
                 invalid_sn_list=None, repeated_device_name_list=None):
        self.apply_id = apply_id  # type: long
        self.invalid_device_name_list = invalid_device_name_list  # type: BatchImportDeviceResponseBodyDataInvalidDeviceNameList
        self.invalid_device_secret_list = invalid_device_secret_list  # type: BatchImportDeviceResponseBodyDataInvalidDeviceSecretList
        self.invalid_sn_list = invalid_sn_list  # type: BatchImportDeviceResponseBodyDataInvalidSnList
        self.repeated_device_name_list = repeated_device_name_list  # type: BatchImportDeviceResponseBodyDataRepeatedDeviceNameList

    def validate(self):
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        if self.invalid_device_secret_list:
            self.invalid_device_secret_list.validate()
        if self.invalid_sn_list:
            self.invalid_sn_list.validate()
        if self.repeated_device_name_list:
            self.repeated_device_name_list.validate()

    def to_map(self):
        _map = super(BatchImportDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_secret_list is not None:
            result['InvalidDeviceSecretList'] = self.invalid_device_secret_list.to_map()
        if self.invalid_sn_list is not None:
            result['InvalidSnList'] = self.invalid_sn_list.to_map()
        if self.repeated_device_name_list is not None:
            result['RepeatedDeviceNameList'] = self.repeated_device_name_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchImportDeviceResponseBodyDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceSecretList') is not None:
            temp_model = BatchImportDeviceResponseBodyDataInvalidDeviceSecretList()
            self.invalid_device_secret_list = temp_model.from_map(m['InvalidDeviceSecretList'])
        if m.get('InvalidSnList') is not None:
            temp_model = BatchImportDeviceResponseBodyDataInvalidSnList()
            self.invalid_sn_list = temp_model.from_map(m['InvalidSnList'])
        if m.get('RepeatedDeviceNameList') is not None:
            temp_model = BatchImportDeviceResponseBodyDataRepeatedDeviceNameList()
            self.repeated_device_name_list = temp_model.from_map(m['RepeatedDeviceNameList'])
        return self


class BatchImportDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchImportDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchImportDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchImportDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchImportDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchImportDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchImportDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchImportDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchImportVehicleDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_id=None, device_model=None, manufacturer=None):
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.manufacturer = manufacturer  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportVehicleDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        return self


class BatchImportVehicleDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchImportVehicleDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchImportVehicleDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchImportVehicleDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchImportVehicleDeviceResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchImportVehicleDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchImportVehicleDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchImportVehicleDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchImportVehicleDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchImportVehicleDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchImportVehicleDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchImportVehicleDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchImportVehicleDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchImportVehicleDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, message_content=None, product_key=None, qos=None,
                 topic_short_name=None):
        self.device_name = device_name  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.message_content = message_content  # type: str
        self.product_key = product_key  # type: str
        self.qos = qos  # type: int
        self.topic_short_name = topic_short_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchPubRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        return self


class BatchPubResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchPubResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchPubResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchPubResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchPubResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchPubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchQueryDeviceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchQueryDeviceDetailResponseBodyDataData(TeaModel):
    def __init__(self, device_name=None, device_secret=None, firmware_version=None, gmt_active=None,
                 gmt_create=None, iot_id=None, nickname=None, node_type=None, product_key=None, product_name=None, region=None,
                 status=None, utc_active=None, utc_create=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.firmware_version = firmware_version  # type: str
        self.gmt_active = gmt_active  # type: str
        self.gmt_create = gmt_create  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str
        self.node_type = node_type  # type: int
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.region = region  # type: str
        self.status = status  # type: str
        self.utc_active = utc_active  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.region is not None:
            result['Region'] = self.region
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class BatchQueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[BatchQueryDeviceDetailResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchQueryDeviceDetailResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchQueryDeviceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchQueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceRequest(TeaModel):
    def __init__(self, count=None, iot_instance_id=None, product_key=None):
        self.count = count  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchRegisterDeviceResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchRegisterDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchRegisterDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchRegisterDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceWithApplyIdRequest(TeaModel):
    def __init__(self, apply_id=None, iot_instance_id=None, product_key=None):
        self.apply_id = apply_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchRegisterDeviceWithApplyIdResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BatchRegisterDeviceWithApplyIdResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchRegisterDeviceWithApplyIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchRegisterDeviceWithApplyIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, channel_id=None, driver_id=None, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.channel_id = channel_id  # type: str
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchSetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetEdgeInstanceDeviceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(self, content=None, iot_id=None):
        self.content = content  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, device_configs=None, instance_id=None, iot_instance_id=None):
        self.device_configs = device_configs  # type: list[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs]
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchSetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchUnbindDeviceFromEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUnbindDeviceFromEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindProjectDevicesRequestDevices(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchUnbindProjectDevicesRequest(TeaModel):
    def __init__(self, devices=None, iot_instance_id=None, project_id=None):
        self.devices = devices  # type: list[BatchUnbindProjectDevicesRequestDevices]
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchUnbindProjectDevicesRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindProjectDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchUnbindProjectDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUnbindProjectDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindProjectProductsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_keys = product_keys  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectProductsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectProductsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectProductsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindProjectProductsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchUnbindProjectProductsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUnbindProjectProductsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUnbindProjectProductsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(self, device_name=None, iot_id=None, nickname=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameRequestDeviceNicknameInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(self, device_nickname_info=None, iot_instance_id=None):
        self.device_nickname_info = device_nickname_info  # type: list[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchUpdateDeviceNicknameResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchUpdateDeviceNicknameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUpdateDeviceNicknameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(self, application_id=None, application_version=None, instance_id=None, iot_instance_id=None):
        self.application_id = application_id  # type: str
        self.application_version = application_version  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BindApplicationToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindApplicationToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindApplicationToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, instance_id=None, iot_instance_id=None, order_id=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.order_id = order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindDriverToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindDriverToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(self, device_name=None, instance_id=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BindGatewayToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindGatewayToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindGatewayToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindLicenseDeviceRequest(TeaModel):
    def __init__(self, device_name_list=None, iot_id_list=None, iot_instance_id=None, license_code=None,
                 product_key=None):
        self.device_name_list = device_name_list  # type: list[str]
        self.iot_id_list = iot_id_list  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.license_code = license_code  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindLicenseDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name_list is not None:
            result['DeviceNameList'] = self.device_name_list
        if self.iot_id_list is not None:
            result['IotIdList'] = self.iot_id_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.license_code is not None:
            result['LicenseCode'] = self.license_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceNameList') is not None:
            self.device_name_list = m.get('DeviceNameList')
        if m.get('IotIdList') is not None:
            self.iot_id_list = m.get('IotIdList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LicenseCode') is not None:
            self.license_code = m.get('LicenseCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BindLicenseDeviceResponseBodyData(TeaModel):
    def __init__(self, check_progress_id=None, fail_sum=None, progress=None, result_csv_file=None, success_sum=None):
        self.check_progress_id = check_progress_id  # type: str
        self.fail_sum = fail_sum  # type: long
        self.progress = progress  # type: int
        self.result_csv_file = result_csv_file  # type: str
        self.success_sum = success_sum  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindLicenseDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_progress_id is not None:
            result['CheckProgressId'] = self.check_progress_id
        if self.fail_sum is not None:
            result['FailSum'] = self.fail_sum
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result_csv_file is not None:
            result['ResultCsvFile'] = self.result_csv_file
        if self.success_sum is not None:
            result['SuccessSum'] = self.success_sum
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckProgressId') is not None:
            self.check_progress_id = m.get('CheckProgressId')
        if m.get('FailSum') is not None:
            self.fail_sum = m.get('FailSum')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ResultCsvFile') is not None:
            self.result_csv_file = m.get('ResultCsvFile')
        if m.get('SuccessSum') is not None:
            self.success_sum = m.get('SuccessSum')
        return self


class BindLicenseDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: BindLicenseDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BindLicenseDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BindLicenseDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindLicenseDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindLicenseDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindLicenseDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindLicenseDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindLicenseProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, license_code=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.license_code = license_code  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindLicenseProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.license_code is not None:
            result['LicenseCode'] = self.license_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LicenseCode') is not None:
            self.license_code = m.get('LicenseCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BindLicenseProductResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindLicenseProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindLicenseProductResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindLicenseProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindLicenseProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindLicenseProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, role_arn=None, role_name=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.role_arn = role_arn  # type: str
        self.role_name = role_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindRoleToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindRoleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, rule_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindSceneRuleToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindSceneRuleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTAStrategyByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTAStrategyByJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelOTAStrategyByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOTAStrategyByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOTAStrategyByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(self, device_name=None, firmware_id=None, iot_instance_id=None, job_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CancelOTATaskByDeviceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelOTATaskByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOTATaskByDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(self, cancel_in_progress_task=None, cancel_notified_task=None, cancel_queued_task=None,
                 cancel_scheduled_task=None, cancel_unconfirmed_task=None, iot_instance_id=None, job_id=None):
        self.cancel_in_progress_task = cancel_in_progress_task  # type: bool
        self.cancel_notified_task = cancel_notified_task  # type: bool
        self.cancel_queued_task = cancel_queued_task  # type: bool
        self.cancel_scheduled_task = cancel_scheduled_task  # type: bool
        self.cancel_unconfirmed_task = cancel_unconfirmed_task  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_unconfirmed_task is not None:
            result['CancelUnconfirmedTask'] = self.cancel_unconfirmed_task
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelUnconfirmedTask') is not None:
            self.cancel_unconfirmed_task = m.get('CancelUnconfirmedTask')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTATaskByJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelOTATaskByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOTATaskByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelReleaseProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelReleaseProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CancelReleaseProductResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelReleaseProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelReleaseProductResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelReleaseProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelReleaseProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelReleaseProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckBindLicenseDeviceProgressRequest(TeaModel):
    def __init__(self, check_progress_id=None, iot_instance_id=None, license_code=None, product_key=None):
        self.check_progress_id = check_progress_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.license_code = license_code  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_progress_id is not None:
            result['CheckProgressId'] = self.check_progress_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.license_code is not None:
            result['LicenseCode'] = self.license_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckProgressId') is not None:
            self.check_progress_id = m.get('CheckProgressId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LicenseCode') is not None:
            self.license_code = m.get('LicenseCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CheckBindLicenseDeviceProgressResponseBodyData(TeaModel):
    def __init__(self, fail_sum=None, progress=None, result_csv_file=None, success_sum=None):
        self.fail_sum = fail_sum  # type: long
        self.progress = progress  # type: int
        self.result_csv_file = result_csv_file  # type: str
        self.success_sum = success_sum  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_sum is not None:
            result['FailSum'] = self.fail_sum
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result_csv_file is not None:
            result['ResultCsvFile'] = self.result_csv_file
        if self.success_sum is not None:
            result['SuccessSum'] = self.success_sum
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailSum') is not None:
            self.fail_sum = m.get('FailSum')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ResultCsvFile') is not None:
            self.result_csv_file = m.get('ResultCsvFile')
        if m.get('SuccessSum') is not None:
            self.success_sum = m.get('SuccessSum')
        return self


class CheckBindLicenseDeviceProgressResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CheckBindLicenseDeviceProgressResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CheckBindLicenseDeviceProgressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckBindLicenseDeviceProgressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckBindLicenseDeviceProgressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckBindLicenseDeviceProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearDeviceDesiredPropertyRequest(TeaModel):
    def __init__(self, device_name=None, identifies=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.identifies = identifies  # type: list[str]
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifies is not None:
            result['Identifies'] = self.identifies
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifies') is not None:
            self.identifies = m.get('Identifies')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ClearDeviceDesiredPropertyResponseBodyData(TeaModel):
    def __init__(self, versions=None):
        self.versions = versions  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class ClearDeviceDesiredPropertyResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ClearDeviceDesiredPropertyResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ClearDeviceDesiredPropertyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ClearDeviceDesiredPropertyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ClearDeviceDesiredPropertyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearDeviceDesiredPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, driver_id=None, instance_id=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class ClearEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ClearEdgeInstanceDriverConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseDeviceTunnelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, tunnel_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.tunnel_id = tunnel_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.tunnel_id is not None:
            result['TunnelId'] = self.tunnel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TunnelId') is not None:
            self.tunnel_id = m.get('TunnelId')
        return self


class CloseDeviceTunnelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloseDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CloseDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloseDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloseDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CloseEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CloseEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloseEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmOTATaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.task_id = task_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmOTATaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ConfirmOTATaskResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmOTATaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ConfirmOTATaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConfirmOTATaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfirmOTATaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmOTATaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, source_model_version=None,
                 source_product_key=None, target_product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.source_model_version = source_model_version  # type: str
        self.source_product_key = source_product_key  # type: str
        self.target_product_key = target_product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        return self


class CopyThingModelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopyThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CountSpeechBroadcastHourRequest(TeaModel):
    def __init__(self, iot_instance_id=None, query_date_time_hour=None, share_task_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.query_date_time_hour = query_date_time_hour  # type: str
        self.share_task_code = share_task_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CountSpeechBroadcastHourRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.query_date_time_hour is not None:
            result['QueryDateTimeHour'] = self.query_date_time_hour
        if self.share_task_code is not None:
            result['ShareTaskCode'] = self.share_task_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('QueryDateTimeHour') is not None:
            self.query_date_time_hour = m.get('QueryDateTimeHour')
        if m.get('ShareTaskCode') is not None:
            self.share_task_code = m.get('ShareTaskCode')
        return self


class CountSpeechBroadcastHourResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CountSpeechBroadcastHourResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CountSpeechBroadcastHourResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CountSpeechBroadcastHourResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CountSpeechBroadcastHourResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CountSpeechBroadcastHourResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(self, group_name=None, iot_instance_id=None):
        self.group_name = group_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateConsumerGroupResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, group_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.group_id = group_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateConsumerGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateConsumerGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = consumer_group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateConsumerGroupSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(self, desc=None, example=None, name=None, required=None, type=None):
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.name = name  # type: str
        self.required = required  # type: bool
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceRequestRequestParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(self, desc=None, example=None, name=None, required=None, type=None):
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.name = name  # type: str
        self.required = required  # type: bool
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceRequestResponseParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(self, api_path=None, desc=None, display_name=None, iot_instance_id=None, origin_sql=None,
                 request_param=None, response_param=None, template_sql=None):
        self.api_path = api_path  # type: str
        self.desc = desc  # type: str
        self.display_name = display_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.origin_sql = origin_sql  # type: str
        self.request_param = request_param  # type: list[CreateDataAPIServiceRequestRequestParam]
        self.response_param = response_param  # type: list[CreateDataAPIServiceRequestResponseParam]
        self.template_sql = template_sql  # type: str

    def validate(self):
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        return self


class CreateDataAPIServiceResponseBodyData(TeaModel):
    def __init__(self, api_srn=None, create_time=None, last_update_time=None):
        self.api_srn = api_srn  # type: str
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateDataAPIServiceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDataAPIServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataSourceItemRequest(TeaModel):
    def __init__(self, data_source_id=None, device_name=None, iot_instance_id=None, product_key=None,
                 scope_type=None, topic=None):
        self.data_source_id = data_source_id  # type: long
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.scope_type = scope_type  # type: str
        self.topic = topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataSourceItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateDataSourceItemResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataSourceItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataSourceItemResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDataSourceItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataSourceItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDataSourceItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDestinationRequest(TeaModel):
    def __init__(self, configuration=None, description=None, iot_instance_id=None, name=None, type=None):
        self.configuration = configuration  # type: str
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDestinationResponseBodyDestination(TeaModel):
    def __init__(self, configuration=None, destination_id=None, is_failover=None, name=None, type=None,
                 utc_created=None):
        self.configuration = configuration  # type: str
        self.destination_id = destination_id  # type: long
        self.is_failover = is_failover  # type: bool
        self.name = name  # type: str
        self.type = type  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDestinationResponseBodyDestination, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class CreateDestinationResponseBody(TeaModel):
    def __init__(self, code=None, destination=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.destination = destination  # type: CreateDestinationResponseBodyDestination
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.destination:
            self.destination.validate()

    def to_map(self):
        _map = super(CreateDestinationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.destination is not None:
            result['Destination'] = self.destination.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Destination') is not None:
            temp_model = CreateDestinationResponseBodyDestination()
            self.destination = temp_model.from_map(m['Destination'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDestinationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDestinationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDestinationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceDistributeJobRequestTargetInstanceConfig(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = target_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceDistributeJobRequestTargetInstanceConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateDeviceDistributeJobRequest(TeaModel):
    def __init__(self, device_name=None, product_key=None, source_instance_id=None, strategy=None,
                 target_aliyun_id=None, target_instance_config=None, target_uid=None):
        self.device_name = device_name  # type: list[str]
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.strategy = strategy  # type: int
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_config = target_instance_config  # type: list[CreateDeviceDistributeJobRequestTargetInstanceConfig]
        self.target_uid = target_uid  # type: str

    def validate(self):
        if self.target_instance_config:
            for k in self.target_instance_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        result['TargetInstanceConfig'] = []
        if self.target_instance_config is not None:
            for k in self.target_instance_config:
                result['TargetInstanceConfig'].append(k.to_map() if k else None)
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        self.target_instance_config = []
        if m.get('TargetInstanceConfig') is not None:
            for k in m.get('TargetInstanceConfig'):
                temp_model = CreateDeviceDistributeJobRequestTargetInstanceConfig()
                self.target_instance_config.append(temp_model.from_map(k))
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        return self


class CreateDeviceDistributeJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, job_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDeviceDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceDynamicGroupRequest(TeaModel):
    def __init__(self, dynamic_group_expression=None, group_desc=None, group_name=None, iot_instance_id=None):
        self.dynamic_group_expression = dynamic_group_expression  # type: str
        self.group_desc = group_desc  # type: str
        self.group_name = group_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_group_expression is not None:
            result['DynamicGroupExpression'] = self.dynamic_group_expression
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicGroupExpression') is not None:
            self.dynamic_group_expression = m.get('DynamicGroupExpression')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDeviceDynamicGroupResponseBodyData(TeaModel):
    def __init__(self, dynamic_group_expression=None, group_desc=None, group_id=None, group_name=None,
                 utc_create=None):
        self.dynamic_group_expression = dynamic_group_expression  # type: str
        self.group_desc = group_desc  # type: str
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_group_expression is not None:
            result['DynamicGroupExpression'] = self.dynamic_group_expression
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicGroupExpression') is not None:
            self.dynamic_group_expression = m.get('DynamicGroupExpression')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateDeviceDynamicGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateDeviceDynamicGroupResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDeviceDynamicGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceDynamicGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDeviceDynamicGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeviceDynamicGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceGroupRequest(TeaModel):
    def __init__(self, group_desc=None, group_name=None, iot_instance_id=None, super_group_id=None):
        self.group_desc = group_desc  # type: str
        self.group_name = group_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.super_group_id = super_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        return self


class CreateDeviceGroupResponseBodyData(TeaModel):
    def __init__(self, group_desc=None, group_id=None, group_name=None, utc_create=None):
        self.group_desc = group_desc  # type: str
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateDeviceGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateDeviceGroupResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDeviceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDeviceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceTunnelRequest(TeaModel):
    def __init__(self, description=None, device_name=None, iot_id=None, iot_instance_id=None, product_key=None,
                 udi=None):
        self.description = description  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.udi = udi  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.udi is not None:
            result['Udi'] = self.udi
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Udi') is not None:
            self.udi = m.get('Udi')
        return self


class CreateDeviceTunnelResponseBodyData(TeaModel):
    def __init__(self, source_access_token=None, source_uri=None, tunnel_id=None):
        self.source_access_token = source_access_token  # type: str
        self.source_uri = source_uri  # type: str
        self.tunnel_id = tunnel_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceTunnelResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_access_token is not None:
            result['SourceAccessToken'] = self.source_access_token
        if self.source_uri is not None:
            result['SourceURI'] = self.source_uri
        if self.tunnel_id is not None:
            result['TunnelId'] = self.tunnel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceAccessToken') is not None:
            self.source_access_token = m.get('SourceAccessToken')
        if m.get('SourceURI') is not None:
            self.source_uri = m.get('SourceURI')
        if m.get('TunnelId') is not None:
            self.tunnel_id = m.get('TunnelId')
        return self


class CreateDeviceTunnelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateDeviceTunnelResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDeviceTunnelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDownloadDataJobRequest(TeaModel):
    def __init__(self, download_data_type=None, end_time=None, file_config=None, iot_instance_id=None,
                 start_time=None, table_name=None):
        self.download_data_type = download_data_type  # type: str
        self.end_time = end_time  # type: long
        self.file_config = file_config  # type: dict[str, any]
        self.iot_instance_id = iot_instance_id  # type: str
        self.start_time = start_time  # type: long
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDownloadDataJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_data_type is not None:
            result['DownloadDataType'] = self.download_data_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.file_config is not None:
            result['FileConfig'] = self.file_config
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownloadDataType') is not None:
            self.download_data_type = m.get('DownloadDataType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FileConfig') is not None:
            self.file_config = m.get('FileConfig')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateDownloadDataJobShrinkRequest(TeaModel):
    def __init__(self, download_data_type=None, end_time=None, file_config_shrink=None, iot_instance_id=None,
                 start_time=None, table_name=None):
        self.download_data_type = download_data_type  # type: str
        self.end_time = end_time  # type: long
        self.file_config_shrink = file_config_shrink  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.start_time = start_time  # type: long
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDownloadDataJobShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_data_type is not None:
            result['DownloadDataType'] = self.download_data_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.file_config_shrink is not None:
            result['FileConfig'] = self.file_config_shrink
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownloadDataType') is not None:
            self.download_data_type = m.get('DownloadDataType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FileConfig') is not None:
            self.file_config_shrink = m.get('FileConfig')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateDownloadDataJobResponseBodyData(TeaModel):
    def __init__(self, async_execute=None, csv_file_name=None, csv_url=None, long_job_id=None, status=None):
        self.async_execute = async_execute  # type: bool
        self.csv_file_name = csv_file_name  # type: str
        self.csv_url = csv_url  # type: str
        self.long_job_id = long_job_id  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_execute is not None:
            result['AsyncExecute'] = self.async_execute
        if self.csv_file_name is not None:
            result['CsvFileName'] = self.csv_file_name
        if self.csv_url is not None:
            result['CsvUrl'] = self.csv_url
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsyncExecute') is not None:
            self.async_execute = m.get('AsyncExecute')
        if m.get('CsvFileName') is not None:
            self.csv_file_name = m.get('CsvFileName')
        if m.get('CsvUrl') is not None:
            self.csv_url = m.get('CsvUrl')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDownloadDataJobResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateDownloadDataJobResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDownloadDataJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDownloadDataJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDownloadDataJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDownloadDataJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDownloadDataJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(self, cpu_arch=None, driver_name=None, driver_protocol=None, iot_instance_id=None,
                 is_built_in=None, runtime=None):
        self.cpu_arch = cpu_arch  # type: str
        self.driver_name = driver_name  # type: str
        self.driver_protocol = driver_protocol  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.is_built_in = is_built_in  # type: bool
        self.runtime = runtime  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        return self


class CreateEdgeDriverResponseBody(TeaModel):
    def __init__(self, code=None, driver_id=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.driver_id = driver_id  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(self, argument=None, config_check_rule=None, container_config=None, description=None,
                 driver_config=None, driver_id=None, driver_version=None, edge_version=None, iot_instance_id=None,
                 source_config=None):
        self.argument = argument  # type: str
        self.config_check_rule = config_check_rule  # type: str
        self.container_config = container_config  # type: str
        self.description = description  # type: str
        self.driver_config = driver_config  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.edge_version = edge_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.source_config = source_config  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.argument is not None:
            result['Argument'] = self.argument
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.description is not None:
            result['Description'] = self.description
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        return self


class CreateEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, name=None, spec=None, tags=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.spec = spec  # type: int
        self.tags = tags  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class CreateEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, instance_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.instance_id = instance_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(self, content=None, format=None, key=None):
        self.content = content  # type: str
        self.format = format  # type: str
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelRequestConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, channel_name=None, configs=None, driver_id=None, instance_id=None, iot_instance_id=None):
        self.channel_name = channel_name  # type: str
        self.configs = configs  # type: list[CreateEdgeInstanceChannelRequestConfigs]
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, type=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, code=None, deployment_id=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.deployment_id = deployment_id  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, name=None, source_data=None, source_type=None,
                 target_data=None, target_iot_hub_qos=None, target_type=None, topic_filter=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.source_data = source_data  # type: str
        self.source_type = source_type  # type: str
        self.target_data = target_data  # type: str
        self.target_iot_hub_qos = target_iot_hub_qos  # type: int
        self.target_type = target_type  # type: str
        self.topic_filter = topic_filter  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.target_iot_hub_qos is not None:
            result['TargetIotHubQos'] = self.target_iot_hub_qos
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('TargetIotHubQos') is not None:
            self.target_iot_hub_qos = m.get('TargetIotHubQos')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        return self


class CreateEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, route_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.route_id = route_id  # type: long
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeInstanceMessageRoutingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(self, file_name=None, instance_id=None, iot_instance_id=None, resource_id=None,
                 resource_version=None, type=None):
        self.file_name = file_name  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_version = resource_version  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeOssPreSignedAddressResponseBodyData(TeaModel):
    def __init__(self, oss_address=None, oss_pre_signed_address=None):
        self.oss_address = oss_address  # type: str
        self.oss_pre_signed_address = oss_pre_signed_address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        return self


class CreateEdgeOssPreSignedAddressResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateEdgeOssPreSignedAddressResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEdgeOssPreSignedAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, job_document=None, job_file=None, job_name=None,
                 rollout_config=None, scheduled_time=None, target_config=None, timeout_config=None, type=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_document = job_document  # type: str
        self.job_file = job_file  # type: dict[str, any]
        self.job_name = job_name  # type: str
        self.rollout_config = rollout_config  # type: dict[str, any]
        self.scheduled_time = scheduled_time  # type: long
        self.target_config = target_config  # type: dict[str, any]
        self.timeout_config = timeout_config  # type: dict[str, any]
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateJobShrinkRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, job_document=None, job_file_shrink=None,
                 job_name=None, rollout_config_shrink=None, scheduled_time=None, target_config_shrink=None,
                 timeout_config_shrink=None, type=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_document = job_document  # type: str
        self.job_file_shrink = job_file_shrink  # type: str
        self.job_name = job_name  # type: str
        self.rollout_config_shrink = rollout_config_shrink  # type: str
        self.scheduled_time = scheduled_time  # type: long
        self.target_config_shrink = target_config_shrink  # type: str
        self.timeout_config_shrink = timeout_config_shrink  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJobShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.job_file_shrink is not None:
            result['JobFile'] = self.job_file_shrink
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        if self.target_config_shrink is not None:
            result['TargetConfig'] = self.target_config_shrink
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('JobFile') is not None:
            self.job_file_shrink = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        if m.get('TargetConfig') is not None:
            self.target_config_shrink = m.get('TargetConfig')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, job_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(self, dev_eui=None, pin_code=None):
        self.dev_eui = dev_eui  # type: str
        self.pin_code = pin_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLoRaNodesTaskRequestDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(self, device_info=None, iot_instance_id=None, product_key=None):
        self.device_info = device_info  # type: list[CreateLoRaNodesTaskRequestDeviceInfo]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateLoRaNodesTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateLoRaNodesTaskResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, task_id=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLoRaNodesTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLoRaNodesTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLoRaNodesTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLoRaNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(self, download_protocol=None, dynamic_mode=None, firmware_id=None, group_id=None, group_type=None,
                 iot_instance_id=None, maximum_per_minute=None, multi_module_mode=None, need_confirm=None, need_push=None,
                 overwrite_mode=None, product_key=None, retry_count=None, retry_interval=None, src_version=None, tag=None,
                 timeout_in_minutes=None):
        self.download_protocol = download_protocol  # type: str
        self.dynamic_mode = dynamic_mode  # type: int
        self.firmware_id = firmware_id  # type: str
        self.group_id = group_id  # type: str
        self.group_type = group_type  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.multi_module_mode = multi_module_mode  # type: bool
        self.need_confirm = need_confirm  # type: bool
        self.need_push = need_push  # type: bool
        self.overwrite_mode = overwrite_mode  # type: int
        self.product_key = product_key  # type: str
        self.retry_count = retry_count  # type: int
        self.retry_interval = retry_interval  # type: int
        self.src_version = src_version  # type: list[str]
        self.tag = tag  # type: list[CreateOTADynamicUpgradeJobRequestTag]
        self.timeout_in_minutes = timeout_in_minutes  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_protocol is not None:
            result['DownloadProtocol'] = self.download_protocol
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.multi_module_mode is not None:
            result['MultiModuleMode'] = self.multi_module_mode
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownloadProtocol') is not None:
            self.download_protocol = m.get('DownloadProtocol')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('MultiModuleMode') is not None:
            self.multi_module_mode = m.get('MultiModuleMode')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        return self


class CreateOTADynamicUpgradeJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateOTADynamicUpgradeJobResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOTADynamicUpgradeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAFirmwareRequestMultiFiles(TeaModel):
    def __init__(self, file_md_5=None, name=None, sign_value=None, size=None, url=None):
        self.file_md_5 = file_md_5  # type: str
        self.name = name  # type: str
        self.sign_value = sign_value  # type: str
        self.size = size  # type: int
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAFirmwareRequestMultiFiles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_md_5 is not None:
            result['FileMd5'] = self.file_md_5
        if self.name is not None:
            result['Name'] = self.name
        if self.sign_value is not None:
            result['SignValue'] = self.sign_value
        if self.size is not None:
            result['Size'] = self.size
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileMd5') is not None:
            self.file_md_5 = m.get('FileMd5')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SignValue') is not None:
            self.sign_value = m.get('SignValue')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(self, dest_version=None, firmware_desc=None, firmware_name=None, firmware_sign=None,
                 firmware_size=None, firmware_url=None, iot_instance_id=None, module_name=None, multi_files=None,
                 need_to_verify=None, product_key=None, sign_method=None, src_version=None, type=None, udi=None):
        self.dest_version = dest_version  # type: str
        self.firmware_desc = firmware_desc  # type: str
        self.firmware_name = firmware_name  # type: str
        self.firmware_sign = firmware_sign  # type: str
        self.firmware_size = firmware_size  # type: int
        self.firmware_url = firmware_url  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.multi_files = multi_files  # type: list[CreateOTAFirmwareRequestMultiFiles]
        self.need_to_verify = need_to_verify  # type: bool
        self.product_key = product_key  # type: str
        self.sign_method = sign_method  # type: str
        self.src_version = src_version  # type: str
        self.type = type  # type: int
        self.udi = udi  # type: str

    def validate(self):
        if self.multi_files:
            for k in self.multi_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        result['MultiFiles'] = []
        if self.multi_files is not None:
            for k in self.multi_files:
                result['MultiFiles'].append(k.to_map() if k else None)
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.type is not None:
            result['Type'] = self.type
        if self.udi is not None:
            result['Udi'] = self.udi
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        self.multi_files = []
        if m.get('MultiFiles') is not None:
            for k in m.get('MultiFiles'):
                temp_model = CreateOTAFirmwareRequestMultiFiles()
                self.multi_files.append(temp_model.from_map(k))
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Udi') is not None:
            self.udi = m.get('Udi')
        return self


class CreateOTAFirmwareResponseBodyData(TeaModel):
    def __init__(self, firmware_id=None, utc_create=None):
        self.firmware_id = firmware_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAFirmwareResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAFirmwareResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateOTAFirmwareResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(self, alias_name=None, desc=None, iot_instance_id=None, module_name=None, product_key=None):
        self.alias_name = alias_name  # type: str
        self.desc = desc  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAModuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAModuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOTAModuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAModuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(self, dn_list_file_url=None, download_protocol=None, firmware_id=None, gray_percent=None,
                 group_id=None, group_type=None, iot_instance_id=None, maximum_per_minute=None, multi_module_mode=None,
                 need_confirm=None, need_push=None, overwrite_mode=None, product_key=None, retry_count=None, retry_interval=None,
                 schedule_finish_time=None, schedule_time=None, src_version=None, tag=None, target_device_name=None,
                 target_selection=None, timeout_in_minutes=None):
        self.dn_list_file_url = dn_list_file_url  # type: str
        self.download_protocol = download_protocol  # type: str
        self.firmware_id = firmware_id  # type: str
        self.gray_percent = gray_percent  # type: str
        self.group_id = group_id  # type: str
        self.group_type = group_type  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.multi_module_mode = multi_module_mode  # type: bool
        self.need_confirm = need_confirm  # type: bool
        self.need_push = need_push  # type: bool
        self.overwrite_mode = overwrite_mode  # type: int
        self.product_key = product_key  # type: str
        self.retry_count = retry_count  # type: int
        self.retry_interval = retry_interval  # type: int
        self.schedule_finish_time = schedule_finish_time  # type: long
        self.schedule_time = schedule_time  # type: long
        self.src_version = src_version  # type: list[str]
        self.tag = tag  # type: list[CreateOTAStaticUpgradeJobRequestTag]
        self.target_device_name = target_device_name  # type: list[str]
        self.target_selection = target_selection  # type: str
        self.timeout_in_minutes = timeout_in_minutes  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        if self.download_protocol is not None:
            result['DownloadProtocol'] = self.download_protocol
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.multi_module_mode is not None:
            result['MultiModuleMode'] = self.multi_module_mode
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        if m.get('DownloadProtocol') is not None:
            self.download_protocol = m.get('DownloadProtocol')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('MultiModuleMode') is not None:
            self.multi_module_mode = m.get('MultiModuleMode')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        return self


class CreateOTAStaticUpgradeJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateOTAStaticUpgradeJobResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOTAStaticUpgradeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAVerifyJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAVerifyJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(self, download_protocol=None, firmware_id=None, iot_instance_id=None, need_confirm=None,
                 need_push=None, product_key=None, tag=None, target_device_name=None, timeout_in_minutes=None):
        self.download_protocol = download_protocol  # type: str
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.need_confirm = need_confirm  # type: bool
        self.need_push = need_push  # type: bool
        self.product_key = product_key  # type: str
        self.tag = tag  # type: list[CreateOTAVerifyJobRequestTag]
        self.target_device_name = target_device_name  # type: list[str]
        self.timeout_in_minutes = timeout_in_minutes  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTAVerifyJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_protocol is not None:
            result['DownloadProtocol'] = self.download_protocol
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownloadProtocol') is not None:
            self.download_protocol = m.get('DownloadProtocol')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAVerifyJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        return self


class CreateOTAVerifyJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateOTAVerifyJobResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOTAVerifyJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOTAVerifyJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateParserRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, name=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateParserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateParserResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, parser_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.parser_id = parser_id  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateParserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateParserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateParserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateParserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateParserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateParserDataSourceRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, name=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateParserDataSourceResponseBodyDataSource(TeaModel):
    def __init__(self, data_source_id=None, description=None, name=None, utc_created=None):
        self.data_source_id = data_source_id  # type: long
        self.description = description  # type: str
        self.name = name  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateParserDataSourceResponseBodyDataSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class CreateParserDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, data_source=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data_source = data_source  # type: CreateParserDataSourceResponseBodyDataSource
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data_source:
            self.data_source.validate()

    def to_map(self):
        _map = super(CreateParserDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data_source is not None:
            result['DataSource'] = self.data_source.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DataSource') is not None:
            temp_model = CreateParserDataSourceResponseBodyDataSource()
            self.data_source = temp_model.from_map(m['DataSource'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateParserDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateParserDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateParserDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductRequest(TeaModel):
    def __init__(self, aliyun_commodity_code=None, auth_type=None, category_key=None, data_format=None,
                 description=None, id_2=None, iot_instance_id=None, join_permission_id=None, net_type=None, node_type=None,
                 product_name=None, protocol_type=None, publish_auto=None, resource_group_id=None, validate_type=None):
        self.aliyun_commodity_code = aliyun_commodity_code  # type: str
        self.auth_type = auth_type  # type: str
        self.category_key = category_key  # type: str
        self.data_format = data_format  # type: int
        self.description = description  # type: str
        self.id_2 = id_2  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.join_permission_id = join_permission_id  # type: str
        self.net_type = net_type  # type: str
        self.node_type = node_type  # type: int
        self.product_name = product_name  # type: str
        self.protocol_type = protocol_type  # type: str
        self.publish_auto = publish_auto  # type: bool
        self.resource_group_id = resource_group_id  # type: str
        self.validate_type = validate_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.publish_auto is not None:
            result['PublishAuto'] = self.publish_auto
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('PublishAuto') is not None:
            self.publish_auto = m.get('PublishAuto')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        return self


class CreateProductResponseBodyData(TeaModel):
    def __init__(self, aliyun_commodity_code=None, auth_type=None, data_format=None, description=None, id_2=None,
                 node_type=None, product_key=None, product_name=None, product_secret=None, protocol_type=None):
        self.aliyun_commodity_code = aliyun_commodity_code  # type: str
        self.auth_type = auth_type  # type: str
        self.data_format = data_format  # type: int
        self.description = description  # type: str
        self.id_2 = id_2  # type: bool
        self.node_type = node_type  # type: int
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.product_secret = product_secret  # type: str
        self.protocol_type = protocol_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_secret is not None:
            result['ProductSecret'] = self.product_secret
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductSecret') is not None:
            self.product_secret = m.get('ProductSecret')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        return self


class CreateProductResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, product_key=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateProductResponseBodyData
        self.error_message = error_message  # type: str
        self.product_key = product_key  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductDistributeJobRequest(TeaModel):
    def __init__(self, product_key=None, source_instance_id=None, target_aliyun_id=None, target_instance_id=None,
                 target_uid=None):
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_uid = target_uid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        return self


class CreateProductDistributeJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, job_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateProductDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProductDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTagsRequestProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.product_tag = product_tag  # type: list[CreateProductTagsRequestProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBodyInvalidProductTagsProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTagsResponseBodyInvalidProductTagsProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsResponseBodyInvalidProductTags(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[CreateProductTagsResponseBodyInvalidProductTagsProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponseBodyInvalidProductTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseBodyInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, invalid_product_tags=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.invalid_product_tags = invalid_product_tags  # type: CreateProductTagsResponseBodyInvalidProductTags
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseBodyInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTopicRequest(TeaModel):
    def __init__(self, desc=None, iot_instance_id=None, operation=None, product_key=None, topic_short_name=None):
        self.desc = desc  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.operation = operation  # type: str
        self.product_key = product_key  # type: str
        self.topic_short_name = topic_short_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        return self


class CreateProductTopicResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, topic_id=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.topic_id = topic_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTopicResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class CreateProductTopicResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateProductTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleRequest(TeaModel):
    def __init__(self, data_type=None, iot_instance_id=None, name=None, product_key=None, resource_group_id=None,
                 rule_desc=None, select=None, short_topic=None, topic=None, topic_type=None, where=None):
        self.data_type = data_type  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.product_key = product_key  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.rule_desc = rule_desc  # type: str
        self.select = select  # type: str
        self.short_topic = short_topic  # type: str
        self.topic = topic  # type: str
        self.topic_type = topic_type  # type: int
        self.where = where  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.where is not None:
            result['Where'] = self.where
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        return self


class CreateRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, rule_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.rule_id = rule_id  # type: long
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleActionRequest(TeaModel):
    def __init__(self, configuration=None, error_action_flag=None, iot_instance_id=None, rule_id=None, type=None):
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateRuleActionResponseBody(TeaModel):
    def __init__(self, action_id=None, code=None, error_message=None, request_id=None, success=None):
        self.action_id = action_id  # type: long
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleActionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_content=None, rule_description=None, rule_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_content = rule_content  # type: str
        self.rule_description = rule_description  # type: str
        self.rule_name = rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class CreateSceneRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, rule_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.rule_id = rule_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSchedulePeriodRequest(TeaModel):
    def __init__(self, description=None, end_time=None, iot_instance_id=None, schedule_code=None,
                 sound_code_content=None, start_time=None):
        self.description = description  # type: str
        self.end_time = end_time  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str
        self.sound_code_content = sound_code_content  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSchedulePeriodRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        if self.sound_code_content is not None:
            result['SoundCodeContent'] = self.sound_code_content
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        if m.get('SoundCodeContent') is not None:
            self.sound_code_content = m.get('SoundCodeContent')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateSchedulePeriodResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSchedulePeriodResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSchedulePeriodResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSchedulePeriodResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSchedulePeriodResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSchedulePeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSoundCodeRequest(TeaModel):
    def __init__(self, duration=None, iot_instance_id=None, name=None, open_type=None, sound_code_content=None):
        self.duration = duration  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.open_type = open_type  # type: str
        self.sound_code_content = sound_code_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSoundCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.open_type is not None:
            result['OpenType'] = self.open_type
        if self.sound_code_content is not None:
            result['SoundCodeContent'] = self.sound_code_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpenType') is not None:
            self.open_type = m.get('OpenType')
        if m.get('SoundCodeContent') is not None:
            self.sound_code_content = m.get('SoundCodeContent')
        return self


class CreateSoundCodeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSoundCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSoundCodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSoundCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSoundCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSoundCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSoundCodeLabelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, label=None, schedule_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.label = label  # type: str
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSoundCodeLabelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.label is not None:
            result['Label'] = self.label
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class CreateSoundCodeLabelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSoundCodeLabelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSoundCodeLabelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSoundCodeLabelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSoundCodeLabelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSoundCodeLabelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSoundCodeScheduleRequest(TeaModel):
    def __init__(self, description=None, end_date=None, iot_instance_id=None, name=None, open_type=None,
                 start_date=None):
        self.description = description  # type: str
        self.end_date = end_date  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.open_type = open_type  # type: str
        self.start_date = start_date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSoundCodeScheduleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.open_type is not None:
            result['OpenType'] = self.open_type
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpenType') is not None:
            self.open_type = m.get('OpenType')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class CreateSoundCodeScheduleResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSoundCodeScheduleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSoundCodeScheduleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSoundCodeScheduleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSoundCodeScheduleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSoundCodeScheduleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSpeechRequest(TeaModel):
    def __init__(self, audio_format=None, biz_code=None, enable_sound_code=None, iot_instance_id=None,
                 project_code=None, sound_code_config=None, speech_rate=None, speech_type=None, text=None, voice=None,
                 volume=None):
        self.audio_format = audio_format  # type: str
        self.biz_code = biz_code  # type: str
        self.enable_sound_code = enable_sound_code  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_code = project_code  # type: str
        self.sound_code_config = sound_code_config  # type: dict[str, any]
        self.speech_rate = speech_rate  # type: int
        self.speech_type = speech_type  # type: str
        self.text = text  # type: str
        self.voice = voice  # type: str
        self.volume = volume  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSpeechRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.enable_sound_code is not None:
            result['EnableSoundCode'] = self.enable_sound_code
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.sound_code_config is not None:
            result['SoundCodeConfig'] = self.sound_code_config
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.speech_type is not None:
            result['SpeechType'] = self.speech_type
        if self.text is not None:
            result['Text'] = self.text
        if self.voice is not None:
            result['Voice'] = self.voice
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('EnableSoundCode') is not None:
            self.enable_sound_code = m.get('EnableSoundCode')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('SoundCodeConfig') is not None:
            self.sound_code_config = m.get('SoundCodeConfig')
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('SpeechType') is not None:
            self.speech_type = m.get('SpeechType')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Voice') is not None:
            self.voice = m.get('Voice')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class CreateSpeechShrinkRequest(TeaModel):
    def __init__(self, audio_format=None, biz_code=None, enable_sound_code=None, iot_instance_id=None,
                 project_code=None, sound_code_config_shrink=None, speech_rate=None, speech_type=None, text=None, voice=None,
                 volume=None):
        self.audio_format = audio_format  # type: str
        self.biz_code = biz_code  # type: str
        self.enable_sound_code = enable_sound_code  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_code = project_code  # type: str
        self.sound_code_config_shrink = sound_code_config_shrink  # type: str
        self.speech_rate = speech_rate  # type: int
        self.speech_type = speech_type  # type: str
        self.text = text  # type: str
        self.voice = voice  # type: str
        self.volume = volume  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSpeechShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.enable_sound_code is not None:
            result['EnableSoundCode'] = self.enable_sound_code
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.sound_code_config_shrink is not None:
            result['SoundCodeConfig'] = self.sound_code_config_shrink
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.speech_type is not None:
            result['SpeechType'] = self.speech_type
        if self.text is not None:
            result['Text'] = self.text
        if self.voice is not None:
            result['Voice'] = self.voice
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('EnableSoundCode') is not None:
            self.enable_sound_code = m.get('EnableSoundCode')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('SoundCodeConfig') is not None:
            self.sound_code_config_shrink = m.get('SoundCodeConfig')
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('SpeechType') is not None:
            self.speech_type = m.get('SpeechType')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Voice') is not None:
            self.voice = m.get('Voice')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class CreateSpeechResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSpeechResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSpeechResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSpeechResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSpeechResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSpeechResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStudioAppDomainOpenRequest(TeaModel):
    def __init__(self, app_id=None, host=None, iot_instance_id=None, project_id=None, protocol=None):
        self.app_id = app_id  # type: str
        self.host = host  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str
        self.protocol = protocol  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.host is not None:
            result['Host'] = self.host
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateStudioAppDomainOpenResponseBodyData(TeaModel):
    def __init__(self, app_id=None, host=None, id=None, is_beian=None, project_id=None, protocol=None, tenant_id=None):
        self.app_id = app_id  # type: str
        self.host = host  # type: str
        self.id = id  # type: int
        self.is_beian = is_beian  # type: str
        self.project_id = project_id  # type: str
        self.protocol = protocol  # type: str
        self.tenant_id = tenant_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.host is not None:
            result['Host'] = self.host
        if self.id is not None:
            result['Id'] = self.id
        if self.is_beian is not None:
            result['IsBeian'] = self.is_beian
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsBeian') is not None:
            self.is_beian = m.get('IsBeian')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateStudioAppDomainOpenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateStudioAppDomainOpenResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateStudioAppDomainOpenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateStudioAppDomainOpenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateStudioAppDomainOpenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStudioAppDomainOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_ids=None, device_data_flag=None, device_life_cycle_flag=None,
                 device_status_change_flag=None, device_tag_flag=None, device_topo_life_cycle_flag=None, found_device_list_flag=None,
                 iot_instance_id=None, mns_configuration=None, ota_event_flag=None, ota_job_flag=None, ota_version_flag=None,
                 product_key=None, subscribe_flags=None, thing_history_flag=None, type=None):
        self.consumer_group_ids = consumer_group_ids  # type: list[str]
        self.device_data_flag = device_data_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.device_tag_flag = device_tag_flag  # type: bool
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.mns_configuration = mns_configuration  # type: str
        self.ota_event_flag = ota_event_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.product_key = product_key  # type: str
        self.subscribe_flags = subscribe_flags  # type: str
        self.thing_history_flag = thing_history_flag  # type: bool
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.subscribe_flags is not None:
            result['SubscribeFlags'] = self.subscribe_flags
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SubscribeFlags') is not None:
            self.subscribe_flags = m.get('SubscribeFlags')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateSubscribeRelationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(self, function_block_id=None, function_block_name=None, iot_instance_id=None, product_key=None,
                 thing_model_json=None):
        self.function_block_id = function_block_id  # type: str
        self.function_block_name = function_block_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.thing_model_json = thing_model_json  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        return self


class CreateThingModelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, script_content=None, script_type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.script_content = script_content  # type: str
        self.script_type = script_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingScriptRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingScriptResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateThingScriptResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateThingScriptResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTopicRouteTableRequest(TeaModel):
    def __init__(self, dst_topic=None, iot_instance_id=None, src_topic=None):
        self.dst_topic = dst_topic  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.src_topic = src_topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTopicRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class CreateTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[str, any]]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTopicRouteTableResponseBodyFailureTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateTopicRouteTableResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, failure_topics=None, is_all_succeed=None, request_id=None,
                 success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.failure_topics = failure_topics  # type: CreateTopicRouteTableResponseBodyFailureTopics
        self.is_all_succeed = is_all_succeed  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super(CreateTopicRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FailureTopics') is not None:
            temp_model = CreateTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTopicRouteTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTopicRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTopicRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientIdsRequest(TeaModel):
    def __init__(self, iot_id=None, iot_instance_id=None):
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteClientIdsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteClientIdsResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteClientIdsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteClientIdsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteClientIdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteClientIdsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(self, group_id=None, iot_instance_id=None):
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteConsumerGroupResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteConsumerGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteConsumerGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = consumer_group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteConsumerGroupSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceItemRequest(TeaModel):
    def __init__(self, data_source_id=None, data_source_item_id=None, iot_instance_id=None):
        self.data_source_id = data_source_id  # type: long
        self.data_source_item_id = data_source_item_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourceItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_item_id is not None:
            result['DataSourceItemId'] = self.data_source_item_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceItemId') is not None:
            self.data_source_item_id = m.get('DataSourceItemId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDataSourceItemResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourceItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataSourceItemResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDataSourceItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDataSourceItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDestinationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDestinationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDestinationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDestinationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDestinationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceDistributeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteDeviceDistributeJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceDynamicGroupRequest(TeaModel):
    def __init__(self, group_id=None, iot_instance_id=None):
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceDynamicGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceDynamicGroupResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceDynamicGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceDynamicGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceDynamicGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceDynamicGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceDynamicGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(self, device_name=None, file_id=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.file_id = file_id  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteDeviceFileResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceGroupRequest(TeaModel):
    def __init__(self, group_id=None, iot_instance_id=None):
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceGroupResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None, prop_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.prop_key = prop_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDevicePropRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.prop_key is not None:
            result['PropKey'] = self.prop_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropKey') is not None:
            self.prop_key = m.get('PropKey')
        return self


class DeleteDevicePropResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDevicePropResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDevicePropResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDevicePropResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDevicePropResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceSpeechRequestDeviceSpeechList(TeaModel):
    def __init__(self, audio_format=None, biz_code=None):
        self.audio_format = audio_format  # type: str
        self.biz_code = biz_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceSpeechRequestDeviceSpeechList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        return self


class DeleteDeviceSpeechRequest(TeaModel):
    def __init__(self, device_speech_list=None, iot_id=None, iot_instance_id=None):
        self.device_speech_list = device_speech_list  # type: list[DeleteDeviceSpeechRequestDeviceSpeechList]
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device_speech_list:
            for k in self.device_speech_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteDeviceSpeechRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceSpeechList'] = []
        if self.device_speech_list is not None:
            for k in self.device_speech_list:
                result['DeviceSpeechList'].append(k.to_map() if k else None)
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_speech_list = []
        if m.get('DeviceSpeechList') is not None:
            for k in m.get('DeviceSpeechList'):
                temp_model = DeleteDeviceSpeechRequestDeviceSpeechList()
                self.device_speech_list.append(temp_model.from_map(k))
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceSpeechResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceSpeechResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceSpeechResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceSpeechResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceSpeechResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceSpeechResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceTunnelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, tunnel_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.tunnel_id = tunnel_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.tunnel_id is not None:
            result['TunnelId'] = self.tunnel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TunnelId') is not None:
            self.tunnel_id = m.get('TunnelId')
        return self


class DeleteDeviceTunnelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(self, driver_id=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteEdgeDriverResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, route_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class DeleteEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEdgeInstanceMessageRoutingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(self, firmware_id=None, iot_instance_id=None):
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteOTAFirmwareResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAFirmwareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, module_name=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAModuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteOTAModuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAModuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteOTAModuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteOTAModuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteParserRequest(TeaModel):
    def __init__(self, iot_instance_id=None, parser_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteParserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class DeleteParserResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteParserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteParserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteParserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteParserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteParserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteParserDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteParserDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteParserDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteParserDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteParserDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.product_tag_key = product_tag_key  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        return self


class DeleteProductTagsResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTopicRequest(TeaModel):
    def __init__(self, iot_instance_id=None, topic_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.topic_id = topic_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class DeleteProductTopicResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTopicResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTopicResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteProductTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProductTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleActionRequest(TeaModel):
    def __init__(self, action_id=None, iot_instance_id=None):
        self.action_id = action_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteRuleActionResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleActionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSchedulePeriodRequest(TeaModel):
    def __init__(self, iot_instance_id=None, period_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.period_code = period_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSchedulePeriodRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.period_code is not None:
            result['PeriodCode'] = self.period_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PeriodCode') is not None:
            self.period_code = m.get('PeriodCode')
        return self


class DeleteSchedulePeriodResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSchedulePeriodResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSchedulePeriodResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSchedulePeriodResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSchedulePeriodResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSchedulePeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteShareTaskDeviceRequest(TeaModel):
    def __init__(self, iot_id_list=None, iot_instance_id=None, share_task_id=None):
        self.iot_id_list = iot_id_list  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.share_task_id = share_task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteShareTaskDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id_list is not None:
            result['IotIdList'] = self.iot_id_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.share_task_id is not None:
            result['ShareTaskId'] = self.share_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotIdList') is not None:
            self.iot_id_list = m.get('IotIdList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ShareTaskId') is not None:
            self.share_task_id = m.get('ShareTaskId')
        return self


class DeleteShareTaskDeviceResponseBodyData(TeaModel):
    def __init__(self, progress=None, progress_id=None):
        self.progress = progress  # type: int
        self.progress_id = progress_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteShareTaskDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.progress_id is not None:
            result['ProgressId'] = self.progress_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProgressId') is not None:
            self.progress_id = m.get('ProgressId')
        return self


class DeleteShareTaskDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DeleteShareTaskDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteShareTaskDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteShareTaskDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteShareTaskDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteShareTaskDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteShareTaskDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteShareTaskDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSoundCodeRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sound_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sound_code = sound_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSoundCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sound_code is not None:
            result['SoundCode'] = self.sound_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SoundCode') is not None:
            self.sound_code = m.get('SoundCode')
        return self


class DeleteSoundCodeResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSoundCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSoundCodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSoundCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSoundCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSoundCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSoundCodeLabelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sound_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sound_code = sound_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSoundCodeLabelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sound_code is not None:
            result['SoundCode'] = self.sound_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SoundCode') is not None:
            self.sound_code = m.get('SoundCode')
        return self


class DeleteSoundCodeLabelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSoundCodeLabelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSoundCodeLabelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSoundCodeLabelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSoundCodeLabelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSoundCodeLabelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSoundCodeScheduleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, schedule_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSoundCodeScheduleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class DeleteSoundCodeScheduleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSoundCodeScheduleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSoundCodeScheduleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSoundCodeScheduleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSoundCodeScheduleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSoundCodeScheduleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSpeechRequest(TeaModel):
    def __init__(self, iot_instance_id=None, speech_code_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.speech_code_list = speech_code_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSpeechRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.speech_code_list is not None:
            result['SpeechCodeList'] = self.speech_code_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SpeechCodeList') is not None:
            self.speech_code_list = m.get('SpeechCodeList')
        return self


class DeleteSpeechResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSpeechResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSpeechResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSpeechResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSpeechResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSpeechResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStudioAppDomainOpenRequest(TeaModel):
    def __init__(self, app_id=None, domain_id=None, iot_instance_id=None, project_id=None):
        self.app_id = app_id  # type: str
        self.domain_id = domain_id  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStudioAppDomainOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteStudioAppDomainOpenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStudioAppDomainOpenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteStudioAppDomainOpenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteStudioAppDomainOpenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStudioAppDomainOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStudioAppDomainOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(self, event_identifier=None, function_block_id=None, iot_instance_id=None, product_key=None,
                 property_identifier=None, resource_group_id=None, service_identifier=None):
        self.event_identifier = event_identifier  # type: list[str]
        self.function_block_id = function_block_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.property_identifier = property_identifier  # type: list[str]
        self.resource_group_id = resource_group_id  # type: str
        self.service_identifier = service_identifier  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        return self


class DeleteThingModelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTopicRouteTableRequest(TeaModel):
    def __init__(self, dst_topic=None, iot_instance_id=None, src_topic=None):
        self.dst_topic = dst_topic  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.src_topic = src_topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTopicRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class DeleteTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[str, any]]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponseBodyFailureTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteTopicRouteTableResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, failure_topics=None, is_all_succeed=None, request_id=None,
                 success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.failure_topics = failure_topics  # type: DeleteTopicRouteTableResponseBodyFailureTopics
        self.is_all_succeed = is_all_succeed  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FailureTopics') is not None:
            temp_model = DeleteTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteTopicRouteTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTopicRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None, parser_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class DetachDestinationResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachDestinationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DetachDestinationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DetachDestinationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DetachDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachDestinationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None, parser_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class DetachParserDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachParserDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DetachParserDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DetachParserDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DetachParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachParserDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDeviceTunnelRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DisableDeviceTunnelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisableDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDeviceTunnelShareRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelShareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DisableDeviceTunnelShareResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelShareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableDeviceTunnelShareResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisableDeviceTunnelShareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableDeviceTunnelShareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableDeviceTunnelShareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisableSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableThingRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableThingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DisableThingResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableThingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableThingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisableThingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableThingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeviceTunnelRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class EnableDeviceTunnelResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EnableDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeviceTunnelShareRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelShareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class EnableDeviceTunnelShareResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelShareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableDeviceTunnelShareResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EnableDeviceTunnelShareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableDeviceTunnelShareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableDeviceTunnelShareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EnableSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableThingRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableThingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class EnableThingResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableThingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableThingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EnableThingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableThingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDeviceNameListURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseBodyData(TeaModel):
    def __init__(self, access_key_id=None, file_url=None, host=None, key=None, object_storage=None, policy=None,
                 signature=None, utc_create=None):
        self.access_key_id = access_key_id  # type: str
        self.file_url = file_url  # type: str
        self.host = host  # type: str
        self.key = key  # type: str
        self.object_storage = object_storage  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.host is not None:
            result['Host'] = self.host
        if self.key is not None:
            result['Key'] = self.key
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class GenerateDeviceNameListURLResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GenerateDeviceNameListURLResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GenerateDeviceNameListURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateDeviceNameListURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(self, biz_code=None, file_name=None, file_suffix=None, iot_instance_id=None):
        self.biz_code = biz_code  # type: str
        self.file_name = file_name  # type: str
        self.file_suffix = file_suffix  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateFileUploadURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateFileUploadURLResponseBodyData(TeaModel):
    def __init__(self, host=None, key=None, object_storage=None, oss_access_key_id=None, policy=None, signature=None):
        self.host = host  # type: str
        self.key = key  # type: str
        self.object_storage = object_storage  # type: str
        self.oss_access_key_id = oss_access_key_id  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateFileUploadURLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.key is not None:
            result['Key'] = self.key
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class GenerateFileUploadURLResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GenerateFileUploadURLResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateFileUploadURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GenerateFileUploadURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateFileUploadURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateFileUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(self, file_suffix=None, iot_instance_id=None):
        self.file_suffix = file_suffix  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateOTAUploadURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateOTAUploadURLResponseBodyData(TeaModel):
    def __init__(self, firmware_url=None, host=None, key=None, ossaccess_key_id=None, object_storage=None,
                 policy=None, signature=None, utc_create=None):
        self.firmware_url = firmware_url  # type: str
        self.host = host  # type: str
        self.key = key  # type: str
        self.ossaccess_key_id = ossaccess_key_id  # type: str
        self.object_storage = object_storage  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.host is not None:
            result['Host'] = self.host
        if self.key is not None:
            result['Key'] = self.key
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class GenerateOTAUploadURLResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GenerateOTAUploadURLResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GenerateOTAUploadURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateOTAUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(self, api_srn=None, iot_instance_id=None):
        self.api_srn = api_srn  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataAPIServiceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(self, desc=None, example=None, name=None, required=None, type=None):
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.name = name  # type: str
        self.required = required  # type: bool
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(self, request_params=None):
        self.request_params = request_params  # type: list[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams]

    def validate(self):
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(self, desc=None, example=None, name=None, required=None, type=None):
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.name = name  # type: str
        self.required = required  # type: bool
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(self, response_params=None):
        self.response_params = response_params  # type: list[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams]

    def validate(self):
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO(TeaModel):
    def __init__(self, origin_sql=None, request_params=None, response_params=None, template_sql=None):
        self.origin_sql = origin_sql  # type: str
        self.request_params = request_params  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams
        self.response_params = response_params  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams
        self.template_sql = template_sql  # type: str

    def validate(self):
        if self.request_params:
            self.request_params.validate()
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        return self


class GetDataAPIServiceDetailResponseBodyData(TeaModel):
    def __init__(self, api_path=None, api_srn=None, create_time=None, date_format=None, description=None,
                 display_name=None, last_update_time=None, request_method=None, request_protocol=None, sql_template_dto=None,
                 status=None):
        self.api_path = api_path  # type: str
        self.api_srn = api_srn  # type: str
        self.create_time = create_time  # type: long
        self.date_format = date_format  # type: str
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.last_update_time = last_update_time  # type: long
        self.request_method = request_method  # type: str
        self.request_protocol = request_protocol  # type: str
        self.sql_template_dto = sql_template_dto  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO
        self.status = status  # type: int

    def validate(self):
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDataAPIServiceDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetDataAPIServiceDetailResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDataAPIServiceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataAPIServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDestinationResponseBodyDestination(TeaModel):
    def __init__(self, configuration=None, destination_id=None, is_failover=None, name=None, status=None, type=None,
                 utc_created=None):
        self.configuration = configuration  # type: str
        self.destination_id = destination_id  # type: str
        self.is_failover = is_failover  # type: bool
        self.name = name  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDestinationResponseBodyDestination, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class GetDestinationResponseBody(TeaModel):
    def __init__(self, code=None, destination=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.destination = destination  # type: GetDestinationResponseBodyDestination
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.destination:
            self.destination.validate()

    def to_map(self):
        _map = super(GetDestinationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.destination is not None:
            result['Destination'] = self.destination.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Destination') is not None:
            temp_model = GetDestinationResponseBodyDestination()
            self.destination = temp_model.from_map(m['Destination'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDestinationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDestinationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDestinationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceShadowRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceShadowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceShadowResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, shadow_message=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.shadow_message = shadow_message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceShadowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.shadow_message is not None:
            result['ShadowMessage'] = self.shadow_message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ShadowMessage') is not None:
            self.shadow_message = m.get('ShadowMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceShadowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceShadowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceShadowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceShadowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceStatusRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceStatusResponseBodyData(TeaModel):
    def __init__(self, status=None, timestamp=None):
        self.status = status  # type: str
        self.timestamp = timestamp  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetDeviceStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetDeviceStatusResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceTunnelShareStatusRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceTunnelShareStatusResponseBodyData(TeaModel):
    def __init__(self, gmt_opened=None, is_open=None, password=None, share_id=None):
        self.gmt_opened = gmt_opened  # type: long
        self.is_open = is_open  # type: bool
        self.password = password  # type: str
        self.share_id = share_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_opened is not None:
            result['GmtOpened'] = self.gmt_opened
        if self.is_open is not None:
            result['IsOpen'] = self.is_open
        if self.password is not None:
            result['Password'] = self.password
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtOpened') is not None:
            self.gmt_opened = m.get('GmtOpened')
        if m.get('IsOpen') is not None:
            self.is_open = m.get('IsOpen')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        return self


class GetDeviceTunnelShareStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetDeviceTunnelShareStatusResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceTunnelShareStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceTunnelShareStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceTunnelStatusRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceTunnelStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceTunnelStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceTunnelStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceTunnelStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDownloadFileRequest(TeaModel):
    def __init__(self, context=None, iot_instance_id=None, long_job_id=None):
        self.context = context  # type: dict[str, any]
        self.iot_instance_id = iot_instance_id  # type: str
        self.long_job_id = long_job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDownloadFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['Context'] = self.context
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Context') is not None:
            self.context = m.get('Context')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        return self


class GetDownloadFileShrinkRequest(TeaModel):
    def __init__(self, context_shrink=None, iot_instance_id=None, long_job_id=None):
        self.context_shrink = context_shrink  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.long_job_id = long_job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDownloadFileShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_shrink is not None:
            result['Context'] = self.context_shrink
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Context') is not None:
            self.context_shrink = m.get('Context')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        return self


class GetDownloadFileResponseBodyDataHeader(TeaModel):
    def __init__(self, alias=None, dim_date_class=None, field_name=None, field_type=None, geo_class=None,
                 time_class=None, type_class=None):
        self.alias = alias  # type: str
        self.dim_date_class = dim_date_class  # type: str
        self.field_name = field_name  # type: str
        self.field_type = field_type  # type: str
        self.geo_class = geo_class  # type: str
        self.time_class = time_class  # type: str
        self.type_class = type_class  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDownloadFileResponseBodyDataHeader, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.dim_date_class is not None:
            result['DimDateClass'] = self.dim_date_class
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_type is not None:
            result['FieldType'] = self.field_type
        if self.geo_class is not None:
            result['GeoClass'] = self.geo_class
        if self.time_class is not None:
            result['TimeClass'] = self.time_class
        if self.type_class is not None:
            result['TypeClass'] = self.type_class
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('DimDateClass') is not None:
            self.dim_date_class = m.get('DimDateClass')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldType') is not None:
            self.field_type = m.get('FieldType')
        if m.get('GeoClass') is not None:
            self.geo_class = m.get('GeoClass')
        if m.get('TimeClass') is not None:
            self.time_class = m.get('TimeClass')
        if m.get('TypeClass') is not None:
            self.type_class = m.get('TypeClass')
        return self


class GetDownloadFileResponseBodyDataQuerySettingAstExpr(TeaModel):
    def __init__(self, expr=None, expr_type=None):
        self.expr = expr  # type: str
        self.expr_type = expr_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDownloadFileResponseBodyDataQuerySettingAstExpr, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expr is not None:
            result['Expr'] = self.expr
        if self.expr_type is not None:
            result['ExprType'] = self.expr_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expr') is not None:
            self.expr = m.get('Expr')
        if m.get('ExprType') is not None:
            self.expr_type = m.get('ExprType')
        return self


class GetDownloadFileResponseBodyDataQuerySettingSelectedHeaders(TeaModel):
    def __init__(self, alias=None, dim_date_class=None, field_name=None, field_type=None, geo_class=None,
                 time_class=None):
        self.alias = alias  # type: str
        self.dim_date_class = dim_date_class  # type: str
        self.field_name = field_name  # type: str
        self.field_type = field_type  # type: str
        self.geo_class = geo_class  # type: str
        self.time_class = time_class  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDownloadFileResponseBodyDataQuerySettingSelectedHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.dim_date_class is not None:
            result['DimDateClass'] = self.dim_date_class
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_type is not None:
            result['FieldType'] = self.field_type
        if self.geo_class is not None:
            result['GeoClass'] = self.geo_class
        if self.time_class is not None:
            result['TimeClass'] = self.time_class
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('DimDateClass') is not None:
            self.dim_date_class = m.get('DimDateClass')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldType') is not None:
            self.field_type = m.get('FieldType')
        if m.get('GeoClass') is not None:
            self.geo_class = m.get('GeoClass')
        if m.get('TimeClass') is not None:
            self.time_class = m.get('TimeClass')
        return self


class GetDownloadFileResponseBodyDataQuerySetting(TeaModel):
    def __init__(self, ast_expr=None, selected_headers=None):
        self.ast_expr = ast_expr  # type: list[GetDownloadFileResponseBodyDataQuerySettingAstExpr]
        self.selected_headers = selected_headers  # type: list[GetDownloadFileResponseBodyDataQuerySettingSelectedHeaders]

    def validate(self):
        if self.ast_expr:
            for k in self.ast_expr:
                if k:
                    k.validate()
        if self.selected_headers:
            for k in self.selected_headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDownloadFileResponseBodyDataQuerySetting, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AstExpr'] = []
        if self.ast_expr is not None:
            for k in self.ast_expr:
                result['AstExpr'].append(k.to_map() if k else None)
        result['SelectedHeaders'] = []
        if self.selected_headers is not None:
            for k in self.selected_headers:
                result['SelectedHeaders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ast_expr = []
        if m.get('AstExpr') is not None:
            for k in m.get('AstExpr'):
                temp_model = GetDownloadFileResponseBodyDataQuerySettingAstExpr()
                self.ast_expr.append(temp_model.from_map(k))
        self.selected_headers = []
        if m.get('SelectedHeaders') is not None:
            for k in m.get('SelectedHeaders'):
                temp_model = GetDownloadFileResponseBodyDataQuerySettingSelectedHeaders()
                self.selected_headers.append(temp_model.from_map(k))
        return self


class GetDownloadFileResponseBodyData(TeaModel):
    def __init__(self, async_execute=None, begin_time=None, csv_file_name=None, csv_url=None, dataset_id=None,
                 end_time=None, header=None, long_job_id=None, page_no=None, page_size=None, preview_size=None,
                 query_setting=None, result=None, result_data_in_string=None, status=None, total_count=None):
        self.async_execute = async_execute  # type: bool
        self.begin_time = begin_time  # type: long
        self.csv_file_name = csv_file_name  # type: str
        self.csv_url = csv_url  # type: str
        self.dataset_id = dataset_id  # type: str
        self.end_time = end_time  # type: long
        self.header = header  # type: list[GetDownloadFileResponseBodyDataHeader]
        self.long_job_id = long_job_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.preview_size = preview_size  # type: int
        self.query_setting = query_setting  # type: GetDownloadFileResponseBodyDataQuerySetting
        self.result = result  # type: list[dict[str, any]]
        self.result_data_in_string = result_data_in_string  # type: str
        self.status = status  # type: int
        self.total_count = total_count  # type: long

    def validate(self):
        if self.header:
            for k in self.header:
                if k:
                    k.validate()
        if self.query_setting:
            self.query_setting.validate()

    def to_map(self):
        _map = super(GetDownloadFileResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_execute is not None:
            result['AsyncExecute'] = self.async_execute
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.csv_file_name is not None:
            result['CsvFileName'] = self.csv_file_name
        if self.csv_url is not None:
            result['CsvUrl'] = self.csv_url
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['Header'] = []
        if self.header is not None:
            for k in self.header:
                result['Header'].append(k.to_map() if k else None)
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.preview_size is not None:
            result['PreviewSize'] = self.preview_size
        if self.query_setting is not None:
            result['QuerySetting'] = self.query_setting.to_map()
        if self.result is not None:
            result['Result'] = self.result
        if self.result_data_in_string is not None:
            result['ResultDataInString'] = self.result_data_in_string
        if self.status is not None:
            result['Status'] = self.status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsyncExecute') is not None:
            self.async_execute = m.get('AsyncExecute')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('CsvFileName') is not None:
            self.csv_file_name = m.get('CsvFileName')
        if m.get('CsvUrl') is not None:
            self.csv_url = m.get('CsvUrl')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.header = []
        if m.get('Header') is not None:
            for k in m.get('Header'):
                temp_model = GetDownloadFileResponseBodyDataHeader()
                self.header.append(temp_model.from_map(k))
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PreviewSize') is not None:
            self.preview_size = m.get('PreviewSize')
        if m.get('QuerySetting') is not None:
            temp_model = GetDownloadFileResponseBodyDataQuerySetting()
            self.query_setting = temp_model.from_map(m['QuerySetting'])
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('ResultDataInString') is not None:
            self.result_data_in_string = m.get('ResultDataInString')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetDownloadFileResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetDownloadFileResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDownloadFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDownloadFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDownloadFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDownloadFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDownloadFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDownloadFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetEdgeDriverVersionResponseBodyData(TeaModel):
    def __init__(self, argument=None, config_check_rule=None, container_config=None, description=None,
                 driver_config=None, driver_id=None, driver_version=None, edge_version=None, gmt_create_timestamp=None,
                 gmt_modified_timestamp=None, source_config=None, version_state=None):
        self.argument = argument  # type: str
        self.config_check_rule = config_check_rule  # type: str
        self.container_config = container_config  # type: str
        self.description = description  # type: str
        self.driver_config = driver_config  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.edge_version = edge_version  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.source_config = source_config  # type: str
        self.version_state = version_state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.argument is not None:
            result['Argument'] = self.argument
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.description is not None:
            result['Description'] = self.description
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        return self


class GetEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetEdgeDriverVersionResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetEdgeInstanceResponseBodyData(TeaModel):
    def __init__(self, biz_enable=None, gmt_create=None, gmt_create_timestamp=None, gmt_modified=None,
                 gmt_modified_timestamp=None, instance_id=None, latest_deployment_status=None, latest_deployment_type=None, name=None,
                 role_arn=None, role_attach_time=None, role_attach_timestamp=None, role_name=None, spec=None, tags=None,
                 type=None):
        self.biz_enable = biz_enable  # type: bool
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.instance_id = instance_id  # type: str
        self.latest_deployment_status = latest_deployment_status  # type: int
        self.latest_deployment_type = latest_deployment_type  # type: str
        self.name = name  # type: str
        self.role_arn = role_arn  # type: str
        self.role_attach_time = role_attach_time  # type: str
        self.role_attach_timestamp = role_attach_timestamp  # type: long
        self.role_name = role_name  # type: str
        self.spec = spec  # type: int
        self.tags = tags  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.name is not None:
            result['Name'] = self.name
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEdgeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetEdgeInstanceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, deployment_id=None, instance_id=None, iot_instance_id=None):
        self.deployment_id = deployment_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList(TeaModel):
    def __init__(self, gmt_completed=None, gmt_completed_timestamp=None, gmt_create=None,
                 gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None, log=None, operate_type=None,
                 resource_id=None, resource_name=None, resource_type=None, snapshot_id=None, stage=None, status=None):
        self.gmt_completed = gmt_completed  # type: str
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.log = log  # type: str
        self.operate_type = operate_type  # type: int
        self.resource_id = resource_id  # type: str
        self.resource_name = resource_name  # type: str
        self.resource_type = resource_type  # type: str
        self.snapshot_id = snapshot_id  # type: str
        self.stage = stage  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.log is not None:
            result['Log'] = self.log
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskList(TeaModel):
    def __init__(self, gateway_id=None, gmt_completed=None, gmt_completed_timestamp=None, gmt_create=None,
                 gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None, resource_snapshot_list=None, stage=None,
                 status=None, task_id=None):
        self.gateway_id = gateway_id  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.resource_snapshot_list = resource_snapshot_list  # type: list[GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList]
        self.stage = stage  # type: int
        self.status = status  # type: int
        self.task_id = task_id  # type: str

    def validate(self):
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBodyDataTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetEdgeInstanceDeploymentResponseBodyData(TeaModel):
    def __init__(self, deployment_id=None, description=None, gmt_completed=None, gmt_completed_timestamp=None,
                 gmt_create=None, gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None, status=None,
                 task_list=None, type=None):
        self.deployment_id = deployment_id  # type: str
        self.description = description  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.status = status  # type: int
        self.task_list = task_list  # type: list[GetEdgeInstanceDeploymentResponseBodyDataTaskList]
        self.type = type  # type: str

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.status is not None:
            result['Status'] = self.status
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetEdgeInstanceDeploymentResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, route_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext(TeaModel):
    def __init__(self, qos=None, source_application_name=None, source_fc_function_name=None,
                 source_fc_service_name=None, target_application_name=None, target_fc_function_name=None, target_fc_service_name=None):
        self.qos = qos  # type: str
        self.source_application_name = source_application_name  # type: str
        self.source_fc_function_name = source_fc_function_name  # type: str
        self.source_fc_service_name = source_fc_service_name  # type: str
        self.target_application_name = target_application_name  # type: str
        self.target_fc_function_name = target_fc_function_name  # type: str
        self.target_fc_service_name = target_fc_service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.source_application_name is not None:
            result['SourceApplicationName'] = self.source_application_name
        if self.source_fc_function_name is not None:
            result['SourceFcFunctionName'] = self.source_fc_function_name
        if self.source_fc_service_name is not None:
            result['SourceFcServiceName'] = self.source_fc_service_name
        if self.target_application_name is not None:
            result['TargetApplicationName'] = self.target_application_name
        if self.target_fc_function_name is not None:
            result['TargetFcFunctionName'] = self.target_fc_function_name
        if self.target_fc_service_name is not None:
            result['TargetFcServiceName'] = self.target_fc_service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('SourceApplicationName') is not None:
            self.source_application_name = m.get('SourceApplicationName')
        if m.get('SourceFcFunctionName') is not None:
            self.source_fc_function_name = m.get('SourceFcFunctionName')
        if m.get('SourceFcServiceName') is not None:
            self.source_fc_service_name = m.get('SourceFcServiceName')
        if m.get('TargetApplicationName') is not None:
            self.target_application_name = m.get('TargetApplicationName')
        if m.get('TargetFcFunctionName') is not None:
            self.target_fc_function_name = m.get('TargetFcFunctionName')
        if m.get('TargetFcServiceName') is not None:
            self.target_fc_service_name = m.get('TargetFcServiceName')
        return self


class GetEdgeInstanceMessageRoutingResponseBodyData(TeaModel):
    def __init__(self, gmt_create=None, gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None,
                 name=None, route_context=None, source_data=None, source_type=None, target_data=None, target_type=None,
                 topic_filter=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.name = name  # type: str
        self.route_context = route_context  # type: GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext
        self.source_data = source_data  # type: str
        self.source_type = source_type  # type: str
        self.target_data = target_data  # type: str
        self.target_type = target_type  # type: str
        self.topic_filter = topic_filter  # type: str

    def validate(self):
        if self.route_context:
            self.route_context.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.name is not None:
            result['Name'] = self.name
        if self.route_context is not None:
            result['RouteContext'] = self.route_context.to_map()
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RouteContext') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext()
            self.route_context = temp_model.from_map(m['RouteContext'])
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        return self


class GetEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetEdgeInstanceMessageRoutingResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEdgeInstanceMessageRoutingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayBySubDeviceRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetGatewayBySubDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetGatewayBySubDeviceResponseBodyData(TeaModel):
    def __init__(self, device_name=None, device_secret=None, firmware_version=None, gmt_active=None,
                 gmt_create=None, gmt_online=None, ip_address=None, node_type=None, product_key=None, product_name=None,
                 status=None, utc_active=None, utc_create=None, utc_online=None, iot_id=None, region=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.firmware_version = firmware_version  # type: str
        self.gmt_active = gmt_active  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_online = gmt_online  # type: str
        self.ip_address = ip_address  # type: str
        self.node_type = node_type  # type: str
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.status = status  # type: str
        self.utc_active = utc_active  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_online = utc_online  # type: str
        self.iot_id = iot_id  # type: str
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.iot_id is not None:
            result['iotId'] = self.iot_id
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('iotId') is not None:
            self.iot_id = m.get('iotId')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class GetGatewayBySubDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetGatewayBySubDeviceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGatewayBySubDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayBySubDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetGatewayBySubDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGatewayBySubDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoraNodesTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoraNodesTaskResponseBodySuccessDevEuis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, success_count=None,
                 success_dev_euis=None, task_id=None, task_state=None, total_count=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.success_count = success_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetLoraNodesTaskResponseBodySuccessDevEuis
        self.task_id = task_id  # type: str
        self.task_state = task_state  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        _map = super(GetLoraNodesTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLoraNodesTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLoraNodesTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLoraNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetParserRequest(TeaModel):
    def __init__(self, iot_instance_id=None, parser_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetParserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class GetParserResponseBodyData(TeaModel):
    def __init__(self, data_source_id=None, description=None, name=None, parser_id=None, script=None,
                 script_draft=None, status=None, utc_created=None, utc_modified=None):
        self.data_source_id = data_source_id  # type: long
        self.description = description  # type: str
        self.name = name  # type: str
        self.parser_id = parser_id  # type: long
        self.script = script  # type: str
        self.script_draft = script_draft  # type: str
        self.status = status  # type: str
        self.utc_created = utc_created  # type: str
        self.utc_modified = utc_modified  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetParserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        if self.script is not None:
            result['Script'] = self.script
        if self.script_draft is not None:
            result['ScriptDraft'] = self.script_draft
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptDraft') is not None:
            self.script_draft = m.get('ScriptDraft')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class GetParserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetParserResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetParserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetParserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetParserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetParserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetParserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetParserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetParserDataSourceResponseBodyDataSource(TeaModel):
    def __init__(self, create_user_id=None, data_source_id=None, description=None, name=None, utc_created=None):
        self.create_user_id = create_user_id  # type: long
        self.data_source_id = data_source_id  # type: long
        self.description = description  # type: str
        self.name = name  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetParserDataSourceResponseBodyDataSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class GetParserDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, data_source=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data_source = data_source  # type: GetParserDataSourceResponseBodyDataSource
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data_source:
            self.data_source.validate()

    def to_map(self):
        _map = super(GetParserDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data_source is not None:
            result['DataSource'] = self.data_source.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DataSource') is not None:
            temp_model = GetParserDataSourceResponseBodyDataSource()
            self.data_source = temp_model.from_map(m['DataSource'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetParserDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetParserDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetParserDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleResponseBodyRuleInfo(TeaModel):
    def __init__(self, create_user_id=None, created=None, data_type=None, id=None, modified=None, name=None,
                 product_key=None, rule_desc=None, select=None, short_topic=None, status=None, topic=None, topic_type=None,
                 utc_created=None, utc_modified=None, where=None):
        self.create_user_id = create_user_id  # type: long
        self.created = created  # type: str
        self.data_type = data_type  # type: str
        self.id = id  # type: long
        self.modified = modified  # type: str
        self.name = name  # type: str
        self.product_key = product_key  # type: str
        self.rule_desc = rule_desc  # type: str
        self.select = select  # type: str
        self.short_topic = short_topic  # type: str
        self.status = status  # type: str
        self.topic = topic  # type: str
        self.topic_type = topic_type  # type: int
        self.utc_created = utc_created  # type: str
        self.utc_modified = utc_modified  # type: str
        self.where = where  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleResponseBodyRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.created is not None:
            result['Created'] = self.created
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.id is not None:
            result['Id'] = self.id
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.name is not None:
            result['Name'] = self.name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.status is not None:
            result['Status'] = self.status
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.where is not None:
            result['Where'] = self.where
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        return self


class GetRuleResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, rule_info=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.rule_info = rule_info  # type: GetRuleResponseBodyRuleInfo
        self.success = success  # type: bool

    def validate(self):
        if self.rule_info:
            self.rule_info.validate()

    def to_map(self):
        _map = super(GetRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_info is not None:
            result['RuleInfo'] = self.rule_info.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleInfo') is not None:
            temp_model = GetRuleResponseBodyRuleInfo()
            self.rule_info = temp_model.from_map(m['RuleInfo'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleActionRequest(TeaModel):
    def __init__(self, action_id=None, iot_instance_id=None):
        self.action_id = action_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetRuleActionResponseBodyRuleActionInfo(TeaModel):
    def __init__(self, configuration=None, error_action_flag=None, id=None, rule_id=None, type=None):
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool
        self.id = id  # type: long
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleActionResponseBodyRuleActionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetRuleActionResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, rule_action_info=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.rule_action_info = rule_action_info  # type: GetRuleActionResponseBodyRuleActionInfo
        self.success = success  # type: bool

    def validate(self):
        if self.rule_action_info:
            self.rule_action_info.validate()

    def to_map(self):
        _map = super(GetRuleActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_action_info is not None:
            result['RuleActionInfo'] = self.rule_action_info.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleActionInfo') is not None:
            temp_model = GetRuleActionResponseBodyRuleActionInfo()
            self.rule_action_info = temp_model.from_map(m['RuleActionInfo'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRuleActionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseBodyData(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, rule_content=None, rule_description=None, rule_name=None,
                 rule_status=None):
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.rule_content = rule_content  # type: str
        self.rule_description = rule_description  # type: str
        self.rule_name = rule_name  # type: str
        self.rule_status = rule_status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSceneRuleResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class GetSceneRuleResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSceneRuleResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetShareSpeechModelAudioRequest(TeaModel):
    def __init__(self, iot_instance_id=None, share_task_id=None, speech_model_code_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.share_task_id = share_task_id  # type: str
        self.speech_model_code_list = speech_model_code_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetShareSpeechModelAudioRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.share_task_id is not None:
            result['ShareTaskId'] = self.share_task_id
        if self.speech_model_code_list is not None:
            result['SpeechModelCodeList'] = self.speech_model_code_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ShareTaskId') is not None:
            self.share_task_id = m.get('ShareTaskId')
        if m.get('SpeechModelCodeList') is not None:
            self.speech_model_code_list = m.get('SpeechModelCodeList')
        return self


class GetShareSpeechModelAudioResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetShareSpeechModelAudioResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GetShareSpeechModelAudioResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetShareSpeechModelAudioResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetShareSpeechModelAudioResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetShareSpeechModelAudioResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetShareSpeechModelAudioResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetShareSpeechModelAudioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetShareSpeechModelAudioResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetShareSpeechModelAudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetShareTaskByDeviceOpenRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetShareTaskByDeviceOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetShareTaskByDeviceOpenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetShareTaskByDeviceOpenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetShareTaskByDeviceOpenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetShareTaskByDeviceOpenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetShareTaskByDeviceOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetShareTaskByDeviceOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSoundCodeAudioRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sound_code_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sound_code_list = sound_code_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSoundCodeAudioRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sound_code_list is not None:
            result['SoundCodeList'] = self.sound_code_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SoundCodeList') is not None:
            self.sound_code_list = m.get('SoundCodeList')
        return self


class GetSoundCodeAudioResponseBodyData(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSoundCodeAudioResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class GetSoundCodeAudioResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSoundCodeAudioResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSoundCodeAudioResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSoundCodeAudioResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSoundCodeAudioResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSoundCodeAudioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSoundCodeAudioResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSoundCodeAudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSoundCodeScheduleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, schedule_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSoundCodeScheduleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class GetSoundCodeScheduleResponseBodyData(TeaModel):
    def __init__(self, description=None, end_date=None, end_time=None, gmt_create=None, name=None, open_type=None,
                 schedule_code=None, start_date=None, start_time=None, status=None):
        self.description = description  # type: str
        self.end_date = end_date  # type: str
        self.end_time = end_time  # type: str
        self.gmt_create = gmt_create  # type: long
        self.name = name  # type: str
        self.open_type = open_type  # type: str
        self.schedule_code = schedule_code  # type: str
        self.start_date = start_date  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSoundCodeScheduleResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.name is not None:
            result['Name'] = self.name
        if self.open_type is not None:
            result['OpenType'] = self.open_type
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpenType') is not None:
            self.open_type = m.get('OpenType')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetSoundCodeScheduleResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSoundCodeScheduleResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSoundCodeScheduleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSoundCodeScheduleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSoundCodeScheduleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSoundCodeScheduleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSoundCodeScheduleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSoundCodeScheduleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpeechDeviceDetailRequest(TeaModel):
    def __init__(self, iot_id=None, iot_instance_id=None):
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechDeviceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetSpeechDeviceDetailResponseBodyData(TeaModel):
    def __init__(self, available_space=None, device_name=None, iot_id=None, product_key=None,
                 speech_list_update_time=None, status=None, total_space=None):
        self.available_space = available_space  # type: float
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.product_key = product_key  # type: str
        self.speech_list_update_time = speech_list_update_time  # type: long
        self.status = status  # type: str
        self.total_space = total_space  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechDeviceDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_space is not None:
            result['AvailableSpace'] = self.available_space
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.speech_list_update_time is not None:
            result['SpeechListUpdateTime'] = self.speech_list_update_time
        if self.status is not None:
            result['Status'] = self.status
        if self.total_space is not None:
            result['TotalSpace'] = self.total_space
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableSpace') is not None:
            self.available_space = m.get('AvailableSpace')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SpeechListUpdateTime') is not None:
            self.speech_list_update_time = m.get('SpeechListUpdateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSpace') is not None:
            self.total_space = m.get('TotalSpace')
        return self


class GetSpeechDeviceDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSpeechDeviceDetailResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSpeechDeviceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSpeechDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSpeechDeviceDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSpeechDeviceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSpeechDeviceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSpeechDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpeechLicenseDeviceStatisticsRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetSpeechLicenseDeviceStatisticsResponseBodyData(TeaModel):
    def __init__(self, available_quota=None, expired_quota=None, expiring_quota=None):
        self.available_quota = available_quota  # type: int
        self.expired_quota = expired_quota  # type: int
        self.expiring_quota = expiring_quota  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_quota is not None:
            result['AvailableQuota'] = self.available_quota
        if self.expired_quota is not None:
            result['ExpiredQuota'] = self.expired_quota
        if self.expiring_quota is not None:
            result['ExpiringQuota'] = self.expiring_quota
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableQuota') is not None:
            self.available_quota = m.get('AvailableQuota')
        if m.get('ExpiredQuota') is not None:
            self.expired_quota = m.get('ExpiredQuota')
        if m.get('ExpiringQuota') is not None:
            self.expiring_quota = m.get('ExpiringQuota')
        return self


class GetSpeechLicenseDeviceStatisticsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSpeechLicenseDeviceStatisticsResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSpeechLicenseDeviceStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSpeechLicenseDeviceStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSpeechLicenseDeviceStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSpeechLicenseDeviceStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpeechVoiceResponseBodyDataItemsVoiceListItems(TeaModel):
    def __init__(self, label=None, value=None):
        self.label = label  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechVoiceResponseBodyDataItemsVoiceListItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetSpeechVoiceResponseBodyDataItemsVoiceList(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[GetSpeechVoiceResponseBodyDataItemsVoiceListItems]

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseBodyDataItemsVoiceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = GetSpeechVoiceResponseBodyDataItemsVoiceListItems()
                self.items.append(temp_model.from_map(k))
        return self


class GetSpeechVoiceResponseBodyDataItems(TeaModel):
    def __init__(self, label=None, value=None, voice_list=None):
        self.label = label  # type: str
        self.value = value  # type: str
        self.voice_list = voice_list  # type: GetSpeechVoiceResponseBodyDataItemsVoiceList

    def validate(self):
        if self.voice_list:
            self.voice_list.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseBodyDataItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        if self.voice_list is not None:
            result['VoiceList'] = self.voice_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('VoiceList') is not None:
            temp_model = GetSpeechVoiceResponseBodyDataItemsVoiceList()
            self.voice_list = temp_model.from_map(m['VoiceList'])
        return self


class GetSpeechVoiceResponseBodyData(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[GetSpeechVoiceResponseBodyDataItems]

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = GetSpeechVoiceResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        return self


class GetSpeechVoiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSpeechVoiceResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSpeechVoiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSpeechVoiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSpeechVoiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSpeechVoiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetStudioAppTokenOpenRequest(TeaModel):
    def __init__(self, app_id=None, iot_instance_id=None, project_id=None):
        self.app_id = app_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetStudioAppTokenOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetStudioAppTokenOpenResponseBodyData(TeaModel):
    def __init__(self, biz_id=None, biz_type=None, is_enable=None, token=None, type=None):
        self.biz_id = biz_id  # type: str
        self.biz_type = biz_type  # type: str
        self.is_enable = is_enable  # type: str
        self.token = token  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetStudioAppTokenOpenResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.token is not None:
            result['Token'] = self.token
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetStudioAppTokenOpenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetStudioAppTokenOpenResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetStudioAppTokenOpenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetStudioAppTokenOpenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetStudioAppTokenOpenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetStudioAppTokenOpenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetStudioAppTokenOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetStudioAppTokenOpenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(self, function_block_id=None, iot_instance_id=None, model_version=None, product_key=None,
                 simple=None):
        self.function_block_id = function_block_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.model_version = model_version  # type: str
        self.product_key = product_key  # type: str
        self.simple = simple  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.simple is not None:
            result['Simple'] = self.simple
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        return self


class GetThingModelTslResponseBodyData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = tsl_str  # type: str
        self.tsl_uri = tsl_uri  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetThingModelTslResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingModelTslResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetThingModelTslResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingModelTslResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(self, function_block_id=None, iot_instance_id=None, model_version=None, product_key=None,
                 resource_group_id=None, simple=None):
        self.function_block_id = function_block_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.model_version = model_version  # type: str
        self.product_key = product_key  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.simple = simple  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslPublishedRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        return self


class GetThingModelTslPublishedResponseBodyData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = tsl_str  # type: str
        self.tsl_uri = tsl_uri  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetThingModelTslPublishedResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetThingModelTslPublishedResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetThingModelTslPublishedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingScriptRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseBodyData(TeaModel):
    def __init__(self, script_type=None, script_url=None):
        self.script_type = script_type  # type: str
        self.script_url = script_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingScriptResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponseBody(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetThingScriptResponseBodyData
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingScriptResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetThingScriptResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingScriptResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(self, category_key=None, iot_instance_id=None, resource_group_id=None):
        self.category_key = category_key  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class GetThingTemplateResponseBody(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, thing_model_json=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.thing_model_json = thing_model_json  # type: str

    def validate(self):
        pass

    def to_map(se