# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class ZonesTargetMessage(DataMessage):
    ID = 7
    NAME = 'zones_target'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=ZonesTargetMessage.NAME,
                         global_id=ZonesTargetMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             ZonesTargetMaxHeartRateField(
                                 size=self.__get_field_size(definition_message, ZonesTargetMaxHeartRateField.ID),
                                 growable=definition_message is None),
                             ZonesTargetThresholdHeartRateField(
                                 size=self.__get_field_size(definition_message, ZonesTargetThresholdHeartRateField.ID),
                                 growable=definition_message is None),
                             ZonesTargetFunctionalThresholdPowerField(
                                 size=self.__get_field_size(definition_message,
                                                            ZonesTargetFunctionalThresholdPowerField.ID),
                                 growable=definition_message is None),
                             ZonesTargetHrCalcTypeField(
                                 size=self.__get_field_size(definition_message, ZonesTargetHrCalcTypeField.ID),
                                 growable=definition_message is None),
                             ZonesTargetPwrCalcTypeField(
                                 size=self.__get_field_size(definition_message, ZonesTargetPwrCalcTypeField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def max_heart_rate(self) -> Optional[int]:
        field = self.get_field(ZonesTargetMaxHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_heart_rate.setter
    def max_heart_rate(self, value: int):
        field = self.get_field(ZonesTargetMaxHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def threshold_heart_rate(self) -> Optional[int]:
        field = self.get_field(ZonesTargetThresholdHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @threshold_heart_rate.setter
    def threshold_heart_rate(self, value: int):
        field = self.get_field(ZonesTargetThresholdHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def functional_threshold_power(self) -> Optional[int]:
        field = self.get_field(ZonesTargetFunctionalThresholdPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @functional_threshold_power.setter
    def functional_threshold_power(self, value: int):
        field = self.get_field(ZonesTargetFunctionalThresholdPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def hr_calc_type(self) -> Optional[HrZoneCalc]:
        field = self.get_field(ZonesTargetHrCalcTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @hr_calc_type.setter
    def hr_calc_type(self, value: HrZoneCalc):
        field = self.get_field(ZonesTargetHrCalcTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pwr_calc_type(self) -> Optional[PwrZoneCalc]:
        field = self.get_field(ZonesTargetPwrCalcTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pwr_calc_type.setter
    def pwr_calc_type(self, value: PwrZoneCalc):
        field = self.get_field(ZonesTargetPwrCalcTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class ZonesTargetMaxHeartRateField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ZonesTargetThresholdHeartRateField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='threshold_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ZonesTargetFunctionalThresholdPowerField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='functional_threshold_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ZonesTargetHrCalcTypeField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='hr_calc_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ZonesTargetPwrCalcTypeField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pwr_calc_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
