# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field


class WeightScaleMessage(DataMessage):
    ID = 30
    NAME = 'weight_scale'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=WeightScaleMessage.NAME,
                         global_id=WeightScaleMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             WeightScaleWeightField(
                                 size=self.__get_field_size(definition_message, WeightScaleWeightField.ID),
                                 growable=definition_message is None),
                             WeightScalePercentFatField(
                                 size=self.__get_field_size(definition_message, WeightScalePercentFatField.ID),
                                 growable=definition_message is None),
                             WeightScalePercentHydrationField(
                                 size=self.__get_field_size(definition_message, WeightScalePercentHydrationField.ID),
                                 growable=definition_message is None),
                             WeightScaleVisceralFatMassField(
                                 size=self.__get_field_size(definition_message, WeightScaleVisceralFatMassField.ID),
                                 growable=definition_message is None),
                             WeightScaleBoneMassField(
                                 size=self.__get_field_size(definition_message, WeightScaleBoneMassField.ID),
                                 growable=definition_message is None),
                             WeightScaleMuscleMassField(
                                 size=self.__get_field_size(definition_message, WeightScaleMuscleMassField.ID),
                                 growable=definition_message is None),
                             WeightScaleBasalMetField(
                                 size=self.__get_field_size(definition_message, WeightScaleBasalMetField.ID),
                                 growable=definition_message is None),
                             WeightScalePhysiqueRatingField(
                                 size=self.__get_field_size(definition_message, WeightScalePhysiqueRatingField.ID),
                                 growable=definition_message is None),
                             WeightScaleActiveMetField(
                                 size=self.__get_field_size(definition_message, WeightScaleActiveMetField.ID),
                                 growable=definition_message is None),
                             WeightScaleMetabolicAgeField(
                                 size=self.__get_field_size(definition_message, WeightScaleMetabolicAgeField.ID),
                                 growable=definition_message is None),
                             WeightScaleVisceralFatRatingField(
                                 size=self.__get_field_size(definition_message, WeightScaleVisceralFatRatingField.ID),
                                 growable=definition_message is None),
                             WeightScaleUserProfileIndexField(
                                 size=self.__get_field_size(definition_message, WeightScaleUserProfileIndexField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def weight(self) -> Optional[float]:
        field = self.get_field(WeightScaleWeightField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @weight.setter
    def weight(self, value: float):
        field = self.get_field(WeightScaleWeightField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def percent_fat(self) -> Optional[float]:
        field = self.get_field(WeightScalePercentFatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @percent_fat.setter
    def percent_fat(self, value: float):
        field = self.get_field(WeightScalePercentFatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def percent_hydration(self) -> Optional[float]:
        field = self.get_field(WeightScalePercentHydrationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @percent_hydration.setter
    def percent_hydration(self, value: float):
        field = self.get_field(WeightScalePercentHydrationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def visceral_fat_mass(self) -> Optional[float]:
        field = self.get_field(WeightScaleVisceralFatMassField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @visceral_fat_mass.setter
    def visceral_fat_mass(self, value: float):
        field = self.get_field(WeightScaleVisceralFatMassField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bone_mass(self) -> Optional[float]:
        field = self.get_field(WeightScaleBoneMassField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bone_mass.setter
    def bone_mass(self, value: float):
        field = self.get_field(WeightScaleBoneMassField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def muscle_mass(self) -> Optional[float]:
        field = self.get_field(WeightScaleMuscleMassField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @muscle_mass.setter
    def muscle_mass(self, value: float):
        field = self.get_field(WeightScaleMuscleMassField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def basal_met(self) -> Optional[float]:
        field = self.get_field(WeightScaleBasalMetField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @basal_met.setter
    def basal_met(self, value: float):
        field = self.get_field(WeightScaleBasalMetField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def physique_rating(self) -> Optional[int]:
        field = self.get_field(WeightScalePhysiqueRatingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @physique_rating.setter
    def physique_rating(self, value: int):
        field = self.get_field(WeightScalePhysiqueRatingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def active_met(self) -> Optional[float]:
        field = self.get_field(WeightScaleActiveMetField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @active_met.setter
    def active_met(self, value: float):
        field = self.get_field(WeightScaleActiveMetField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def metabolic_age(self) -> Optional[int]:
        field = self.get_field(WeightScaleMetabolicAgeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @metabolic_age.setter
    def metabolic_age(self, value: int):
        field = self.get_field(WeightScaleMetabolicAgeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def visceral_fat_rating(self) -> Optional[int]:
        field = self.get_field(WeightScaleVisceralFatRatingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @visceral_fat_rating.setter
    def visceral_fat_rating(self, value: int):
        field = self.get_field(WeightScaleVisceralFatRatingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_profile_index(self) -> Optional[int]:
        field = self.get_field(WeightScaleUserProfileIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_profile_index.setter
    def user_profile_index(self, value: int):
        field = self.get_field(WeightScaleUserProfileIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleWeightField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='weight',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='kg',
            type_name='weight',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScalePercentFatField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='percent_fat',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScalePercentHydrationField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='percent_hydration',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleVisceralFatMassField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='visceral_fat_mass',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='kg',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleBoneMassField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bone_mass',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='kg',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleMuscleMassField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='muscle_mass',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='kg',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleBasalMetField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='basal_met',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=4,
            size=size,
            units='kcal/day',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScalePhysiqueRatingField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='physique_rating',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleActiveMetField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='active_met',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=4,
            size=size,
            units='kcal/day',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleMetabolicAgeField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='metabolic_age',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='years',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleVisceralFatRatingField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='visceral_fat_rating',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeightScaleUserProfileIndexField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='user_profile_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
