# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class SegmentIdMessage(DataMessage):
    ID = 148
    NAME = 'segment_id'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=SegmentIdMessage.NAME,
                         global_id=SegmentIdMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             SegmentIdNameField(
                                 size=self.__get_field_size(definition_message, SegmentIdNameField.ID),
                                 growable=definition_message is None),
                             SegmentIdUuidField(
                                 size=self.__get_field_size(definition_message, SegmentIdUuidField.ID),
                                 growable=definition_message is None),
                             SegmentIdSportField(
                                 size=self.__get_field_size(definition_message, SegmentIdSportField.ID),
                                 growable=definition_message is None),
                             SegmentIdEnabledField(
                                 size=self.__get_field_size(definition_message, SegmentIdEnabledField.ID),
                                 growable=definition_message is None),
                             SegmentIdUserProfilePrimaryKeyField(
                                 size=self.__get_field_size(definition_message, SegmentIdUserProfilePrimaryKeyField.ID),
                                 growable=definition_message is None),
                             SegmentIdDeviceIdField(
                                 size=self.__get_field_size(definition_message, SegmentIdDeviceIdField.ID),
                                 growable=definition_message is None),
                             SegmentIdDefaultRaceLeaderField(
                                 size=self.__get_field_size(definition_message, SegmentIdDefaultRaceLeaderField.ID),
                                 growable=definition_message is None),
                             SegmentIdDeleteStatusField(
                                 size=self.__get_field_size(definition_message, SegmentIdDeleteStatusField.ID),
                                 growable=definition_message is None),
                             SegmentIdSelectionTypeField(
                                 size=self.__get_field_size(definition_message, SegmentIdSelectionTypeField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def segment_id_name(self) -> Optional[str]:
        field = self.get_field(SegmentIdNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @segment_id_name.setter
    def segment_id_name(self, value: str):
        field = self.get_field(SegmentIdNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def uuid(self) -> Optional[str]:
        field = self.get_field(SegmentIdUuidField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @uuid.setter
    def uuid(self, value: str):
        field = self.get_field(SegmentIdUuidField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(SegmentIdSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(SegmentIdSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enabled(self) -> Optional[bool]:
        field = self.get_field(SegmentIdEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enabled.setter
    def enabled(self, value: bool):
        field = self.get_field(SegmentIdEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_profile_primary_key(self) -> Optional[int]:
        field = self.get_field(SegmentIdUserProfilePrimaryKeyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_profile_primary_key.setter
    def user_profile_primary_key(self, value: int):
        field = self.get_field(SegmentIdUserProfilePrimaryKeyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def device_id(self) -> Optional[int]:
        field = self.get_field(SegmentIdDeviceIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @device_id.setter
    def device_id(self, value: int):
        field = self.get_field(SegmentIdDeviceIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def default_race_leader(self) -> Optional[int]:
        field = self.get_field(SegmentIdDefaultRaceLeaderField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @default_race_leader.setter
    def default_race_leader(self, value: int):
        field = self.get_field(SegmentIdDefaultRaceLeaderField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def delete_status(self) -> Optional[SegmentDeleteStatus]:
        field = self.get_field(SegmentIdDeleteStatusField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @delete_status.setter
    def delete_status(self, value: SegmentDeleteStatus):
        field = self.get_field(SegmentIdDeleteStatusField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def selection_type(self) -> Optional[SegmentSelectionType]:
        field = self.get_field(SegmentIdSelectionTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @selection_type.setter
    def selection_type(self, value: SegmentSelectionType):
        field = self.get_field(SegmentIdSelectionTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class SegmentIdNameField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdUuidField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='uuid',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdSportField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdEnabledField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdUserProfilePrimaryKeyField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='user_profile_primary_key',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdDeviceIdField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='device_id',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdDefaultRaceLeaderField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='default_race_leader',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdDeleteStatusField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='delete_status',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentIdSelectionTypeField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='selection_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
