# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class ExdDataConceptConfigurationMessage(DataMessage):
    ID = 202
    NAME = 'exd_data_concept_configuration'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=ExdDataConceptConfigurationMessage.NAME,
                         global_id=ExdDataConceptConfigurationMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             ExdDataConceptConfigurationScreenIndexField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationScreenIndexField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationConceptField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationConceptField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationFieldIdField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationFieldIdField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationConceptIndexField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationConceptIndexField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationDataPageField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationDataPageField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationConceptKeyField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationConceptKeyField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationScalingField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationScalingField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationDataUnitsField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationDataUnitsField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationQualifierField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationQualifierField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationDescriptorField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationDescriptorField.ID),
                                 growable=definition_message is None),
                             ExdDataConceptConfigurationIsSignedField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataConceptConfigurationIsSignedField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def screen_index(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationScreenIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @screen_index.setter
    def screen_index(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationScreenIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def concept_field(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationConceptField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @concept_field.setter
    def concept_field(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationConceptField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def field_id(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationFieldIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @field_id.setter
    def field_id(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationFieldIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def concept_index(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationConceptIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @concept_index.setter
    def concept_index(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationConceptIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def data_page(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationDataPageField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @data_page.setter
    def data_page(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationDataPageField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def concept_key(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationConceptKeyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @concept_key.setter
    def concept_key(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationConceptKeyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def scaling(self) -> Optional[int]:
        field = self.get_field(ExdDataConceptConfigurationScalingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @scaling.setter
    def scaling(self, value: int):
        field = self.get_field(ExdDataConceptConfigurationScalingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def data_units(self) -> Optional[ExdDataUnits]:
        field = self.get_field(ExdDataConceptConfigurationDataUnitsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @data_units.setter
    def data_units(self, value: ExdDataUnits):
        field = self.get_field(ExdDataConceptConfigurationDataUnitsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def qualifier(self) -> Optional[ExdQualifiers]:
        field = self.get_field(ExdDataConceptConfigurationQualifierField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @qualifier.setter
    def qualifier(self, value: ExdQualifiers):
        field = self.get_field(ExdDataConceptConfigurationQualifierField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def descriptor(self) -> Optional[ExdDescriptors]:
        field = self.get_field(ExdDataConceptConfigurationDescriptorField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @descriptor.setter
    def descriptor(self, value: ExdDescriptors):
        field = self.get_field(ExdDataConceptConfigurationDescriptorField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def is_signed(self) -> Optional[bool]:
        field = self.get_field(ExdDataConceptConfigurationIsSignedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @is_signed.setter
    def is_signed(self, value: bool):
        field = self.get_field(ExdDataConceptConfigurationIsSignedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class ExdDataConceptConfigurationScreenIndexField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='screen_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationConceptField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='concept_field',
            field_id=self.ID,
            base_type=BaseType.BYTE,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationFieldIdField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='field_id',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationConceptIndexField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='concept_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationDataPageField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='data_page',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationConceptKeyField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='concept_key',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationScalingField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='scaling',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationDataUnitsField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='data_units',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationQualifierField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='qualifier',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationDescriptorField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='descriptor',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataConceptConfigurationIsSignedField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='is_signed',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
