"""
# Actions for AWS Elastic Load Balancing V2

<!--BEGIN STABILITY BANNER-->---


![cdk-constructs: Stable](https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge)

---
<!--END STABILITY BANNER-->

This package contains integration actions for ELBv2. See the README of the `@aws-cdk/aws-elasticloadbalancingv2` library.

## Cognito

ELB allows for requests to be authenticated against a Cognito user pool using
the `AuthenticateCognitoAction`. For details on the setup's requirements,
read [Prepare to use Amazon
Cognito](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#cognito-requirements).
Here's an example:

```python
# Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
import aws_cdk.aws_cognito as cognito
import aws_cdk.aws_ec2 as ec2
import aws_cdk.aws_elasticloadbalancingv2 as elbv2
from aws_cdk.core import App, CfnOutput, Construct, Stack
import ...lib as actionsStack):

lb = elbv2.ApplicationLoadBalancer(self, "LB",
    vpc=vpc,
    internet_facing=True
)

user_pool = cognito.UserPool(self, "UserPool")
user_pool_client = cognito.UserPoolClient(self, "Client",
    user_pool=user_pool,

    # Required minimal configuration for use with an ELB
    generate_secret=True,
    auth_flows=AuthFlow(
        user_password=True,
        refresh_token=True
    ),
    o_auth=OAuthSettings(
        flows=OAuthFlows(
            authorization_code_grant=True
        ),
        scopes=[cognito.OAuthScope.EMAIL],
        callback_urls=[f"https://{lb.loadBalancerDnsName}/oauth2/idpresponse"
        ]
    )
)
cfn_client = user_pool_client.node.default_child
cfn_client.add_property_override("RefreshTokenValidity", 1)
cfn_client.add_property_override("SupportedIdentityProviders", ["COGNITO"])

user_pool_domain = cognito.UserPoolDomain(self, "Domain",
    user_pool=user_pool,
    cognito_domain=CognitoDomainOptions(
        domain_prefix="test-cdk-prefix"
    )
)

lb.add_listener("Listener",
    port=443,
    certificates=[certificate],
    default_action=actions.AuthenticateCognitoAction(
        user_pool=user_pool,
        user_pool_client=user_pool_client,
        user_pool_domain=user_pool_domain,
        next=elbv2.ListenerAction.fixed_response(200,
            content_type="text/plain",
            message_body="Authenticated"
        )
    )
)

CfnOutput(self, "DNS",
    value=lb.load_balancer_dns_name
)

app = App()
CognitoStack(app, "integ-cognito")
app.synth()
```

> NOTE: this example seems incomplete, I was not able to get the redirect back to the
> Load Balancer after authentication working. Would love some pointers on what a full working
> setup actually looks like!
"""
import abc
import builtins
import datetime
import enum
import typing

import jsii
import jsii.compat
import publication

import aws_cdk.aws_cognito
import aws_cdk.aws_ec2
import aws_cdk.aws_elasticloadbalancingv2
import aws_cdk.aws_iam
import aws_cdk.core
import constructs

from ._jsii import *


class AuthenticateCognitoAction(aws_cdk.aws_elasticloadbalancingv2.ListenerAction, metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoAction"):
    """A Listener Action to authenticate with Cognito."""
    def __init__(self, *, next: aws_cdk.aws_elasticloadbalancingv2.ListenerAction, user_pool: aws_cdk.aws_cognito.IUserPool, user_pool_client: aws_cdk.aws_cognito.IUserPoolClient, user_pool_domain: aws_cdk.aws_cognito.IUserPoolDomain, authentication_request_extra_params: typing.Optional[typing.Mapping[str, str]]=None, on_unauthenticated_request: typing.Optional[aws_cdk.aws_elasticloadbalancingv2.UnauthenticatedAction]=None, scope: typing.Optional[str]=None, session_cookie_name: typing.Optional[str]=None, session_timeout: typing.Optional[aws_cdk.core.Duration]=None) -> None:
        """Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).

        :param next: What action to execute next. Multiple actions form a linked chain; the chain must always terminate in a (weighted)forward, fixedResponse or redirect action.
        :param user_pool: The Amazon Cognito user pool.
        :param user_pool_client: The Amazon Cognito user pool client.
        :param user_pool_domain: The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        :param authentication_request_extra_params: The query parameters (up to 10) to include in the redirect request to the authorization endpoint. Default: - No extra parameters
        :param on_unauthenticated_request: The behavior if the user is not authenticated. Default: UnauthenticatedAction.AUTHENTICATE
        :param scope: The set of user claims to be requested from the IdP. To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP. Default: "openid"
        :param session_cookie_name: The name of the cookie used to maintain session information. Default: "AWSELBAuthSessionCookie"
        :param session_timeout: The maximum duration of the authentication session. Default: Duration.days(7)
        """
        options = AuthenticateCognitoActionProps(next=next, user_pool=user_pool, user_pool_client=user_pool_client, user_pool_domain=user_pool_domain, authentication_request_extra_params=authentication_request_extra_params, on_unauthenticated_request=on_unauthenticated_request, scope=scope, session_cookie_name=session_cookie_name, session_timeout=session_timeout)

        jsii.create(AuthenticateCognitoAction, self, [options])


@jsii.data_type(jsii_type="@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoActionProps", jsii_struct_bases=[], name_mapping={'next': 'next', 'user_pool': 'userPool', 'user_pool_client': 'userPoolClient', 'user_pool_domain': 'userPoolDomain', 'authentication_request_extra_params': 'authenticationRequestExtraParams', 'on_unauthenticated_request': 'onUnauthenticatedRequest', 'scope': 'scope', 'session_cookie_name': 'sessionCookieName', 'session_timeout': 'sessionTimeout'})
class AuthenticateCognitoActionProps():
    def __init__(self, *, next: aws_cdk.aws_elasticloadbalancingv2.ListenerAction, user_pool: aws_cdk.aws_cognito.IUserPool, user_pool_client: aws_cdk.aws_cognito.IUserPoolClient, user_pool_domain: aws_cdk.aws_cognito.IUserPoolDomain, authentication_request_extra_params: typing.Optional[typing.Mapping[str, str]]=None, on_unauthenticated_request: typing.Optional[aws_cdk.aws_elasticloadbalancingv2.UnauthenticatedAction]=None, scope: typing.Optional[str]=None, session_cookie_name: typing.Optional[str]=None, session_timeout: typing.Optional[aws_cdk.core.Duration]=None) -> None:
        """Properties for AuthenticateCognitoAction.

        :param next: What action to execute next. Multiple actions form a linked chain; the chain must always terminate in a (weighted)forward, fixedResponse or redirect action.
        :param user_pool: The Amazon Cognito user pool.
        :param user_pool_client: The Amazon Cognito user pool client.
        :param user_pool_domain: The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        :param authentication_request_extra_params: The query parameters (up to 10) to include in the redirect request to the authorization endpoint. Default: - No extra parameters
        :param on_unauthenticated_request: The behavior if the user is not authenticated. Default: UnauthenticatedAction.AUTHENTICATE
        :param scope: The set of user claims to be requested from the IdP. To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP. Default: "openid"
        :param session_cookie_name: The name of the cookie used to maintain session information. Default: "AWSELBAuthSessionCookie"
        :param session_timeout: The maximum duration of the authentication session. Default: Duration.days(7)
        """
        self._values = {
            'next': next,
            'user_pool': user_pool,
            'user_pool_client': user_pool_client,
            'user_pool_domain': user_pool_domain,
        }
        if authentication_request_extra_params is not None: self._values["authentication_request_extra_params"] = authentication_request_extra_params
        if on_unauthenticated_request is not None: self._values["on_unauthenticated_request"] = on_unauthenticated_request
        if scope is not None: self._values["scope"] = scope
        if session_cookie_name is not None: self._values["session_cookie_name"] = session_cookie_name
        if session_timeout is not None: self._values["session_timeout"] = session_timeout

    @builtins.property
    def next(self) -> aws_cdk.aws_elasticloadbalancingv2.ListenerAction:
        """What action to execute next.

        Multiple actions form a linked chain; the chain must always terminate in a
        (weighted)forward, fixedResponse or redirect action.
        """
        return self._values.get('next')

    @builtins.property
    def user_pool(self) -> aws_cdk.aws_cognito.IUserPool:
        """The Amazon Cognito user pool."""
        return self._values.get('user_pool')

    @builtins.property
    def user_pool_client(self) -> aws_cdk.aws_cognito.IUserPoolClient:
        """The Amazon Cognito user pool client."""
        return self._values.get('user_pool_client')

    @builtins.property
    def user_pool_domain(self) -> aws_cdk.aws_cognito.IUserPoolDomain:
        """The domain prefix or fully-qualified domain name of the Amazon Cognito user pool."""
        return self._values.get('user_pool_domain')

    @builtins.property
    def authentication_request_extra_params(self) -> typing.Optional[typing.Mapping[str, str]]:
        """The query parameters (up to 10) to include in the redirect request to the authorization endpoint.

        default
        :default: - No extra parameters
        """
        return self._values.get('authentication_request_extra_params')

    @builtins.property
    def on_unauthenticated_request(self) -> typing.Optional[aws_cdk.aws_elasticloadbalancingv2.UnauthenticatedAction]:
        """The behavior if the user is not authenticated.

        default
        :default: UnauthenticatedAction.AUTHENTICATE
        """
        return self._values.get('on_unauthenticated_request')

    @builtins.property
    def scope(self) -> typing.Optional[str]:
        """The set of user claims to be requested from the IdP.

        To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.

        default
        :default: "openid"
        """
        return self._values.get('scope')

    @builtins.property
    def session_cookie_name(self) -> typing.Optional[str]:
        """The name of the cookie used to maintain session information.

        default
        :default: "AWSELBAuthSessionCookie"
        """
        return self._values.get('session_cookie_name')

    @builtins.property
    def session_timeout(self) -> typing.Optional[aws_cdk.core.Duration]:
        """The maximum duration of the authentication session.

        default
        :default: Duration.days(7)
        """
        return self._values.get('session_timeout')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AuthenticateCognitoActionProps(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


__all__ = [
    "AuthenticateCognitoAction",
    "AuthenticateCognitoActionProps",
]

publication.publish()
