"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A Listener Action to authenticate with Cognito
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC)
     */
    constructor(options) {
        var _a;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_a = options.sessionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds(),
            },
        }, options.next);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
//# sourceMappingURL=data:application/json;base64,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